/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.context;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.common.exception.HRDIBizException;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hr.hbp.business.log.EntityModifyInfo;

public class IntBizSyncContext {
    private static final Log LOG = LogFactory.getLog(IntBizSyncContext.class);
    private static final ThreadLocal<IntBizSyncContext> THREAD_LOCAL = new ThreadLocal();
    private String bizEntityNumber;
    private String midTableNumber;
    private List<String> fieldNumberList;
    private MidTableConfig midTableConfig;
    private List<IntRowResult> intRowResultList = Lists.newArrayList();
    private List<IntRowResult> sortedIntRowResultList = null;
    private Map<Long, IntRowResult> rowMap = Maps.newHashMap();
    private Map<IntRowResult, EntityModifyInfo> compareMap = Maps.newHashMap();
    private List<String> billHeadFieldList = Lists.newArrayList();
    private Map<String, String> entryFieldMap = Maps.newHashMap();
    private boolean entryIntField = false;
    private Map<String, Map<String, DynamicObject>> basedataMappingMap = new HashMap<String, Map<String, DynamicObject>>(16);
    private Set<String> mulBasedataFieldSet = new HashSet<String>(16);

    public List<String> getFieldNumberList() {
        return this.fieldNumberList;
    }

    public void setFieldNumberList(List<String> fieldNumberList) {
        this.fieldNumberList = fieldNumberList;
    }

    public static IntBizSyncContext create(String midTableNumber, String bizEntityNumber) {
        IntBizSyncContext intBizSyncContext = new IntBizSyncContext();
        intBizSyncContext.midTableNumber = midTableNumber;
        intBizSyncContext.bizEntityNumber = bizEntityNumber;
        THREAD_LOCAL.set(intBizSyncContext);
        return intBizSyncContext;
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    public void addResult(IntRowResult intRowResult) {
        this.intRowResultList.add(intRowResult);
        this.rowMap.put(intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject().getLong("id"), intRowResult);
    }

    public List<IntRowResult> getIntRowResultList() {
        return ImmutableList.copyOf(this.intRowResultList);
    }

    public static IntBizSyncContext get() {
        return THREAD_LOCAL.get();
    }

    public Map<IntRowResult, EntityModifyInfo> getCompareMap() {
        return this.compareMap;
    }

    public Map<Long, IntRowResult> getRowMap() {
        return this.rowMap;
    }

    public String getBizEntityNumber() {
        return this.bizEntityNumber;
    }

    public String getMidTableNumber() {
        return this.midTableNumber;
    }

    public void addSortedIntRowResultList(List<IntRowResult> intRowResultList) {
        if (this.sortedIntRowResultList != null) {
            throw new HRDIBizException("already sorted, should not sort again");
        }
        this.sortedIntRowResultList = intRowResultList;
    }

    public List<IntRowResult> getSortedIntRowResultList() {
        return this.sortedIntRowResultList;
    }

    public MidTableConfig getMidTableConfig() {
        return this.midTableConfig;
    }

    public void setMidTableConfig(MidTableConfig midTableConfig) {
        this.midTableConfig = midTableConfig;
    }

    public List<String> getBillHeadFieldList() {
        return this.billHeadFieldList;
    }

    public void setBillHeadFieldList(List<String> billHeadFieldList) {
        this.billHeadFieldList = billHeadFieldList;
    }

    public Map<String, String> getEntryFieldMap() {
        return this.entryFieldMap;
    }

    public void setEntryFieldMap(Map<String, String> entryFieldMap) {
        this.entryFieldMap = entryFieldMap;
    }

    public boolean isEntryIntField() {
        return this.entryIntField;
    }

    public void setEntryIntField(boolean entryIntField) {
        this.entryIntField = entryIntField;
    }

    public Map<String, Map<String, DynamicObject>> getBasedataMappingMap() {
        return this.basedataMappingMap;
    }

    public void setBasedataMappingMap(Map<String, Map<String, DynamicObject>> basedataMappingMap) {
        this.basedataMappingMap = basedataMappingMap;
    }

    public Set<String> getMulBasedataFieldSet() {
        return this.mulBasedataFieldSet;
    }

    public void setMulBasedataFieldSet(Set<String> mulBasedataFieldSet) {
        this.mulBasedataFieldSet = mulBasedataFieldSet;
    }
}

