/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.covert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncDataMappingBo;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.covert.IRefSelfFieldCovert;

public class RefSelfFieldCovertImpl
implements IRefSelfFieldCovert {
    private static final Log LOG = LogFactory.getLog(RefSelfFieldCovertImpl.class);
    private final MainEntityType midTableEntityType;
    private final List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList;
    private final Map<String, IDataEntityProperty> bizEntityFieldMap;
    private final Set<String> sameTableNameEntityList;
    private final Map<String, String> refSelfFieldMap = new HashMap<String, String>();

    public RefSelfFieldCovertImpl(MainEntityType midTableEntityType, MainEntityType bizEntityType, List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList) {
        this.midTableEntityType = midTableEntityType;
        this.bizDataSyncDataMappingBoList = bizDataSyncDataMappingBoList;
        this.bizEntityFieldMap = bizEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, pro -> pro));
        this.sameTableNameEntityList = MetadataUtils.getEntityNumberBySameTableName((String)bizEntityType.getName());
    }

    @Override
    public void covert() {
        this.findRefSelfField();
        if (CollectionUtils.isEmpty(this.refSelfFieldMap)) {
            return;
        }
        this.covertField();
    }

    private void covertField() {
        LOG.info("RefSelfFieldCovertImpl covertField start.");
        Map<String, Map<String, DynamicObject>> basedataMappingMap = IntBizSyncContext.get().getBasedataMappingMap();
        for (BizDataSyncDataMappingBo bizDataSyncDataMappingBo : this.bizDataSyncDataMappingBoList) {
            DynamicObject bizDyc = bizDataSyncDataMappingBo.getBizDynamicObject();
            List<DynamicObject> midDycList = bizDataSyncDataMappingBo.getMidDynamicObjectList();
            DynamicObject midDyc = midDycList.get(0);
            this.refSelfFieldMap.keySet().forEach(field -> {
                DynamicObject findBizDyc;
                String propName;
                DynamicObject refDyc = bizDyc.getDynamicObject(field);
                String midRefValue = midDyc.getString(field);
                String string = propName = midDyc.getDynamicObjectType().getProperty(field) != null ? "number" : "name";
                if (refDyc == null && StringUtils.isNotEmpty((String)midRefValue) && (findBizDyc = this.findRefDynamicObject(propName, midRefValue)) != null) {
                    DynamicObject bizRefDyc = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.refSelfFieldMap.get(field)));
                    DynamicObjectUtils.copy((DynamicObject)findBizDyc, (DynamicObject)bizRefDyc);
                    bizRefDyc.set("id", findBizDyc.get("id"));
                    bizDyc.set(field, (Object)bizRefDyc);
                    Map basedataValueMap = basedataMappingMap.getOrDefault(field, new HashMap());
                    basedataValueMap.put(midRefValue, bizRefDyc);
                    basedataMappingMap.put((String)field, basedataValueMap);
                }
            });
        }
    }

    private DynamicObject findRefDynamicObject(String propName, String propValue) {
        for (BizDataSyncDataMappingBo bizDataSyncDataMappingBo : this.bizDataSyncDataMappingBoList) {
            DynamicObject bizDynamicObject = bizDataSyncDataMappingBo.getBizDynamicObject();
            if (!StringUtils.equals((String)propValue, (String)bizDynamicObject.getString(propName))) continue;
            return bizDynamicObject;
        }
        return null;
    }

    private void findRefSelfField() {
        LOG.info("RefSelfFieldCovertImpl findRefSelfField start.");
        DataEntityPropertyCollection properties = this.midTableEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            IDataEntityProperty bizProperty = this.bizEntityFieldMap.get(property.getName());
            if (bizProperty == null) continue;
            String baseEntityId = null;
            if (bizProperty instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)bizProperty).getBaseEntityId();
            } else if (bizProperty instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)bizProperty).getBaseEntityId();
            }
            if (!StringUtils.isNotEmpty((String)baseEntityId) || !this.sameTableNameEntityList.contains(baseEntityId)) continue;
            this.refSelfFieldMap.put(bizProperty.getName(), baseEntityId);
        }
    }
}

