/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.IHRICMidTableCovert;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;
import kd.hdtc.hrdi.common.pojo.DataMapping;

public class HRICMidTableCovertImpl
implements IHRICMidTableCovert {
    private static Log LOG = LogFactory.getLog(HRICMidTableCovertImpl.class);
    private final IIntSourceSysDomainService intSourceSysDomainService = ServiceFactory.getService(IIntSourceSysDomainService.class);

    @Override
    public Set<String> parseInitMidTableNumber(Map<String, Set<String>> initMidTableNumberMap) {
        if (CollectionUtils.isEmpty(initMidTableNumberMap)) {
            LOG.info("the HRICMidTableCovertImpl parseInitMidTableNumber param is null");
            return null;
        }
        HashSet initMidTableNumber = Sets.newHashSetWithExpectedSize((int)4);
        initMidTableNumberMap.forEach((initEntityObject, initMidTableNumbers) -> {
            if (CollectionUtils.isNotEmpty((Collection)initMidTableNumbers)) {
                for (String midTableNumber : initMidTableNumbers) {
                    if (!this.isValidMidTableNumber(midTableNumber)) continue;
                    initMidTableNumber.add(midTableNumber);
                }
            }
        });
        return initMidTableNumber;
    }

    @Override
    public List<DataMapping> covert(String entityObjId, List<DynamicObject> midTableDataList, String refMidTableJson) {
        if (CollectionUtils.isEmpty(midTableDataList)) {
            return null;
        }
        Map<String, DynamicObject> sourceSysMap = midTableDataList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("hricsourcesys") != null).collect(Collectors.toMap(midTableData -> midTableData.getString("hricsourcesys.number"), midTableData -> midTableData.getDynamicObject("hricsourcesys"), (v1, v2) -> v1));
        Map<String, DynamicObject> sourSysMap = this.intSourceSysDomainService.querySourceSysByHRICNumber(sourceSysMap);
        ArrayList dataMappings = Lists.newArrayListWithExpectedSize((int)midTableDataList.size());
        for (DynamicObject midTableData2 : midTableDataList) {
            DataMapping dataMapping = new DataMapping();
            DynamicObject sourceSys = sourSysMap.get(midTableData2.getString("hricsourcesys.number"));
            dataMapping.setEntityObjId(entityObjId);
            dataMapping.setBizDataKey(Long.valueOf(midTableData2.getLong("hricbizid")));
            if (sourceSys != null) {
                dataMapping.setSourceSys(sourceSys);
            }
            dataMapping.setSourceDataKey(midTableData2.getString("hricsourcesyskey"));
            dataMappings.add(dataMapping);
        }
        return dataMappings;
    }
}

