/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.application.external.IPersonDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.IHRICMidTableCovert;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;
import kd.hdtc.hrdi.common.pojo.DataMapping;
import kd.hdtc.hrdi.common.pojo.FourFloorPersonIdEntry;

public class HrHRICMidTableCovertImpl
implements IHRICMidTableCovert {
    private static final Log LOG = LogFactory.getLog(HrHRICMidTableCovertImpl.class);
    private final IIntSourceSysDomainService intSourceSysDomainService = ServiceFactory.getService(IIntSourceSysDomainService.class);
    private final IPersonDomainService personDomainService = ServiceFactory.getService(IPersonDomainService.class);
    private static final Set<String> ONBOARDEMPEXP_INIT_ENTITY = ImmutableSet.of((Object)"hrpi_onboardempexp_init", (Object)"hrpi_quitempexp_init");
    private static final String EMP_NUMBER = "empnumber";

    @Override
    public Set<String> parseInitMidTableNumber(Map<String, Set<String>> initMidTableNumberMap) {
        if (CollectionUtils.isEmpty(initMidTableNumberMap)) {
            LOG.info("the HrHRICMidTableCovertImpl parseInitMidTableNumber param is null");
            return null;
        }
        HashSet initMidTableNumber = Sets.newHashSetWithExpectedSize((int)4);
        initMidTableNumberMap.forEach((initEntityObject, midTableNumbers) -> {
            HashSet midTableNumberTpl = Sets.newHashSetWithExpectedSize((int)midTableNumbers.size());
            for (String midTableNumber : midTableNumbers) {
                if (!this.isValidMidTableNumber(midTableNumber)) continue;
                midTableNumberTpl.add(midTableNumber);
            }
            if (ONBOARDEMPEXP_INIT_ENTITY.contains(initEntityObject)) {
                initMidTableNumber.addAll(midTableNumberTpl);
            }
        });
        return initMidTableNumber;
    }

    @Override
    public List<DataMapping> covert(String entityObjId, List<DynamicObject> midTableDataList, String refMidTableJson) {
        if (CollectionUtils.isEmpty(midTableDataList)) {
            return null;
        }
        Map<String, DynamicObject> sourceSysMap = midTableDataList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("hricsourcesys") != null).collect(Collectors.toMap(midTableData -> midTableData.getString("hricsourcesys.number"), midTableData -> midTableData.getDynamicObject("hricsourcesys"), (v1, v2) -> v1));
        Map<String, DynamicObject> sourSysMap = this.intSourceSysDomainService.querySourceSysByHRICNumber(sourceSysMap);
        ArrayList dataMappingList = Lists.newArrayListWithExpectedSize((int)midTableDataList.size());
        ArrayList depempIdList = Lists.newArrayListWithExpectedSize((int)midTableDataList.size());
        for (DynamicObject depMidTableData : midTableDataList) {
            String depMidTableNumber = depMidTableData.getString(EMP_NUMBER);
            DynamicObject sourceSys = sourSysMap.get(depMidTableData.getString("hricsourcesys.number"));
            DataMapping dataMapping2 = new DataMapping();
            dataMapping2.setNumber(depMidTableNumber);
            dataMapping2.setEntityObjId(entityObjId);
            dataMapping2.setEffectiveStatus("2");
            if (sourceSys != null) {
                dataMapping2.setSourceSys(sourceSys);
            }
            dataMapping2.setSourceDataKey(depMidTableData.getString("hricsourcesyskey"));
            dataMapping2.setBizDataKey(Long.valueOf(depMidTableData.getLong("hricbizid")));
            dataMapping2.setDepempId(Long.valueOf(depMidTableData.getLong("hricbizid")));
            depempIdList.add(dataMapping2.getDepempId());
            dataMappingList.add(dataMapping2);
        }
        Map<Long, FourFloorPersonIdEntry> fourPersonIdMap = this.personDomainService.getFourPersonIds(depempIdList);
        dataMappingList.forEach(dataMapping -> {
            FourFloorPersonIdEntry fourFloorPerson = (FourFloorPersonIdEntry)fourPersonIdMap.get(dataMapping.getDepempId());
            if (fourFloorPerson == null) {
                return;
            }
            dataMapping.setPersonId(fourFloorPerson.getPersonId());
            dataMapping.setEmployeeId(fourFloorPerson.getEmployeeId());
            dataMapping.setCmpempId(fourFloorPerson.getCmpempId());
        });
        return dataMappingList;
    }

    @Override
    public String queryFields() {
        return "id, hricsourcesys, hricsourcesys.number, hricsourcesyskey, hricbizid, empnumber";
    }
}

