/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.handle;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.handle.IMidHandle;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hdtc.hrdi.common.pojo.MidTableConfigField;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractMidHandle
implements IMidHandle {
    protected static final Log LOG = LogFactory.getLog(AbstractMidHandle.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    protected static final String IDMAPPING = "idmapping";
    protected String entityCode;
    protected String businessKey;
    protected String midTableNumber;
    protected MainEntityType dataEntityType;
    protected DynamicObject[] currHandleBatchData;
    protected Set<String> entityOnlyKeySet;
    protected Map<Long, Set<Long>> pkRelMap = new HashMap<Long, Set<Long>>();
    protected Map<String, String> midTblAndEntityMappingMap;
    protected Map<String, List<DynamicObject>> baseDataMap = new HashMap<String, List<DynamicObject>>();
    protected DataEntityPropertyCollection midTblProps;
    protected MidTableConfig midTableConfig;
    protected List<DynamicObject> entityDycList = new ArrayList<DynamicObject>();
    protected Set<String> midTableFieldSet = new HashSet<String>();
    protected Set<String> bizEntityFieldSet;
    protected Map<String, String> bdFieldMap = Maps.newHashMap();
    protected Map<String, Map<String, DynamicObject>> basedataMappingMap = new HashMap<String, Map<String, DynamicObject>>(16);
    protected Set<String> mulBasedataFieldSet = new HashSet<String>(16);

    public AbstractMidHandle(String entityCode, String businessKey, MainEntityType dataEntityType, String midTableNumber) {
        this.entityCode = entityCode;
        this.businessKey = businessKey;
        this.dataEntityType = dataEntityType;
        this.midTableNumber = midTableNumber;
        this.midTblAndEntityMappingMap = this.iBaseCommonDomainService.getMidTableAndEntityMappingWithoutName(midTableNumber);
        this.entityOnlyKeySet = ImmutableSet.of((Object)businessKey, (Object)"hrdibatchnumber");
        this.midTblProps = MetadataServiceHelper.getDataEntityType((String)midTableNumber).getProperties();
        this.bizEntityFieldSet = MetadataServiceHelper.getDataEntityType((String)entityCode).getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
    }

    @Override
    public Map<String, Object> handleData(DynamicObject[] dys) {
        this.init();
        this.currHandleBatchData = dys;
        this.buildFieldConfigMap();
        this.loadBasedata();
        this.structBizEntity();
        if (CollectionUtils.isEmpty(this.entityDycList)) {
            return new HashMap<String, Object>(16);
        }
        this.dynamicObjectSort(this.entityDycList);
        IntBizSyncContext.get().setBasedataMappingMap(this.basedataMappingMap);
        IntBizSyncContext.get().setMulBasedataFieldSet(this.mulBasedataFieldSet);
        return ImmutableMap.of((Object)"data", this.entityDycList, (Object)IDMAPPING, this.pkRelMap);
    }

    private void buildFieldConfigMap() {
        if (this.midTableConfig != null) {
            for (MidTableConfigField midTableConfigField : this.midTableConfig.getFieldConfigList()) {
                if (!midTableConfigField.isIntField() || midTableConfigField.isTableHead() || !midTableConfigField.isBaseData()) continue;
                String importProp = midTableConfigField.getRefProp();
                String fieldName = midTableConfigField.getNumberAlias();
                this.bdFieldMap.put(fieldName, importProp);
            }
        }
    }

    private String getBaseDataQueryProp(String entryEntityNumber, String importProp) {
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataUtils.getMainEntityType((String)entryEntityNumber);
        if (!AbstractMidHandle.entityContainsNumberAndName(dataEntityType)) {
            if ("number".equals(importProp)) {
                return dataEntityType.getNumberProperty();
            }
            if ("name".equals(importProp)) {
                return dataEntityType.getNameProperty();
            }
        }
        return importProp;
    }

    public static boolean entityContainsNumberAndName(BasedataEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty numberProp = (IDataEntityProperty)properties.get((Object)"number");
        IDataEntityProperty nameProp = (IDataEntityProperty)properties.get((Object)"name");
        return Objects.nonNull(numberProp) && Objects.nonNull(nameProp) && HRStringUtils.isNotEmpty((String)numberProp.getAlias());
    }

    @Override
    public Map<String, Object> handleData(DynamicObject[] dys, MidTableConfig midTableConfig) {
        this.midTableConfig = midTableConfig;
        return this.handleData(dys);
    }

    protected abstract void init();

    protected abstract void structBizEntity();

    protected abstract void loadBasedata();

    protected void baseDataMapSetVal(Set<String> fieldValSet, String entityType, String fieldName, String belongEntityCode, String queryProp) {
        if (this.isEmptyFieldValSet(fieldValSet)) {
            return;
        }
        List<DynamicObject> dys = this.baseDataMap.get(entityType);
        if (!CollectionUtils.isEmpty(dys)) {
            dys.addAll(this.iBaseCommonDomainService.loadBaseDataFromDBWithRefProp(queryProp, entityType, fieldValSet, fieldName, belongEntityCode));
            Map<Long, DynamicObject> dycMap = dys.stream().collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc, (k1, k2) -> k1));
            this.baseDataMap.put(entityType, dycMap.values().stream().collect(Collectors.toList()));
        } else {
            this.baseDataMap.put(entityType, this.iBaseCommonDomainService.loadBaseDataFromDBWithRefProp(queryProp, entityType, fieldValSet, fieldName, belongEntityCode));
        }
    }

    private boolean isEmptyFieldValSet(Set<String> fieldValSet) {
        for (String fieldVal : fieldValSet) {
            if (!StringUtils.isNotEmpty((String)fieldVal)) continue;
            return false;
        }
        return true;
    }

    protected void distributeMainEntity(DynamicObject dy, Map<String, List<DynamicObject>> midTblDataMap) {
        StringBuilder sb = new StringBuilder();
        this.entityOnlyKeySet.forEach(it -> sb.append(dy.getString(it)).append('|'));
        String key = sb.toString();
        if (!midTblDataMap.containsKey(key)) {
            midTblDataMap.put(key, new ArrayList());
        }
        midTblDataMap.get(key).add(dy);
    }

    protected long getId(List<DynamicObject> midList, long id) {
        if (CollectionUtils.isEmpty(midList)) {
            return id;
        }
        return id;
    }

    protected void valueConvert(DynamicObject midDyc, DynamicObject bizDyc, IDataEntityProperty property) {
        String propName = this.entityField2MidTblField(property);
        if (!this.checkValue(midDyc, property, propName)) {
            return;
        }
        String midDycFieldVal = midDyc.getString(propName);
        if (property instanceof BasedataProp) {
            if (HRStringUtils.isNotEmpty((String)midDycFieldVal)) {
                this.baseDataHandle(bizDyc, midDycFieldVal, this.baseDataMap.get(((BasedataProp)property).getBaseEntityId()), propName);
            } else {
                bizDyc.set(property.getName(), null);
            }
        } else if (property instanceof MulBasedataProp) {
            if (HRStringUtils.isNotEmpty((String)(midDycFieldVal = midDycFieldVal + "," + midDyc.getString(propName + "_tag")))) {
                this.mulBaseDataHandle(bizDyc, midDycFieldVal, this.baseDataMap.get(((MulBasedataProp)property).getBaseEntityId()), propName);
            }
        } else {
            bizDyc.set(property.getName(), midDyc.get(propName));
        }
    }

    private boolean checkValue(DynamicObject midDyc, IDataEntityProperty property, String propName) {
        if (ObjectUtils.isEmpty((Object)midDyc.get(propName))) {
            return false;
        }
        return !(property instanceof TimeProp) || midDyc.getInt(propName) != -1;
    }

    protected void baseDataHandle(DynamicObject bizDyc, String dycFieldVal, List<DynamicObject> dys, String propName) {
        if (CollectionUtils.isEmpty(dys)) {
            return;
        }
        String entityNumber = dys.get(0).getDataEntityType().getName();
        String importProp = this.getBaseDataQueryProp(entityNumber, this.bdFieldMap.get(propName));
        DataEntityPropertyCollection bizDycProperties = bizDyc.getDynamicObjectType().getProperties();
        Map basedataValueMap = this.basedataMappingMap.getOrDefault(propName, new HashMap());
        for (DynamicObject dyc : dys) {
            if (!HRStringUtils.equals((String)dycFieldVal, (String)dyc.getString(importProp))) continue;
            basedataValueMap.put(dycFieldVal, dyc);
            this.basedataMappingMap.put(propName, basedataValueMap);
            if (!bizDycProperties.containsKey((Object)propName)) {
                bizDyc.set(this.midTblField2EntityField(propName), (Object)dyc);
                return;
            }
            bizDyc.set(propName, (Object)dyc);
            return;
        }
    }

    protected void mulBaseDataHandle(DynamicObject bizDyc, String dycFieldVal, List<DynamicObject> dys, String propName) {
        DynamicObjectCollection docs = bizDyc.getDynamicObjectCollection(propName);
        Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
        ArrayList fieldValList = Lists.newArrayList((Iterable)splitter.splitToList((CharSequence)dycFieldVal));
        Map basedataValueMap = this.basedataMappingMap.getOrDefault(propName, new HashMap());
        this.mulBasedataFieldSet.add(propName);
        fieldValList.forEach(val -> {
            for (DynamicObject dyc : dys) {
                if (!HRStringUtils.equals((String)val, (String)dyc.getString("number")) && !HRStringUtils.equals((String)val, (String)dyc.getString("name"))) continue;
                basedataValueMap.put(val, dyc);
                this.basedataMappingMap.put(propName, basedataValueMap);
                DynamicObject dy = new DynamicObject(docs.getDynamicObjectType());
                dy.set("fbasedataid", (Object)dyc);
                docs.add((Object)dy);
                break;
            }
        });
        DataEntityPropertyCollection bizDycProperties = bizDyc.getDynamicObjectType().getProperties();
        if (!bizDycProperties.containsKey((Object)propName)) {
            bizDyc.set(this.midTblField2EntityField(propName), (Object)docs);
        } else {
            bizDyc.set(propName, (Object)docs);
        }
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            bizDyc.getDataEntityState().setDirty(true);
        }
    }

    private void dynamicObjectSort(List<DynamicObject> entityDycList) {
        entityDycList.sort((dyc1, dyc2) -> {
            Long dycId1 = this.pkRelMap.get(dyc1.getLong("id")).stream().findFirst().orElse(0L);
            Long dycId2 = this.pkRelMap.get(dyc2.getLong("id")).stream().findFirst().orElse(0L);
            return dycId1.compareTo(dycId2);
        });
    }

    protected void handleBaseDataOrMulBaseData(Map<String, IDataEntityProperty> entityFieldMap, String fieldName, IDataEntityProperty prop) {
        String belongEntityCode = this.getBelongEntityCode(prop);
        HashSet<String> fieldValSet = new HashSet<String>();
        if (prop instanceof BasedataProp) {
            Arrays.stream(this.currHandleBatchData).map(dyc -> dyc.getString(fieldName)).forEach(fieldVal -> fieldValSet.add((String)fieldVal));
            String fieldNameCopy = this.midTblField2EntityField(entityFieldMap, fieldName);
            String entityType = ((BasedataProp)entityFieldMap.get(fieldNameCopy)).getBaseEntityId();
            String importProp = this.getBaseDataQueryProp(entityType, this.bdFieldMap.get(fieldName));
            this.baseDataMapSetVal(fieldValSet, entityType, fieldNameCopy, belongEntityCode, importProp);
        } else if (prop instanceof MulBasedataProp) {
            Arrays.stream(this.currHandleBatchData).map(dyc -> dyc.getString(fieldName) + "," + dyc.getString(fieldName + "_tag")).forEach(fieldVal -> fieldValSet.addAll(new HashSet(Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)fieldVal)))));
            String fieldNameCopy = this.midTblField2EntityField(entityFieldMap, fieldName);
            String entityType = ((MulBasedataProp)entityFieldMap.get(fieldNameCopy)).getBaseEntityId();
            String importProp = this.getBaseDataQueryProp(entityType, this.bdFieldMap.get(fieldName));
            this.baseDataMapSetVal(fieldValSet, entityType, fieldNameCopy, belongEntityCode, importProp);
        }
    }

    protected abstract String getBelongEntityCode(IDataEntityProperty var1);

    protected String midTblField2EntityField(Map<String, IDataEntityProperty> entityFieldMap, String fieldName) {
        IDataEntityProperty property = entityFieldMap.get(fieldName);
        String fieldVal = this.midTblAndEntityMappingMap.get(fieldName);
        if (property == null && HRStringUtils.isNotEmpty((String)fieldVal)) {
            ArrayList entryFieldNameList = Lists.newArrayList((Iterable)Splitter.on((String)".").trimResults().omitEmptyStrings().splitToList((CharSequence)fieldVal));
            return (String)entryFieldNameList.get(1);
        }
        return fieldName;
    }

    private String midTblField2EntityField(String fieldName) {
        String fieldVal = this.midTblAndEntityMappingMap.get(fieldName);
        if (HRStringUtils.isNotEmpty((String)fieldVal)) {
            ArrayList entryFieldNameList = Lists.newArrayList((Iterable)Splitter.on((String)".").trimResults().omitEmptyStrings().splitToList((CharSequence)fieldVal));
            return (String)entryFieldNameList.get(1);
        }
        return fieldName;
    }

    protected String entityField2MidTblField(IDataEntityProperty property) {
        String propertyName = property.getName();
        String belongEntityName = property.getParent().getName();
        Optional<String> midTblFieldName = this.midTblAndEntityMappingMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).contains(belongEntityName + "." + propertyName)).map(entry -> (String)entry.getKey()).findFirst();
        if (midTblFieldName.isPresent()) {
            return midTblFieldName.get();
        }
        return propertyName;
    }
}

