/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.handle;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdi.business.domain.adaptor.handle.AbstractMidHandle;
import kd.hr.hbp.common.util.HRStringUtils;

public class MidTblHandleEntity
extends AbstractMidHandle {
    private Map<String, IDataEntityProperty> billHeadFieldMap = new HashMap<String, IDataEntityProperty>();
    private Map<String, Map<String, IDataEntityProperty>> billEntryFieldMap = new HashMap<String, Map<String, IDataEntityProperty>>();
    private Map<String, Set<String>> midTblEntryFieldMap = new HashMap<String, Set<String>>();
    private Set<String> ENTRY_FILTER_FIELD = Sets.newHashSet((Object[])new String[]{"id", "seq"});

    public MidTblHandleEntity(String entityCode, String businessKey, MainEntityType dataEntityType, String midTableNumber) {
        super(entityCode, businessKey, dataEntityType, midTableNumber);
    }

    @Override
    protected void init() {
        this.handleBill();
        this.setNumberList();
        this.handleMidTblField();
    }

    private void handleMidTblField() {
        LOG.info("MidTblOpHandleEntity handleBill start.");
        Set<String> billHeadFieldSet = this.billHeadFieldMap.keySet();
        this.midTblProps.stream().map(IMetadata::getName).filter(pro -> !HRStringUtils.equals((String)pro, (String)"id")).forEach(field -> {
            if (billHeadFieldSet.contains(field) && !"multilanguagetext".equals(field)) {
                this.midTableFieldSet.add(field);
                return;
            }
            this.billEntryFieldMap.forEach((key, value) -> {
                Set entryKeySet = value.keySet();
                if (entryKeySet.contains(field) && !"multilanguagetext".equals(field)) {
                    if (this.midTblEntryFieldMap.containsKey(key)) {
                        this.midTblEntryFieldMap.get(key).add((String)field);
                    } else {
                        HashSet<String> midTblEntryFieldSet = new HashSet<String>();
                        midTblEntryFieldSet.add((String)field);
                        this.midTblEntryFieldMap.put((String)key, (Set<String>)midTblEntryFieldSet);
                    }
                }
            });
        });
    }

    @Override
    protected void loadBasedata() {
        LOG.info("MidTblOpHandleEntity loadBasedata start.");
        this.loadBasedata(this.billHeadFieldMap, this.midTableFieldSet);
        if (ObjectUtils.isEmpty(this.billEntryFieldMap)) {
            return;
        }
        this.billEntryFieldMap.entrySet().forEach(entry -> this.midTblEntryFieldMap.entrySet().stream().filter(it -> HRStringUtils.equals((String)((String)it.getKey()), (String)((String)entry.getKey()))).forEach(it -> this.loadBasedata((Map)entry.getValue(), (Set)it.getValue())));
    }

    private void loadBasedata(Map<String, IDataEntityProperty> billFieldMap, Set<String> midTblHeadFieldSet) {
        billFieldMap.entrySet().forEach(entry -> {
            String fieldName = (String)entry.getKey();
            IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
            if (midTblHeadFieldSet.contains(fieldName)) {
                this.handleBaseDataOrMulBaseData(billFieldMap, fieldName, prop);
            }
        });
    }

    @Override
    protected String getBelongEntityCode(IDataEntityProperty prop) {
        return this.entityCode;
    }

    @Override
    protected void structBizEntity() {
        LOG.info("MidTblOpHandleEntity structBizEntity start.");
        HashMap midTblDataMap = Maps.newHashMap();
        Stream.of(this.currHandleBatchData).forEach(dy -> this.distributeMainEntity((DynamicObject)dy, midTblDataMap));
        long[] ids = ORM.create().genLongIds(this.entityCode, midTblDataMap.size());
        int index = 0;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityCode);
        for (Map.Entry it : midTblDataMap.entrySet()) {
            DynamicObject midDyc = (DynamicObject)((List)it.getValue()).get(0);
            DynamicObject bizDyc = new DynamicObject((DynamicObjectType)dataEntityType);
            this.midTableFieldSet.forEach(field -> this.valueConvert(midDyc, bizDyc, this.billHeadFieldMap.get(field)));
            this.sysFieldHandle(bizDyc, midDyc);
            HashSet<Long> midTblIdSet = new HashSet<Long>();
            midTblIdSet.add(midDyc.getLong("id"));
            if (!CollectionUtils.isEmpty(this.billEntryFieldMap)) {
                ((List)it.getValue()).forEach(entry -> this.midTblEntryFieldMap.forEach((key, entryFieldSet) -> {
                    DynamicObjectCollection docs = bizDyc.getDynamicObjectCollection(key);
                    DynamicObject entryEntity = new DynamicObject(docs.getDynamicObjectType());
                    entryFieldSet.forEach(field -> this.valueConvert((DynamicObject)entry, entryEntity, this.billEntryFieldMap.get(key).get(field)));
                    if (this.isDataEntityDirty(entryEntity)) {
                        bizDyc.getDynamicObjectCollection(key).add((Object)entryEntity);
                        this.specialFieldHandle((DynamicObject)entry, entryEntity, (Set<String>)entryFieldSet, (String)key);
                    }
                    midTblIdSet.add(entry.getLong("id"));
                }));
            }
            long id = this.getId((List)it.getValue(), ids[index++]);
            bizDyc.set("id", (Object)id);
            this.pkRelMap.put(id, midTblIdSet);
            this.entityDycList.add(bizDyc);
        }
    }

    private void specialFieldHandle(DynamicObject midDyc, DynamicObject bizDyc, Set<String> entryFieldSet, String key) {
        entryFieldSet.forEach(field -> {
            IDataEntityProperty property = this.billEntryFieldMap.get(key).get(field);
            String propName = this.entityField2MidTblField(property);
            if (property instanceof TimeProp && midDyc.getInt(propName) == -1) {
                bizDyc.set(property.getName(), (Object)-1);
            }
        });
    }

    private boolean isDataEntityDirty(DynamicObject entryEntity) {
        return entryEntity.getDataEntityState().getDataEntityDirty();
    }

    private void sysFieldHandle(DynamicObject bizDyc, DynamicObject midDyc) {
        if (this.bizEntityFieldSet.contains("initdatasource")) {
            bizDyc.set("initdatasource", (Object)"2");
        }
        if (this.bizEntityFieldSet.contains("initstatus")) {
            bizDyc.set("initstatus", (Object)"2");
        }
    }

    private void setNumberList() {
    }

    private void handleBill() {
        LOG.info("MidTblOpHandleEntity handleBill start.");
        this.billHeadFieldMap = this.dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, pro -> pro));
        List<IDataEntityProperty> entryPropList = this.billHeadFieldMap.values().stream().filter(pro -> pro instanceof EntryProp).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entryPropList)) {
            return;
        }
        entryPropList.forEach(entryProp -> {
            HashMap entryPropFieldMap = new HashMap(16);
            ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties().stream().filter(pro -> !this.ENTRY_FILTER_FIELD.contains(pro.getName())).forEach(pro -> entryPropFieldMap.put(pro.getName(), pro));
            this.billEntryFieldMap.put(entryProp.getName(), entryPropFieldMap);
            this.billHeadFieldMap.remove(entryProp.getName());
        });
    }
}

