/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.IIscCopyTriggerDomainService;
import kd.hdtc.hrdi.business.application.external.IIscExternalApiDomainService;
import kd.hdtc.hrdi.business.application.external.IIscServiceFlowDomainService;
import kd.hdtc.hrdi.business.application.external.IOpenAPIDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBasicCommonIntDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.basedata.defaultextplugin.DefaultBaseDataBeforeInvokeApiExtend;
import kd.hdtc.hrdi.business.domain.apilink.IAPILinkConfigDomainService;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.hdtc.hrdi.adaptor.extend.IBaseDataBeforeInvokeApiExtend;
import kd.sdk.hdtc.hrdi.adaptor.model.BaseDataBeforeInvokeApiArgs;

public class BasicCommonIntDomainServiceImpl
implements IBasicCommonIntDomainService {
    private static final Log logger = LogFactory.getLog(BasicCommonIntDomainServiceImpl.class);
    private final IIscServiceFlowDomainService serviceFlowDomainService = ServiceFactory.getService(IIscServiceFlowDomainService.class);
    private final IIscExternalApiDomainService iIscExternalApiDomainService = ServiceFactory.getService(IIscExternalApiDomainService.class);
    private final IIscCopyTriggerDomainService iIscCopyTriggerDomainService = ServiceFactory.getService(IIscCopyTriggerDomainService.class);
    private final IOpenAPIDomainService openAPIDomainService = ServiceFactory.getService(IOpenAPIDomainService.class);
    private final IAPILinkConfigDomainService configDomainService = ServiceFactory.getService(IAPILinkConfigDomainService.class);
    private final String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u201c\u82cd\u7a79API\u8fde\u63a5\u914d\u7f6e\u201d\uff0c\u518d\u8fdb\u884c\u96c6\u6210\u3002", (String)"OutCommonIntDomainServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);

    @Override
    public String basicOutIntHandle(DynamicObject intRelation, String entityNumber, List<String> businessKeys, String operation) {
        String intType = intRelation.getString("inttype");
        DynamicObject intScm = intRelation.getDynamicObject("intscm");
        logger.info("outCommonIntHandle entityNumber={},intType={},intScm={}", new Object[]{entityNumber, intType, intScm == null ? "" : intScm.getString("number")});
        String errorInfo = "";
        if (StringUtils.isNotEmpty((String)intType) && intScm != null) {
            String intScmNumber = intScm.getString("number");
            Object result = null;
            switch (intType) {
                case "isc_data_copy_trigger": {
                    logger.info("outCommonIntHandle execute isc_data_copy_trigger trigger={}", (Object)intScmNumber);
                    HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
                    paramMap.put("id", "[" + String.join((CharSequence)",", businessKeys) + "]");
                    result = this.iIscCopyTriggerDomainService.execute(intScmNumber, paramMap, null);
                    logger.info("outCommonIntHandle execute isc_data_copy_trigger trigger={},result={}", (Object)intScmNumber, result);
                    break;
                }
                case "isc_service_flow": {
                    logger.info("outCommonIntHandle execute isc_service_flow flow={}", (Object)intScmNumber);
                    ArrayList<Object> flowParamList = new ArrayList<Object>();
                    flowParamList.add(entityNumber);
                    flowParamList.add(operation);
                    flowParamList.add(businessKeys);
                    result = this.serviceFlowDomainService.invokeServiceFlow(intScmNumber, flowParamList);
                    errorInfo = ((Map)((Map)((Map)((Map)result.get("output")).get("rtn")).get("data")).get("result")).get("errorMsg") + "";
                    logger.info("outCommonIntHandle execute isc_service_flow flow={},result={}", (Object)intScmNumber, result);
                    break;
                }
                case "isc_apic_for_external_api": {
                    logger.info("outCommonIntHandle execute isc_apic_for_external_api api={}", (Object)intScmNumber);
                    List<Map<String, Object>> externalApiMapList = this.iIscExternalApiDomainService.toExternalApiMapList(entityNumber, businessKeys, operation, "number");
                    BaseDataBeforeInvokeApiArgs args = this.beforeInvokeApiExtendHandle(entityNumber, operation, externalApiMapList);
                    if (!CollectionUtils.isNotEmpty((Collection)args.getDataList())) break;
                    Object[] apiParams = new Object[]{args.getEntityNumber(), operation, "number", externalApiMapList};
                    result = this.iIscExternalApiDomainService.invokeBizService(intScmNumber, apiParams);
                    logger.info("handleEvent execute isc_apic_for_external_api api={},result={}", (Object)intScmNumber, result);
                    errorInfo = this.parseOpenApiResult(result);
                    break;
                }
                case "open_apiservice": {
                    Map<String, Object> dataMap = this.buildDataMap(entityNumber, businessKeys, operation);
                    errorInfo = this.callOpenApi(intRelation, dataMap);
                    break;
                }
            }
        }
        return errorInfo;
    }

    private Map<String, Object> buildDataMap(String entityNumber, List<String> businessKeys, String operation) {
        List<Map<String, Object>> externalApiMapList = this.iIscExternalApiDomainService.toExternalApiMapList(entityNumber, businessKeys, operation, "number");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)4);
        dataMap.put("entityNumber", entityNumber);
        dataMap.put("opType", operation);
        dataMap.put("uniqueField", "number");
        dataMap.put("data", externalApiMapList);
        return dataMap;
    }

    private BaseDataBeforeInvokeApiArgs beforeInvokeApiExtendHandle(String entityNumber, String operation, List<Map<String, Object>> data) {
        BaseDataBeforeInvokeApiArgs args = new BaseDataBeforeInvokeApiArgs();
        args.setDataList(data);
        args.setEntityNumber(entityNumber);
        args.setOperation(operation);
        logger.info("beforeInvokeApiExtendHandle entityNumber:{},operation:{},data:{}", new Object[]{entityNumber, operation, data});
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new DefaultBaseDataBeforeInvokeApiExtend(), IBaseDataBeforeInvokeApiExtend.class, (String)"kd.sdk.hdtc.hrdi.adaptor.extend.IBaseDataBeforeInvokeApiExtend", null);
        pluginProxy.callReplaceIfPresent(extend -> {
            extend.beforeInvokeApi(args);
            return null;
        });
        logger.info("afterInvokeApiExtendHandle entityNumber:{},operation:{},data:{}", new Object[]{args.getEntityNumber(), args.getOperation(), args.getDataList()});
        return args;
    }

    private String callOpenApi(DynamicObject intRelation, Map<String, Object> dataMap) {
        DynamicObject apiLinkConfig = intRelation.getDynamicObject("sourcesys").getDynamicObject("apilinkconfig");
        if (apiLinkConfig == null) {
            logger.error("callOpenApi error, cannot find api link config.");
            return this.errorMsg;
        }
        DynamicObject dbApiLinkDyn = this.configDomainService.queryById(apiLinkConfig.getLong("id"));
        String msg = this.openAPIDomainService.doPost(dbApiLinkDyn, dataMap);
        if (StringUtils.isNotEmpty((String)msg)) {
            logger.error("callOpenApi error,result={}", (Object)msg);
        }
        return this.parseOpenApiResult(msg);
    }

    private String parseOpenApiResult(Object msg) {
        Object result;
        Map map;
        if (msg instanceof String) {
            map = (Map)JSONObject.parseObject((String)((String)msg), Map.class);
        } else if (msg instanceof Map) {
            map = (Map)msg;
        } else {
            logger.error("Can not support ApiResult type, result:{}", msg);
            return null;
        }
        Object data = map.get("data");
        if (data instanceof JSONObject) {
            Object result2 = ((JSONObject)data).get((Object)"result");
            if (result2 instanceof JSONObject) {
                Object errorMsg = ((JSONObject)result2).get((Object)"errorMsg");
                return errorMsg == null ? "" : errorMsg.toString();
            }
        } else if (data instanceof Map && (result = ((Map)data).get("result")) instanceof Map) {
            Object errorMsg = ((Map)result).get("errorMsg");
            return errorMsg == null ? "" : errorMsg.toString();
        }
        return "";
    }
}

