/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.impl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBizSyncDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncBoBuilder;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncResultBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncWithNoSaveMidTableBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.BizDataRetrySyncBo;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;
import kd.hdtc.hrdi.common.core.enums.ErrorEnum;
import kd.hdtc.hrdi.common.exception.HRDIBizException;

public class BizSyncDomainServiceImpl
implements IBizSyncDomainService {
    private static final Log LOG = LogFactory.getLog(BizSyncDomainServiceImpl.class);
    private final IMidTableConfigEntityService iMidTableConfigEntityService = ServiceFactory.getService(IMidTableConfigEntityService.class);

    @Override
    public BizDataSyncResultBo bizSync(String midTableNumber, String batchNumber, List<Long> intMiddleIdList, DynamicObject[] midTableDyns, String synType) {
        long start = System.currentTimeMillis();
        LOG.info(ResManager.loadKDString((String)"bizSync HRDI\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u5f00\u59cb\uff0c midTableNumber = {}, batchNumber= {}", (String)"BizSyncDomainServiceImpl1", (String)"hdtc-hrdi-business", (Object[])new Object[0]), (Object)midTableNumber, (Object)batchNumber);
        if (StringUtils.isEmpty((String)batchNumber)) {
            throw new HRDIBizException("batch number should not be null");
        }
        String bizEntityNumber = this.iMidTableConfigEntityService.queryEntityIdByMidTableNumber(midTableNumber);
        if (StringUtils.isEmpty((String)bizEntityNumber)) {
            throw new HRDIBizException(ErrorEnum.METADATA_NOT_EXIST_ERROR, new Object[]{bizEntityNumber});
        }
        BizDataSyncBo bizDataSyncBo = new BizDataSyncBoBuilder().setMidTableNumber(midTableNumber).setBizEntityNumber(bizEntityNumber).setBatchNumber(batchNumber).setIntMiddleIdList(intMiddleIdList).setMidTableDyns(midTableDyns).setSynType(synType).build();
        BizDataSyncResultBo resultBo = bizDataSyncBo.syncBiz();
        LOG.info(ResManager.loadKDString((String)"bizSync HRDI\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u7ed3\u675f\uff0c \u8017\u65f6{}s", (String)"BizSyncDomainServiceImpl2", (String)"hdtc-hrdi-business", (Object[])new Object[0]), (Object)((System.currentTimeMillis() - start) / 1000L));
        return resultBo;
    }

    @Override
    public BizDataSyncResultBo bizSyncWithNoSaveMidTable(String entityNumber, String batchNumber, DynamicObject[] midTableDyns, String synType) {
        long start = System.currentTimeMillis();
        LOG.info(ResManager.loadKDString((String)"bizSyncWithNoSaveMidTable HRDI\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u5f00\u59cb\uff0c midTableNumber = {}, batchNumber= {}", (String)"BizSyncDomainServiceImpl1", (String)"hdtc-hrdi-business", (Object[])new Object[0]), (Object)entityNumber, (Object)batchNumber);
        if (StringUtils.isEmpty((String)batchNumber)) {
            throw new HRDIBizException("batch number should not be null");
        }
        String bizEntityNumber = this.iMidTableConfigEntityService.queryEntityIdByMidTableNumber(entityNumber);
        if (StringUtils.isEmpty((String)bizEntityNumber)) {
            throw new HRDIBizException(ErrorEnum.METADATA_NOT_EXIST_ERROR, new Object[]{bizEntityNumber});
        }
        BizDataSyncBoBuilder bizDataSyncBoBuilder = new BizDataSyncBoBuilder().setMidTableNumber(entityNumber).setBizEntityNumber(bizEntityNumber).setBatchNumber(batchNumber).setMidTableDyns(midTableDyns).setSynType(synType);
        BizDataSyncWithNoSaveMidTableBo bizDataSyncBo = new BizDataSyncWithNoSaveMidTableBo(bizDataSyncBoBuilder);
        BizDataSyncResultBo resultBo = bizDataSyncBo.syncBiz();
        LOG.info(ResManager.loadKDString((String)"bizSyncWithNoSaveMidTable HRDI\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u7ed3\u675f\uff0c \u8017\u65f6{}s", (String)"BizSyncDomainServiceImpl2", (String)"hdtc-hrdi-business", (Object[])new Object[0]), (Object)((System.currentTimeMillis() - start) / 1000L));
        return resultBo;
    }

    @Override
    public BizDataSyncResultBo bizRetrySync(Long intLogId, DynamicObject intSource, String batchNumber, String startNumber, String endNumber, String selectNumber) {
        long start = System.currentTimeMillis();
        LOG.info(ResManager.loadKDString((String)"HRDI\u91cd\u8bd5\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u5f00\u59cb\uff0cbatchNumber= {}\uff0cstartNumber={}\uff0cendNumber={}\uff0cselectNumber={}", (String)"BizSyncDomainServiceImpl1", (String)"hdtc-hrdi-business", (Object[])new Object[0]), new Object[]{batchNumber, startNumber, endNumber, selectNumber});
        if (StringUtils.isEmpty((String)batchNumber)) {
            throw new HRDIBizException("batch number should not be null");
        }
        if (intSource == null) {
            throw new HRDIBizException("intSource should not be null");
        }
        if (StringUtils.isEmpty((String)startNumber) && StringUtils.isEmpty((String)endNumber) && StringUtils.isEmpty((String)selectNumber)) {
            throw new HRDIBizException("startNumber,endNumber,selectNumber at latest one should not be null");
        }
        String bizEntityNumber = intSource.getString("entityobj.number");
        if (StringUtils.isEmpty((String)bizEntityNumber)) {
            throw new HRDIBizException(ErrorEnum.METADATA_NOT_EXIST_ERROR, new Object[]{bizEntityNumber});
        }
        String midTableNumber = this.iMidTableConfigEntityService.queryMidTableNumberByEntityObjNumber(bizEntityNumber);
        if (StringUtils.isEmpty((String)midTableNumber)) {
            throw new HRDIBizException("midTableNumber should not be null");
        }
        BizDataSyncBoBuilder bizDataSyncBoBuilder = new BizDataSyncBoBuilder().setMidTableNumber(midTableNumber).setBizEntityNumber(bizEntityNumber).setBatchNumber(batchNumber);
        BizDataSyncResultBo resultBo = new BizDataRetrySyncBo(intLogId, bizDataSyncBoBuilder, startNumber, endNumber, selectNumber).syncBiz();
        LOG.info(ResManager.loadKDString((String)"HRDI\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u7ed3\u675f\uff0c \u8017\u65f6{}s", (String)"BizSyncDomainServiceImpl2", (String)"hdtc-hrdi-business", (Object[])new Object[0]), (Object)((System.currentTimeMillis() - start) / 1000L));
        return resultBo;
    }
}

