/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.entity.IIntSceneRuleEntityService;

public class IntSceneRuleDomainServiceImpl
implements IIntSceneRuleDomainService {
    private final IIntSceneRuleEntityService sceneRuleEntityService = ServiceFactory.getService(IIntSceneRuleEntityService.class);

    @Override
    public DynamicObject[] getEnabledSceneRule(Set<String> entityIds, List<Long> ids) {
        QFilter entityFilter = new QFilter("entityobj", "in", entityIds);
        if (!CollectionUtils.isEmpty(ids)) {
            entityFilter.and(new QFilter("id", "not in", ids));
        }
        return this.sceneRuleEntityService.query("entityobj", new QFilter[]{QFilterConstants.Q_ENABLE, entityFilter});
    }

    @Override
    public Map<String, String> getPresetSceneRuleFields(Set<String> entityIds) {
        QFilter entityFilter = new QFilter("entityobj", "in", entityIds);
        DynamicObject[] sceneRules = this.sceneRuleEntityService.query("entityobj,referencefield", new QFilter[]{QFilterConstants.Q_ENABLE, entityFilter, QFilterConstants.Q_PRESET});
        HashMap<String, String> sceneRuleFieldMap = new HashMap<String, String>(16);
        Arrays.stream(sceneRules).forEach(sceneRule -> sceneRuleFieldMap.put(sceneRule.getString("entityobj.id"), sceneRule.getString("referencefield")));
        return sceneRuleFieldMap;
    }

    @Override
    public Boolean isExistIntScene(String entityId, String field) {
        QFilter entityFilter = new QFilter("entityobj", "=", (Object)entityId);
        entityFilter.and(QFilterConstants.Q_PRESET);
        entityFilter.and(QFilterConstants.Q_ENABLE);
        entityFilter.and(new QFilter("referencefield", "like", (Object)("%" + field + "%")));
        return this.sceneRuleEntityService.isExists(entityFilter);
    }

    @Override
    public DynamicObject getEnabledSceneRule(String entityId) {
        QFilter entityFilter = new QFilter("entityobj", "=", (Object)entityId);
        return this.sceneRuleEntityService.queryOne("number,name,entityobj,referencefield,writetype,cloudid,appid,servicename,method,ruleentry.scenetype,ruleentry.classpath,ruleentry.operate", new QFilter[]{QFilterConstants.Q_ENABLE, entityFilter});
    }
}

