/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.apilink.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdi.business.application.external.IOpenAPIDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.apilink.IAPILinkConfigDomainService;
import kd.hdtc.hrdi.business.domain.apilink.entity.IAPILinkConfigEntityService;
import kd.hdtc.hrdi.common.apilink.enums.APILinkStateEnum;

public class APILinkConfigDomainServiceImpl
implements IAPILinkConfigDomainService {
    private final IAPILinkConfigEntityService entityService = ServiceFactory.getService(IAPILinkConfigEntityService.class);
    private final IOpenAPIDomainService openAPIDomainService = ServiceFactory.getService(IOpenAPIDomainService.class);

    @Override
    public String test(Long apiLinkId) {
        DynamicObject apiLinkDyn = this.queryById(apiLinkId);
        Map<String, Object> testDataMap = this.buildTestDataMap();
        try {
            this.openAPIDomainService.doPost(apiLinkDyn, testDataMap);
        }
        catch (HDTCBizException exception) {
            this.updateAPILinkDyn(apiLinkDyn, APILinkStateEnum.EXCEPTION);
            return exception.getMessage();
        }
        this.updateAPILinkDyn(apiLinkDyn, APILinkStateEnum.ACTIVE);
        return "success";
    }

    @Override
    public DynamicObject queryById(Long apiLinkId) {
        return this.entityService.queryOne("number,name,server_ip,server_port,appid,appsecret,account,user,web_app,state", apiLinkId);
    }

    @Override
    public DynamicObject[] queryAll() {
        return this.entityService.query("number,name", null);
    }

    private void updateAPILinkDyn(DynamicObject apiLinkDyn, APILinkStateEnum stateEnum) {
        apiLinkDyn.set("state", (Object)stateEnum.getCode());
        this.entityService.save(apiLinkDyn);
    }

    private Map<String, Object> buildTestDataMap() {
        HashMap<String, Object> testDataMap = new HashMap<String, Object>();
        testDataMap.put("entityNumber", null);
        testDataMap.put("opType", null);
        testDataMap.put("uniqueField", null);
        testDataMap.put("data", null);
        return testDataMap;
    }
}

