/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.blacklist.impl;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.blacklist.IBizFieldBlackListDomainService;
import kd.hdtc.hrdi.business.domain.blacklist.entity.IBizFieldBlackListEntityService;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;

public class BizFieldBlackListDomainServiceImpl
implements IBizFieldBlackListDomainService {
    private final IBizFieldBlackListEntityService entityService = ServiceFactory.getService(IBizFieldBlackListEntityService.class);
    private final IHRDIBaseConfigDomainService configDomainService = ServiceFactory.getService(IHRDIBaseConfigDomainService.class);

    @Override
    public Map<String, Set<String>> getBizFieldBlackLit(List<String> entityList) {
        QFilter filter = new QFilter("entityobj", "in", entityList);
        DynamicObject[] query = this.entityService.query("entityobj,fieldselect", new QFilter[]{filter});
        Map<String, String> entityBlackMap = Arrays.stream(query).collect(Collectors.toMap(dyn -> dyn.getString("entityobj.id"), dyn -> dyn.getString("fieldselect")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)entityList.size());
        Set<String> globalBlackListSet = this.getGlobalFieldBlackList();
        entityList.forEach(entity -> {
            HashSet blackListSet = new HashSet(globalBlackListSet);
            String blackField = (String)entityBlackMap.get(entity);
            if (StringUtils.isNotEmpty((String)blackField)) {
                String[] split = blackField.split(",");
                blackListSet.addAll(Arrays.stream(split).collect(Collectors.toSet()));
            }
            resultMap.put(entity, blackListSet);
        });
        return resultMap;
    }

    private Set<String> getGlobalFieldBlackList() {
        String blackList = this.configDomainService.queryBaseConfigValueByNumber("int.field.global.blacklist");
        String[] split = blackList.split(",");
        return Arrays.stream(split).collect(Collectors.toSet());
    }
}

