/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.common.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.OperationResultUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;
import kd.hdtc.hrdi.business.servicehelper.AdaptorMetadataCacheHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisInitReturnBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseCommonDomainServiceImpl
implements IBaseCommonDomainService {
    private final IMidTableConfigEntityService iMidTableConfigEntityService = ServiceFactory.getService(IMidTableConfigEntityService.class);
    private static final Log LOG = LogFactory.getLog(BaseCommonDomainServiceImpl.class);
    private static final String SELECT_PROPERTIES = String.join((CharSequence)",", "id", "name", "number");
    protected static final List<String> ID_PARAM_OP_TYPE_NUMBER_LIST = ImmutableList.of((Object)"delete", (Object)"enable", (Object)"disable", (Object)"unsubmit", (Object)"his_disable", (Object)"job_disable_confirm");

    @Override
    public DynamicObjectCollection queryOriginalEnableDataByName(String entityNumber, List<String> nameList, List<Long> excludePkIdList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)3);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        if (CollectionUtils.isNotEmpty(excludePkIdList)) {
            QFilter excludeIdFilter = new QFilter("id", "not in", excludePkIdList);
            qFilterList.add(excludeIdFilter);
        }
        QFilter nameFilter = new QFilter("name", "in", nameList);
        qFilterList.add(nameFilter);
        return hrBaseServiceHelper.queryOriginalCollection(SELECT_PROPERTIES, qFilterList.toArray(new QFilter[0]));
    }

    @Override
    public DynamicObjectCollection queryOriginalEnableDataByNumber(String entityNumber, List<String> numberList, List<Long> excludePkIdList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)3);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        if (CollectionUtils.isNotEmpty(excludePkIdList)) {
            QFilter excludeIdFilter = new QFilter("id", "not in", excludePkIdList);
            qFilterList.add(excludeIdFilter);
        }
        QFilter numberFilter = new QFilter("number", "in", numberList);
        qFilterList.add(numberFilter);
        return hrBaseServiceHelper.queryOriginalCollection(SELECT_PROPERTIES, qFilterList.toArray(new QFilter[0]));
    }

    @Override
    public Map<Long, DynamicObject> queryByIdList(String entityNumber, String selectProperties, List<Long> idList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] dys = hrBaseServiceHelper.query(selectProperties, new QFilter[]{idFilter});
        return Arrays.asList(dys).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dd -> dd));
    }

    @Override
    public Map<Object, DynamicObject> queryByFilters(String entityNumber, String selectProperties, QFilter[] qFilters) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] dys = hrBaseServiceHelper.query(selectProperties, qFilters);
        return Arrays.asList(dys).stream().collect(Collectors.toMap(dy -> dy.get("id"), dd -> dd));
    }

    @Override
    public DynamicObject[] queryByFilters(String entityNumber, String selectProperties, QFilter[] qFilters, String orderBy) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        return hrBaseServiceHelper.query(selectProperties, qFilters, orderBy);
    }

    @Override
    public Map<Object, DynamicObject> queryDataByIdList(String entityNumber, String selectProperties, Collection<Object> idList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] dys = hrBaseServiceHelper.query(selectProperties, new QFilter[]{idFilter});
        return Arrays.asList(dys).stream().collect(Collectors.toMap(dy -> dy.get("id"), dd -> dd));
    }

    @Override
    public Map<Object, DynamicObject> queryCurrentVersionDataByIdList(String entityNumber, String selectProperties, Collection<Object> boIdList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter idFilter = new QFilter("boid", "in", boIdList);
        DynamicObject[] dys = hrBaseServiceHelper.query(selectProperties, new QFilter[]{idFilter, QFilterConstants.Q_CURRENTVERSION});
        return Arrays.asList(dys).stream().collect(Collectors.toMap(dy -> dy.get("boid"), dd -> dd));
    }

    @Override
    public Set<Object> queryHisDataBoIdByIdList(String entityNumber, List<Object> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return new HashSet<Object>();
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] dys = hrBaseServiceHelper.query("id,boid", new QFilter[]{idFilter});
        return Stream.of(dys).map(dd -> dd.get("boid")).collect(Collectors.toSet());
    }

    @Override
    public DynamicObject queryOneById(String entityNumber, String selectProperties, Object id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        return hrBaseServiceHelper.queryOne(id);
    }

    @Override
    public Map<Long, DynamicObject> queryByIdList(String entityNumber, String selectProperties, Collection<Long> idList, String pkName) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter idFilter = new QFilter(pkName, "in", idList);
        DynamicObject[] dys = hrBaseServiceHelper.query(selectProperties, new QFilter[]{idFilter});
        return Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong(pkName), it -> it, (it1, it2) -> it1));
    }

    @Override
    public DynamicObject[] queryPageCollection(String entityNumber, String selectProperties, QFilter[] qFilters, int pageIndex, int pageSize) {
        return BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])qFilters, (String)"id", (int)pageIndex, (int)pageSize);
    }

    @Override
    public DynamicObject[] queryPageCollection(String entityNumber, String selectProperties, QFilter[] qFilters, String orderBy, int pageIndex, int pageSize) {
        return BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])qFilters, (String)orderBy, (int)pageIndex, (int)pageSize);
    }

    @Override
    public int count(String entityNumber, QFilter[] qFilters) {
        return HRBaseServiceHelper.create((String)entityNumber).count(entityNumber, qFilters);
    }

    @Override
    public List<DynamicObject> loadBaseDataFromDBWithRefProp(String entityType, Set<String> fieldValSet, String fieldName, String entityCode) {
        IDataEntityProperty property = MetadataServiceHelper.getDataEntityType((String)entityCode).findProperty(fieldName);
        IDataEntityType relField = null;
        relField = property instanceof BasedataProp ? ((BasedataProp)property).getComplexType() : ((MulBasedataProp)property).getComplexType();
        String relFieldStr = relField.toString();
        String searchField = relFieldStr.substring(relFieldStr.indexOf(91) + 1, relFieldStr.lastIndexOf(93));
        return this.loadBaseDataFromDB(entityType, fieldValSet, fieldName, entityCode, searchField + ",id");
    }

    @Override
    public List<DynamicObject> loadBaseDataFromDBWithRefProp(String uniqueField, String entityType, Set<String> fieldValSet, String fieldName, String entityCode) {
        if (StringUtils.isEmpty((String)uniqueField)) {
            return this.loadBaseDataFromDBWithRefProp(entityType, fieldValSet, fieldName, entityCode);
        }
        IDataEntityProperty property = MetadataServiceHelper.getDataEntityType((String)entityCode).findProperty(fieldName);
        IDataEntityType relField = null;
        relField = property instanceof BasedataProp ? ((BasedataProp)property).getComplexType() : ((MulBasedataProp)property).getComplexType();
        String relFieldStr = relField.toString();
        String searchField = relFieldStr.substring(relFieldStr.indexOf(91) + 1, relFieldStr.lastIndexOf(93));
        return this.loadBaseDataFromDB(uniqueField, entityType, fieldValSet, fieldName, entityCode, searchField + ",id");
    }

    @Override
    public List<DynamicObject> loadBaseDataFromDB(String uniqueField, String entityType, Set<String> fieldValSet, String fieldName, String entityCode, String selectedProperties) {
        if (StringUtils.isEmpty((String)uniqueField)) {
            return this.loadBaseDataFromDB(entityType, fieldValSet, fieldName, entityCode, selectedProperties);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
        QFilter searchFilter = new QFilter(uniqueField, "in", fieldValSet);
        Object[] dys = serviceHelper.query(selectedProperties, BaseCommonDomainServiceImpl.buildHisQFilter(entityCode, fieldName, entityType, searchFilter).toArray(), "id desc");
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])dys);
    }

    @Override
    public List<DynamicObject> loadBaseDataFromDB(String entityType, Set<String> fieldValSet, String fieldName, String entityCode, String selectedProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
        String numberFieldName = AdaptorMetadataCacheHelper.getEntityNumberFieldName(entityType);
        String nameFieldName = AdaptorMetadataCacheHelper.getEntityNameFieldName(entityType);
        if (StringUtils.isEmpty((String)numberFieldName) && StringUtils.isEmpty((String)nameFieldName)) {
            return new ArrayList<DynamicObject>();
        }
        QFilter searchFilter = StringUtils.isNotEmpty((String)numberFieldName) ? new QFilter(numberFieldName, "in", fieldValSet) : new QFilter(nameFieldName, "in", fieldValSet);
        Object[] dys = serviceHelper.query(selectedProperties, BaseCommonDomainServiceImpl.buildHisQFilter(entityCode, fieldName, entityType, searchFilter).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])dys);
    }

    @Override
    public List<DynamicObject> query(String midTableNumber, String selectedProperties, Set<Long> idSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(midTableNumber);
        Object[] dys = serviceHelper.query(selectedProperties, new QFilter("id", "in", idSet).toArray());
        if (dys == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])dys);
    }

    @Override
    public void save(List<DynamicObject> midDyList) {
        HRBaseServiceHelper.create((String)"").save(midDyList.toArray(new DynamicObject[0]));
    }

    @Override
    public Map<String, String> getMidTableAndEntityMappingWithoutName(String midTableNumber) {
        return this.getMidTableAndEntityMapping(midTableNumber, false).inverse();
    }

    @Override
    public DynamicObject generateEmptyDynamicObject(String entityNumber) {
        return new HRBaseServiceHelper(entityNumber).generateEmptyDynamicObject();
    }

    private BiMap<String, String> getMidTableAndEntityMapping(String midTableNumber, boolean containsBasedataName) {
        HashBiMap mapping = HashBiMap.create();
        DynamicObject tempObject = this.iMidTableConfigEntityService.loadFromCache(midTableNumber);
        DynamicObjectCollection dynamicObjectCollection = tempObject.getDynamicObjectCollection("treeentryentity");
        Map<Long, String> pidEntityMap = this.getPidEntityMap(dynamicObjectCollection);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (!dynamicObject.getBoolean("isintegrationfield") || !dynamicObject.getBoolean("isfield")) continue;
            String entityNumber = dynamicObject.getString("entitynumber");
            String alias = dynamicObject.getString("numberalias");
            String entityCode = pidEntityMap.get(dynamicObject.getLong("pid"));
            if (HRStringUtils.equals((String)alias, (String)entityNumber)) continue;
            BaseCommonDomainServiceImpl.addMappingInfo((Map<String, String>)mapping, entityCode, dynamicObject, containsBasedataName);
        }
        return mapping;
    }

    private Map<Long, String> getPidEntityMap(DynamicObjectCollection dynamicObjectCollection) {
        HashMap<Long, String> entryIdEntityMap = new HashMap<Long, String>(16);
        HashMap<Long, Long> headEntryIdPidMap = new HashMap<Long, Long>(16);
        for (DynamicObject dyn : dynamicObjectCollection) {
            if (!dyn.getBoolean("istablehead")) continue;
            String entitNumber = dyn.getString("entitynumber");
            long pid = dyn.getLong("pid");
            long entryId2 = dyn.getLong("id");
            if (pid == 0L) {
                entryIdEntityMap.put(entryId2, entitNumber);
            }
            if (!"billhead".equals(entitNumber)) continue;
            headEntryIdPidMap.put(pid, entryId2);
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        entryIdEntityMap.forEach((entryId, entity) -> resultMap.put((Long)headEntryIdPidMap.get(entryId), (String)entity));
        return resultMap;
    }

    private static void addMappingInfo(Map<String, String> mapping, String entityCode, DynamicObject dynamicObject, boolean containsBaseDataName) {
        String entityNumber = dynamicObject.getString("entitynumber");
        String alias = dynamicObject.getString("numberalias");
        String importProp = dynamicObject.getString("referenceprop");
        String key = entityCode + "." + entityNumber;
        if (HRStringUtils.isEmpty((String)importProp)) {
            mapping.put(key, alias);
        } else if ("number".equals(importProp)) {
            mapping.put(key + "." + "number", alias);
            if (containsBaseDataName) {
                mapping.put(key + "." + "name", alias + "a");
            }
        } else {
            mapping.put(key + "." + "name", alias);
        }
    }

    private static QFilter buildHisQFilter(String entityCode, String fieldName, String entityType, QFilter defaultQFilter) {
        try {
            HisInitReturnBo hisInitReturnBo = HisModelController.getInstance().buildImportFilter(entityCode, fieldName, entityType);
            if (Objects.nonNull(hisInitReturnBo) && Objects.nonNull(hisInitReturnBo.getqFilter())) {
                LOG.info("importbo filter, {}", (Object)hisInitReturnBo.getqFilter());
                return defaultQFilter.and(hisInitReturnBo.getqFilter());
            }
        }
        catch (Exception ex) {
            LOG.error("his error", (Throwable)ex);
        }
        return defaultQFilter;
    }

    @Override
    public Map<String, String> executeOperate(String operationKey, String entityNumber, List<DynamicObject> params) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        option.setVariableValue("isPersonalizeData", "0");
        if ("confirmchange".equals(operationKey) || "confirmchangenoaudit".equals(operationKey)) {
            option.setVariableValue("opFromFormEdit", "false");
        }
        HashMap<String, String> opResultMap = new HashMap<String, String>(16);
        try {
            operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])params.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        catch (Exception ex) {
            LOG.error("executeOperate  error", (Throwable)ex);
            opResultMap.put("allFailed", ex.toString());
            return opResultMap;
        }
        return OperationResultUtils.paraseOpResult((OperationResult)operationResult);
    }

    @Override
    public Map<String, String> executeOperateByIdList(String operationKey, String entityNumber, List<Object> ids) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        HashMap<String, String> opResultMap = new HashMap<String, String>(16);
        try {
            operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids.toArray(new Object[0]), (OperateOption)option);
        }
        catch (Exception ex) {
            LOG.error("executeOperateByIdList  error", (Throwable)ex);
            opResultMap.put("allFailed", ex.toString());
            return opResultMap;
        }
        return OperationResultUtils.paraseOpResult((OperationResult)operationResult);
    }

    @Override
    public Map<String, String> commonCallOp(String operationKey, String entityNumber, List<DynamicObject> dataList) {
        Map<String, String> opResultMap;
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        HashMap idAndDyMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        dataList.forEach(dy -> {
            idList.add(dy.get("id"));
            idAndDyMap.put(dy.get("id"), dy);
        });
        ArrayList dyFromDbList = Lists.newArrayListWithExpectedSize((int)idAndDyMap.size());
        if (ID_PARAM_OP_TYPE_NUMBER_LIST.contains(operationKey)) {
            opResultMap = this.executeOperateByIdList(operationKey, entityNumber, idList);
        } else if ("confirmchange".equals(operationKey) || "confirmchangenoaudit".equals(operationKey)) {
            Set bizEntityFieldSet = MetadataServiceHelper.getDataEntityType((String)entityNumber).getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
            dataList.forEach(dy -> {
                DynamicObject newObj = this.generateEmptyDynamicObject(entityNumber);
                HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newObj);
                this.sysFieldHandle(bizEntityFieldSet, newObj, (DynamicObject)dy);
                dyFromDbList.add(newObj);
            });
            opResultMap = this.executeOperate(operationKey, entityNumber, dyFromDbList);
        } else {
            List fieldNumberList = MetadataUtils.getQueryFieldNumberList((String)entityNumber);
            Map<Object, DynamicObject> idAndDyMapFromDb = this.queryDataByIdList(entityNumber, String.join((CharSequence)",", fieldNumberList), idList);
            LOG.info("commonCallOp sync idAndDyMapFromDb size:{}", (Object)idAndDyMapFromDb.size());
            idAndDyMap.forEach((id, dy) -> {
                DynamicObject dyFromDb = (DynamicObject)idAndDyMapFromDb.get(id);
                if (dyFromDb != null) {
                    DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)dyFromDb);
                    dyFromDbList.add(dyFromDb);
                } else {
                    LOG.info("commonCallOp sync, entityNumber={},opType={},id={} data is null", new Object[]{entityNumber, operationKey, id});
                    dyFromDbList.add(dy);
                }
            });
            opResultMap = this.executeOperate(operationKey, entityNumber, dyFromDbList);
        }
        return opResultMap;
    }

    private void sysFieldHandle(Set<String> bizEntityFieldSet, DynamicObject bizDyc, DynamicObject oldDyn) {
        bizDyc.set("id", null);
        bizDyc.set("boid", oldDyn.get("id"));
        bizDyc.set("status", (Object)"A");
        bizDyc.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        if (bizEntityFieldSet.contains("initdatasource")) {
            bizDyc.set("initdatasource", (Object)"2");
        }
        if (bizEntityFieldSet.contains("initstatus")) {
            bizDyc.set("initstatus", (Object)"2");
        }
    }

    @Override
    public DynamicObject[] queryOriginalArray(String entityNumber, String selectFields, QFilter[] filters) {
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)selectFields)) {
            return new DynamicObject[0];
        }
        return new HRBaseServiceHelper(entityNumber).queryOriginalArray(selectFields, filters);
    }
}

