/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.datamapping.bo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdi.business.domain.datamapping.bo.DataMappingBo;
import kd.hdtc.hrdi.business.domain.datamapping.entity.DataMappingFactory;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingEntityService;
import kd.hdtc.hrdi.common.core.enums.ErrorEnum;
import kd.hdtc.hrdi.common.exception.HRDIBizException;
import kd.hdtc.hrdi.common.pojo.DataMapping;

public class EntityObjDataMappingBo {
    private static final Log LOG = LogFactory.getLog(EntityObjDataMappingBo.class);
    private IDataMappingEntityService dataMappingEntityService;
    private String entityObjId;
    private LinkedHashMap<String, DataMappingBo> dataMappingBoMap;

    public EntityObjDataMappingBo(List<DataMapping> dataMappingList) {
        this.entityObjId = EntityObjDataMappingBo.getEntityObjectId(dataMappingList);
        this.dataMappingEntityService = new DataMappingFactory().getDataMappingEntityService(this.entityObjId);
        this.dataMappingBoMap = dataMappingList.stream().map(it -> new DataMappingBo((DataMapping)it)).collect(Collectors.toMap(it -> this.getDataMappingKey(it.getDataMapping()), Function.identity(), (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    public void save() {
        this.prepare();
        DynamicObject[] dynamicObjects = (DynamicObject[])this.dataMappingBoMap.values().stream().map(dy -> this.dataMappingEntityService.toDynamicObject(dy.getDataMappingDy(), dy.getDataMapping())).toArray(DynamicObject[]::new);
        this.dataMappingEntityService.save(dynamicObjects);
    }

    public List<DataMapping> query() {
        this.prepare();
        return this.dataMappingBoMap.values().stream().map(dy -> this.dataMappingEntityService.toDataMapping(dy.getDataMapping(), dy.getDataMappingDy())).collect(Collectors.toList());
    }

    private void prepare() {
        Set<Long> sourceSysSet = this.dataMappingBoMap.values().stream().filter(dd -> dd.getDataMapping().getSourceSys() != null).map(it -> it.getDataMapping().getSourceSys().getLong("id")).collect(Collectors.toSet());
        Set<String> sourceDataKeySet = this.dataMappingBoMap.values().stream().map(it -> it.getDataMapping().getSourceDataKey()).filter(Objects::nonNull).collect(Collectors.toSet());
        List<DynamicObject> dataMappingDyList = this.dataMappingEntityService.query(this.entityObjId, sourceSysSet, sourceDataKeySet);
        dataMappingDyList.forEach(dy -> {
            DataMappingBo bo = this.dataMappingBoMap.get(this.getDataMappingKey((DynamicObject)dy));
            if (bo == null) {
                LOG.warn("bo should not be null, entityObjId = {}, sourceSysId = {}, bizDataKey = {}", new Object[]{this.entityObjId, dy.get("hrdisourcesys") == null ? 0L : dy.getLong("hrdisourcesys.id"), dy.getString("bizdatakey")});
            } else {
                bo.setDbDynamicObject((DynamicObject)dy);
            }
        });
    }

    private String getDataMappingKey(DataMapping dataMapping) {
        return (dataMapping.getSourceSys() == null ? 0L : dataMapping.getSourceSys().getLong("id")) + dataMapping.getSourceDataKey();
    }

    private String getDataMappingKey(DynamicObject dy) {
        return (dy.get("hrdisourcesys") == null ? 0L : dy.getLong("hrdisourcesys.id")) + dy.getString("hrdisourcesyskey");
    }

    private static String getEntityObjectId(List<DataMapping> dataMappingList) {
        Set entityObjectIdSet = dataMappingList.stream().map(DataMapping::getEntityObjId).collect(Collectors.toSet());
        if (entityObjectIdSet.size() != 1) {
            throw new HRDIBizException(ErrorEnum.DATA_MAPPING_SUPPORT_ERROR, new Object[0]);
        }
        return entityObjectIdSet.stream().findFirst().orElse("");
    }
}

