/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.datamapping.bo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.IHRICMidTableCovert;
import kd.hdtc.hrdi.business.domain.datamapping.bo.EntityObjDataMappingBo;
import kd.hdtc.hrdi.business.domain.datamapping.entity.DataMappingFactory;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingLogEntityService;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingRecordEntityService;
import kd.hdtc.hrdi.common.core.enums.ErrorEnum;
import kd.hdtc.hrdi.common.exception.HRDIBizException;
import kd.hdtc.hrdi.common.pojo.DataMapping;

public class HRICDataMappingBo {
    private static Log LOG = LogFactory.getLog(HRICDataMappingBo.class);
    private final IDataMappingRecordEntityService dataMappingRecordEntityService = ServiceFactory.getService(IDataMappingRecordEntityService.class);
    private final IDataMappingLogEntityService dataMappingLogEntityService = ServiceFactory.getService(IDataMappingLogEntityService.class);
    private IHRICMidTableCovert midTableCovert;
    private DynamicObject dataMappingRecord;
    private String entityObjId;

    public HRICDataMappingBo(DynamicObject dataMappingRecord) {
        this.dataMappingRecord = dataMappingRecord;
        this.entityObjId = dataMappingRecord.getString("intsource.entityobj.id");
        this.midTableCovert = new DataMappingFactory().getHRICMidTableCovert(this.entityObjId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataMapping(List<DynamicObject> midTableDataList) {
        LOG.info("the HRICDataMappingBo operate saveDataMapping start time:{}", (Object)System.currentTimeMillis());
        if (CollectionUtils.isEmpty(midTableDataList)) {
            return;
        }
        DynamicObject firstMidTableData = midTableDataList.get(0);
        DynamicObject lastMidTableData = midTableDataList.get(midTableDataList.size() - 1);
        ArrayList effectMidTableDataList = Lists.newArrayListWithExpectedSize((int)midTableDataList.size());
        int ignoreCount = this.getEffectMidTableDataList(midTableDataList, effectMidTableDataList);
        boolean result = true;
        String errorMessage = "";
        try (TXHandle txHandle = null;){
            txHandle = TX.requiresNew();
            LOG.info("the HRICDataMappingBo operate saveDataMapping covertDataMapping time:{}", (Object)System.currentTimeMillis());
            List<DataMapping> dataMappings = this.covertDataMapping(effectMidTableDataList);
            LOG.info("the HRICDataMappingBo operate saveDataMapping EntityObjDataMappingBo save");
            if (CollectionUtils.isNotEmpty(dataMappings)) {
                new EntityObjDataMappingBo(dataMappings).save();
            }
            this.saveDataMappingRecord(String.valueOf(lastMidTableData.getLong("id")), effectMidTableDataList.size(), 0, ignoreCount);
            this.saveDataMappingLog(String.valueOf(firstMidTableData.getLong("id")), String.valueOf(lastMidTableData.getLong("id")), this.dataMappingRecord, null, "1", midTableDataList.size());
        }
        if (!result) {
            this.saveDataMappingRecord(String.valueOf(lastMidTableData.getLong("id")), 0, effectMidTableDataList.size(), ignoreCount);
            this.saveDataMappingLog(String.valueOf(firstMidTableData.getLong("id")), String.valueOf(lastMidTableData.getLong("id")), this.dataMappingRecord, errorMessage, "0", midTableDataList.size());
        }
    }

    public void saveDataMappingFinish(DynamicObject dataMappingRecord) {
        dataMappingRecord.set("handlestatus", (Object)"1");
        dataMappingRecord.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dataMappingRecord.set("modifytime", (Object)new Date());
        this.dataMappingRecordEntityService.save(dataMappingRecord);
    }

    public IHRICMidTableCovert getMidTableCovert() {
        return this.midTableCovert;
    }

    public List<DataMapping> covertDataMapping(List<DynamicObject> midTableDataList) {
        if (this.midTableCovert == null) {
            throw new HRDIBizException(ErrorEnum.MIDTABLECOVERT_NOT_EXIST_ERROR, new Object[0]);
        }
        return this.midTableCovert.covert(this.entityObjId, midTableDataList, this.dataMappingRecord.getString("relationinfo"));
    }

    private String getAppNumber(String entityObjId) {
        if (!MetadataUtils.isExist((String)entityObjId)) {
            throw new HRDIBizException(ErrorEnum.METADATA_NOT_EXIST_ERROR, new Object[]{entityObjId});
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityObjId);
        return dataEntityType.getBizAppNumber();
    }

    private void saveDataMappingRecord(String startOffset, int successCount, int failCount, int ignoreCount) {
        this.dataMappingRecord.set("startoffset", (Object)startOffset);
        this.dataMappingRecord.set("successcount", (Object)(this.dataMappingRecord.getInt("successcount") + successCount));
        this.dataMappingRecord.set("failcount", (Object)(this.dataMappingRecord.getInt("failcount") + failCount));
        this.dataMappingRecord.set("ignorecount", (Object)(this.dataMappingRecord.getInt("ignorecount") + ignoreCount));
        this.dataMappingRecordEntityService.save(this.dataMappingRecord);
    }

    private int getEffectMidTableDataList(List<DynamicObject> midTableDataList, List<DynamicObject> effectMidTableDataList) {
        int ignoreCount = 0;
        for (DynamicObject midTableData : midTableDataList) {
            String sourceSysKey = midTableData.getString("hricsourcesyskey");
            String bizId = midTableData.getString("hricbizid");
            if (StringUtils.isEmpty((String)sourceSysKey) || StringUtils.isEmpty((String)bizId)) {
                ++ignoreCount;
                continue;
            }
            effectMidTableDataList.add(midTableData);
        }
        return ignoreCount;
    }

    private void saveDataMappingLog(String startOffset, String endOffset, DynamicObject dataMappingRecord, String errorMessage, String handleStatus, int handleCount) {
        DynamicObject dynamicObject = this.dataMappingLogEntityService.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)ID.genLongId());
        dynamicObject.set("datamaprecord", (Object)dataMappingRecord);
        dynamicObject.set("startoffset", (Object)startOffset);
        dynamicObject.set("endoffset", (Object)endOffset);
        if (StringUtils.isNotEmpty((String)errorMessage)) {
            if (errorMessage.length() > 255) {
                dynamicObject.set("errorinfo", (Object)errorMessage.substring(0, 255));
            } else {
                dynamicObject.set("errorinfo", (Object)errorMessage);
            }
            dynamicObject.set("errorinfo_tag", (Object)errorMessage);
        }
        dynamicObject.set("handlecount", (Object)handleCount);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("handlestatus", (Object)handleStatus);
        this.dataMappingLogEntityService.save(dynamicObject);
    }
}

