/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.datamapping.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.HRICMidTableCovertImpl;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.HrHRICMidTableCovertImpl;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.HrOtherHRICMidTableCovertImpl;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.IHRICMidTableCovert;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.OrgHRICMidTableCovertImpl;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingEntityService;
import kd.hdtc.hrdi.business.domain.datamapping.entity.impl.DataMappingEntityServiceImpl;
import kd.hdtc.hrdi.business.domain.datamapping.entity.impl.DataMappingHandler;
import kd.hdtc.hrdi.business.domain.datamapping.entity.impl.HrDataMappingEntityServiceImpl;
import kd.hdtc.hrdi.business.domain.datamapping.entity.impl.OrgDataMappingEntityServiceImpl;
import kd.hdtc.hrdi.business.domain.datamapping.entity.impl.PersonAttachedDataMappingEntityServiceImpl;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;

public class DataMappingFactory {
    private final IIntSceneRuleDomainService sceneRuleDomainService = ServiceFactory.getService(IIntSceneRuleDomainService.class);
    private static final Map<String, DataMappingHandler> ENTITYNUMBER_DATAMAPPING_HANDLER = Maps.newHashMapWithExpectedSize((int)5);
    private final IIntEntityCategoryDomainService domainService = ServiceFactory.getService(IIntEntityCategoryDomainService.class);

    private DataMappingHandler getDataMappingHandler(String entityNumber) {
        String writeType;
        switch (writeType = this.getWriteType(entityNumber)) {
            case "1": 
            case "2": {
                return ENTITYNUMBER_DATAMAPPING_HANDLER.get("hrdi_datamapping");
            }
        }
        return this.getAdaptorTypeDataMappingHandler(entityNumber);
    }

    private DataMappingHandler getAdaptorTypeDataMappingHandler(String entityNumber) {
        DataMappingHandler dataMappingHandler = ENTITYNUMBER_DATAMAPPING_HANDLER.get(entityNumber);
        BizCategoryEnum category = this.domainService.getCategoryByEntityNumber(entityNumber);
        if (Objects.nonNull(dataMappingHandler)) {
            return dataMappingHandler;
        }
        if (BizCategoryEnum.PERSON_ATTACHED.getCode().equals(category.getCode())) {
            return ENTITYNUMBER_DATAMAPPING_HANDLER.get("hrpi_");
        }
        if (BizCategoryEnum.BASE_DATA.getCode().equals(category.getCode())) {
            return ENTITYNUMBER_DATAMAPPING_HANDLER.get("hrdi_datamapping");
        }
        return null;
    }

    private String getWriteType(String entityNumber) {
        DynamicObject sceneRule = this.sceneRuleDomainService.getEnabledSceneRule(entityNumber);
        if (sceneRule == null) {
            return "0";
        }
        return sceneRule.getString("writetype");
    }

    public IDataMappingEntityService getDataMappingEntityService(String entityNumber) {
        DataMappingHandler dataMappingHandler = this.getDataMappingHandler(entityNumber);
        if (Objects.nonNull(dataMappingHandler)) {
            return dataMappingHandler.getiDataMappingEntityService();
        }
        return (IDataMappingEntityService)TypesContainer.getOrRegisterSingletonInstance((String)DataMappingEntityServiceImpl.class.getName());
    }

    public IHRICMidTableCovert getHRICMidTableCovert(String entityNumber) {
        DataMappingHandler dataMappingHandler = this.getDataMappingHandler(entityNumber);
        if (Objects.nonNull(dataMappingHandler)) {
            return dataMappingHandler.getIhricMidTableCovert();
        }
        return (IHRICMidTableCovert)TypesContainer.getOrRegisterSingletonInstance((String)HRICMidTableCovertImpl.class.getName());
    }

    public String getIdMappingEntityNumber(String entityNumber) {
        DataMappingHandler dataMappingHandler = this.getDataMappingHandler(entityNumber);
        if (Objects.nonNull(dataMappingHandler)) {
            return dataMappingHandler.getIdMappingEntityNumber();
        }
        return "hrdi_datamapping";
    }

    static {
        ENTITYNUMBER_DATAMAPPING_HANDLER.put("haos_adminorgdetail", new DataMappingHandler(new OrgDataMappingEntityServiceImpl(), new OrgHRICMidTableCovertImpl(), "hrdi_orgdatamapping"));
        ENTITYNUMBER_DATAMAPPING_HANDLER.put("hbpm_position_api", new DataMappingHandler(new OrgDataMappingEntityServiceImpl(), new OrgHRICMidTableCovertImpl(), "hrdi_orgdatamapping"));
        ENTITYNUMBER_DATAMAPPING_HANDLER.put("hrpi_emp_integrate", new DataMappingHandler(new HrDataMappingEntityServiceImpl(), new HrHRICMidTableCovertImpl(), "hrdi_hrdatamapping"));
        ENTITYNUMBER_DATAMAPPING_HANDLER.put("hrpi_", new DataMappingHandler(new PersonAttachedDataMappingEntityServiceImpl(), new HrOtherHRICMidTableCovertImpl(), "hrdi_attdatamapping"));
        ENTITYNUMBER_DATAMAPPING_HANDLER.put("hrdi_datamapping", new DataMappingHandler(new DataMappingEntityServiceImpl(), new HRICMidTableCovertImpl(), "hrdi_datamapping"));
    }
}

