/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.datamapping.entity.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.entity.IPersonEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncDataMappingBo;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingEntityService;
import kd.hdtc.hrdi.business.domain.datamapping.impl.BizPersonDataMappingExtendUpdateDefault;
import kd.hdtc.hrdi.common.pojo.DataMapping;
import kd.hdtc.hrdi.common.pojo.FourFloorPersonIdEntry;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.hdtc.hrdi.adaptor.extend.IBizPersonDataMappingExtendUpdate;
import kd.sdk.hdtc.hrdi.adaptor.model.BizPersonDataMappingArgs;

public class HrDataMappingEntityServiceImpl
extends AbstractBaseEntityService
implements IDataMappingEntityService {
    private static final Log LOG = LogFactory.getLog(HrDataMappingEntityServiceImpl.class);
    private final IPersonEntityService iPersonEntityService = ServiceFactory.getService(IPersonEntityService.class);

    public HrDataMappingEntityServiceImpl() {
        super("hrdi_hrdatamapping");
    }

    @Override
    public List<DynamicObject> query(String entityObjId, Set<Long> sourceSysIdSet, Set<String> sourceSysDataKeySet) {
        return Lists.newArrayList((Object[])this.query("entityobjid,hrdisourcesys,hrdisourcesyskey,bizdatakey,personid,employeeid,depempid,cmpempid,number,effectivestatus", this.buildQueryQFilters(entityObjId, sourceSysIdSet, sourceSysDataKeySet)));
    }

    @Override
    public void updateDataMappingEffectiveStatus(List<IntRowResult> intRowResultList) {
        ArrayList successBizDataKeyList = Lists.newArrayListWithExpectedSize((int)intRowResultList.size());
        ArrayList failBizDataKeyList = Lists.newArrayListWithExpectedSize((int)intRowResultList.size());
        ArrayList needFailureNumberList = Lists.newArrayListWithExpectedSize((int)intRowResultList.size());
        for (IntRowResult intRowResult : intRowResultList) {
            if (intRowResult.getSuccess().booleanValue()) {
                successBizDataKeyList.add(intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject().getLong("id"));
                String oldEmpNumber = intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject().getString("hrpi_empentrel_integ.oldempnumber");
                if (Boolean.FALSE.equals(intRowResult.getBizDataSyncDataMappingBo().getOtherInfo()) && StringUtils.isEmpty((String)oldEmpNumber)) {
                    needFailureNumberList.add(intRowResult.getBizDataSyncDataMappingBo().getDataMapping().getNumber());
                    continue;
                }
                if (StringUtils.isEmpty((String)oldEmpNumber)) continue;
                needFailureNumberList.add(oldEmpNumber);
                continue;
            }
            failBizDataKeyList.add(intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject().getLong("id"));
        }
        if (CollectionUtils.isNotEmpty((Collection)successBizDataKeyList) || CollectionUtils.isNotEmpty((Collection)failBizDataKeyList)) {
            QFilter numberFilter;
            Object[] needDiscardDataMappings;
            ArrayList bizDataKeyList = Lists.newArrayListWithExpectedSize((int)(successBizDataKeyList.size() + failBizDataKeyList.size()));
            bizDataKeyList.addAll(successBizDataKeyList);
            bizDataKeyList.addAll(failBizDataKeyList);
            QFilter bizDataKeyFilter = new QFilter("bizdatakey", "in", (Object)bizDataKeyList);
            QFilter effectiveStatusFilter = new QFilter("effectivestatus", "=", (Object)"1");
            Object[] needUpdateDataMappings = this.query("entityobjid,hrdisourcesys,hrdisourcesyskey,bizdatakey,personid,employeeid,depempid,cmpempid,number,effectivestatus", new QFilter[]{bizDataKeyFilter, effectiveStatusFilter});
            ArrayList dataMappingList = Lists.newArrayListWithExpectedSize((int)needUpdateDataMappings.length);
            if (ArrayUtils.isNotEmpty((Object[])needUpdateDataMappings)) {
                Stream.of(needUpdateDataMappings).forEach(dy -> {
                    if (successBizDataKeyList.contains(dy.getLong("bizdatakey"))) {
                        dy.set("effectivestatus", (Object)"2");
                    } else {
                        dy.set("effectivestatus", (Object)"4");
                    }
                    dataMappingList.add(dy);
                });
            }
            if (ArrayUtils.isNotEmpty((Object[])(needDiscardDataMappings = this.query("entityobjid,hrdisourcesys,hrdisourcesyskey,bizdatakey,personid,employeeid,depempid,cmpempid,number,effectivestatus", new QFilter[]{numberFilter = new QFilter("number", "in", (Object)needFailureNumberList), effectiveStatusFilter = new QFilter("effectivestatus", "=", (Object)"2")})))) {
                Stream.of(needDiscardDataMappings).forEach(dy -> {
                    dy.set("effectivestatus", (Object)"3");
                    dataMappingList.add(dy);
                });
            }
            this.save(dataMappingList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public DataMapping toDataMapping(DataMapping dataMapping, DynamicObject dataMappingDy) {
        if (Objects.nonNull(dataMappingDy)) {
            dataMapping.setBizDataKey(Long.valueOf(dataMappingDy.getLong("bizdatakey")));
            dataMapping.setPersonId(Long.valueOf(dataMappingDy.getLong("personid")));
            dataMapping.setCmpempId(Long.valueOf(dataMappingDy.getLong("cmpempid")));
            dataMapping.setDepempId(Long.valueOf(dataMappingDy.getLong("depempid")));
            dataMapping.setEmployeeId(Long.valueOf(dataMappingDy.getLong("employeeid")));
            dataMapping.setNumber(dataMappingDy.getString("number"));
            dataMapping.setEffectiveStatus(dataMappingDy.getString("effectivestatus"));
        }
        return dataMapping;
    }

    @Override
    public void addDataMappingOtherFieldId(List<DataMapping> needSaveDataMappingList, List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList) {
        if (CollectionUtils.isNotEmpty(needSaveDataMappingList)) {
            List<Object> numberList = needSaveDataMappingList.stream().map(DataMapping::getNumber).collect(Collectors.toList());
            Map<String, Boolean> employeeStatusMap = this.iPersonEntityService.checkEmployeeStatus(numberList);
            LOG.info("addDataMappingOtherFieldId checkEmployeeStatus result={}", employeeStatusMap);
            Map dataMappingBizDataSyncDataMappingBoMap = bizDataSyncDataMappingBoList.stream().collect(Collectors.toMap(BizDataSyncDataMappingBo::getDataMapping, Function.identity()));
            ArrayList<BizPersonDataMappingArgs> argsList = new ArrayList<BizPersonDataMappingArgs>(16);
            needSaveDataMappingList.forEach(it -> {
                BizDataSyncDataMappingBo bizDataSyncDataMappingBo = (BizDataSyncDataMappingBo)dataMappingBizDataSyncDataMappingBoMap.get(it);
                String oldEmpNumber = bizDataSyncDataMappingBo.getBizDynamicObject().getString("hrpi_empentrel_integ.oldempnumber");
                String number = it.getNumber();
                String sourceDataKey = it.getSourceDataKey();
                it.setEffectiveStatus("2");
                it.setDepempId(it.getBizDataKey());
                if (StringUtils.isNotEmpty((String)oldEmpNumber)) {
                    LOG.info("addDataMappingOtherFieldId oldEmpNumber is not empty,oldEmpNumber={}.", (Object)oldEmpNumber);
                    it.setPersonId(Long.valueOf(ID.genLongId()));
                    it.setEmployeeId(Long.valueOf(ID.genLongId()));
                    it.setCmpempId(Long.valueOf(ID.genLongId()));
                    it.setEffectiveStatus("1");
                    Map<String, Long> fourFloorPersonIdMap = this.getFourFloorPersonIdMap((DataMapping)it);
                    argsList.add(this.buildBizPersonDataMappingArgs(sourceDataKey, number, oldEmpNumber, fourFloorPersonIdMap));
                } else {
                    Map<String, List<FourFloorPersonIdEntry>> numberSourceSysIdAndDataMappingMap = this.getOldDataMappingInfo(needSaveDataMappingList);
                    DynamicObject sourceSys = it.getSourceSys();
                    long sourceSysId = sourceSys != null ? sourceSys.getLong("id") : 0L;
                    String numberSourceSysId = number + sourceSysId;
                    List oldDataMappingList = numberSourceSysIdAndDataMappingMap.getOrDefault(numberSourceSysId, new ArrayList());
                    it.setDepempId(it.getBizDataKey());
                    if (CollectionUtils.isEmpty((Collection)oldDataMappingList)) {
                        LOG.info("addDataMappingOtherFieldId oldDataMappingList is not exist");
                        it.setPersonId(Long.valueOf(ID.genLongId()));
                        it.setEmployeeId(Long.valueOf(ID.genLongId()));
                        it.setCmpempId(Long.valueOf(ID.genLongId()));
                        FourFloorPersonIdEntry fourFloorPersonIdEntry = new FourFloorPersonIdEntry(it.getPersonId(), it.getEmployeeId(), it.getCmpempId(), it.getDepempId());
                        oldDataMappingList.add(fourFloorPersonIdEntry);
                        numberSourceSysIdAndDataMappingMap.put(numberSourceSysId, oldDataMappingList);
                    } else if (employeeStatusMap.get(it.getNumber()) != null && Boolean.TRUE.equals(employeeStatusMap.get(it.getNumber()))) {
                        LOG.info("addDataMappingOtherFieldId add personEmpOrgrels ");
                        it.setPersonId(((FourFloorPersonIdEntry)oldDataMappingList.get(0)).getPersonId());
                        it.setEmployeeId(((FourFloorPersonIdEntry)oldDataMappingList.get(0)).getEmployeeId());
                        it.setCmpempId(((FourFloorPersonIdEntry)oldDataMappingList.get(0)).getCmpempId());
                    } else {
                        LOG.info("addDataMappingOtherFieldId New job number occupied for onboarding\n");
                        bizDataSyncDataMappingBo.setOtherInfo(Boolean.FALSE);
                        it.setPersonId(Long.valueOf(ID.genLongId()));
                        it.setEmployeeId(Long.valueOf(ID.genLongId()));
                        it.setCmpempId(Long.valueOf(ID.genLongId()));
                        it.setEffectiveStatus("1");
                        Map<String, Long> fourFloorPersonIdMap = this.getFourFloorPersonIdMap((DataMapping)it);
                        argsList.add(this.buildBizPersonDataMappingArgs(sourceDataKey, number, oldEmpNumber, fourFloorPersonIdMap));
                    }
                }
            });
            this.handleExtend(needSaveDataMappingList, argsList);
        }
    }

    private BizPersonDataMappingArgs buildBizPersonDataMappingArgs(String sourceDataKey, String number, String oldNumber, Map<String, Long> fourFloorPersonIdMap) {
        BizPersonDataMappingArgs args = new BizPersonDataMappingArgs();
        args.setNumber(number);
        args.setOldNumber(oldNumber);
        args.setSourceDataKey(sourceDataKey);
        args.setPersonIdMap(fourFloorPersonIdMap);
        return args;
    }

    private void handleExtend(List<DataMapping> needSaveDataMappingList, List<BizPersonDataMappingArgs> argsList) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new BizPersonDataMappingExtendUpdateDefault(), IBizPersonDataMappingExtendUpdate.class, (String)"kd.sdk.hdtc.hrdi.adaptor.extend.IBizPersonDataMappingExtendUpdate", null);
        pluginProxy.callBefore(adaptorExt -> {
            adaptorExt.afterGenerateFourFloorPersonId(argsList);
            return null;
        });
        Map<String, Map> sourceDataKeyIdAndFourFloorPersonIdMap = argsList.stream().collect(Collectors.toMap(BizPersonDataMappingArgs::getSourceDataKey, BizPersonDataMappingArgs::getPersonIdMap));
        needSaveDataMappingList.forEach(dataMapping -> {
            String sourceDataKey = dataMapping.getSourceDataKey();
            Map fourFloorPersonIdMap = (Map)sourceDataKeyIdAndFourFloorPersonIdMap.get(sourceDataKey);
            if (fourFloorPersonIdMap != null) {
                dataMapping.setPersonId((Long)fourFloorPersonIdMap.get("personid"));
                dataMapping.setEmployeeId((Long)fourFloorPersonIdMap.get("employeeid"));
                dataMapping.setDepempId((Long)fourFloorPersonIdMap.get("depempid"));
                dataMapping.setCmpempId((Long)fourFloorPersonIdMap.get("cmpempid"));
                dataMapping.setBizDataKey((Long)fourFloorPersonIdMap.get("depempid"));
            }
        });
    }

    private Map<String, Long> getFourFloorPersonIdMap(DataMapping it) {
        HashMap fourFloorPersonIdMap = Maps.newHashMapWithExpectedSize((int)4);
        fourFloorPersonIdMap.put("personid", it.getPersonId());
        fourFloorPersonIdMap.put("employeeid", it.getEmployeeId());
        fourFloorPersonIdMap.put("depempid", it.getDepempId());
        fourFloorPersonIdMap.put("cmpempid", it.getCmpempId());
        return fourFloorPersonIdMap;
    }

    private Map<String, List<FourFloorPersonIdEntry>> getOldDataMappingInfo(List<DataMapping> needSaveDataMappingList) {
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)needSaveDataMappingList.size());
        ArrayList sourceSysIdList = Lists.newArrayListWithExpectedSize((int)needSaveDataMappingList.size());
        needSaveDataMappingList.forEach(dataMapping -> {
            numberList.add(dataMapping.getNumber());
            DynamicObject sourceSys = dataMapping.getSourceSys();
            sourceSysIdList.add(sourceSys != null ? sourceSys.getLong("id") : 0L);
        });
        QFilter sourceSysFilter = new QFilter("hrdisourcesys.id", "in", (Object)sourceSysIdList);
        QFilter numberFilter = new QFilter("number", "in", (Object)numberList);
        QFilter effectiveStatusFilter = new QFilter("effectivestatus", "=", (Object)"2");
        Object[] dynamicObjects = this.query("entityobjid,hrdisourcesys,hrdisourcesyskey,bizdatakey,personid,employeeid,depempid,cmpempid,number,effectivestatus", new QFilter[]{sourceSysFilter, numberFilter, effectiveStatusFilter});
        HashMap numberSourceSysIdAndDataMappingMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            Stream.of(dynamicObjects).forEach(dd -> {
                String number = dd.getString("number");
                DynamicObject sourceSys = dd.getDynamicObject("hrdisourcesys");
                long sourceSysId = sourceSys != null ? sourceSys.getLong("id") : 0L;
                List oldDataMappingList = numberSourceSysIdAndDataMappingMap.getOrDefault(number + sourceSysId, new ArrayList());
                FourFloorPersonIdEntry fourFloorPersonIdEntry = new FourFloorPersonIdEntry(Long.valueOf(dd.getLong("personid")), Long.valueOf(dd.getLong("employeeid")), Long.valueOf(dd.getLong("cmpempid")), Long.valueOf(dd.getLong("depempid")));
                oldDataMappingList.add(fourFloorPersonIdEntry);
                numberSourceSysIdAndDataMappingMap.put(number + sourceSysId, oldDataMappingList);
            });
        }
        return numberSourceSysIdAndDataMappingMap;
    }

    @Override
    public void addOtherField(DynamicObject dy, DataMapping dataMapping) {
        dy.set("personid", (Object)dataMapping.getPersonId());
        dy.set("cmpempid", (Object)dataMapping.getCmpempId());
        dy.set("employeeid", (Object)dataMapping.getEmployeeId());
        dy.set("depempid", (Object)dataMapping.getDepempId());
        dy.set("number", (Object)dataMapping.getNumber());
        dy.set("effectivestatus", (Object)dataMapping.getEffectiveStatus());
    }

    @Override
    public void setDataMappingOtherField(DataMapping dm, DataMapping dataMapping) {
        dataMapping.setPersonId(dm.getPersonId());
        dataMapping.setDepempId(dm.getDepempId());
        dataMapping.setEmployeeId(dm.getEmployeeId());
        dataMapping.setCmpempId(dm.getCmpempId());
        dataMapping.setNumber(dm.getNumber());
        dataMapping.setEffectiveStatus(dm.getEffectiveStatus());
    }

    @Override
    public void setQueryMappingOtherField(List<DynamicObject> midDynamicObjectList, DataMapping dataMapping) {
        DynamicObject dy = midDynamicObjectList.get(0);
        dataMapping.setNumber(dy.getString("empnumber2"));
    }

    @Override
    public DynamicObject getEmptyObject() {
        return this.generateEmptyDynamicObject();
    }
}

