/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.datamapping.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.application.external.entity.IHricMidtableTplEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.IHRICMidTableCovert;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.datamapping.IDataMappingRecordDomainService;
import kd.hdtc.hrdi.business.domain.datamapping.entity.DataMappingFactory;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingRecordEntityService;
import kd.hdtc.hrdi.business.domain.datamapping.param.DataMappingRecordEntity;
import kd.hdtc.hrdi.business.domain.datamapping.param.DataMappingRecordParam;

public class DataMappingRecordDomainServiceImpl
implements IDataMappingRecordDomainService {
    private static Log LOG = LogFactory.getLog(DataMappingRecordDomainServiceImpl.class);
    private final IDataMappingRecordEntityService dataMappingRecordEntityService = ServiceFactory.getService(IDataMappingRecordEntityService.class);
    private final IHricMidtableTplEntityService midTableTplEntityService = ServiceFactory.getService(IHricMidtableTplEntityService.class);
    private IHRDIBaseConfigDomainService baseConfigDomainService = ServiceFactory.getService(IHRDIBaseConfigDomainService.class);

    @Override
    public void initDataMappingRecord(String batchNumber, List<DataMappingRecordParam> params) {
        List<DynamicObject> dataMappingRecordList;
        Map<String, DynamicObject> dynamicObjectMap;
        LOG.info("the DataMappingRecordDomainServiceImpl handle initDataMappingRecord start");
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        Set<String> initMidTableNumbers = this.parseInitMidTableNumbers(params);
        if (CollectionUtils.isEmpty(initMidTableNumbers)) {
            LOG.info("the DataMappingRecordDomainServiceImpl handle initDataMappingRecord param is null");
            return;
        }
        Map<String, DataMappingRecordEntity> dataMappingRecordEntityMap = this.parseDataMappingRecordFromMemory(batchNumber, initMidTableNumbers, params);
        List<DynamicObject> dataMappingRecords = this.createDataMappingRecord(batchNumber, initMidTableNumbers, dataMappingRecordEntityMap, dynamicObjectMap = this.parseDataMappingRecordFormDB(dataMappingRecordList = this.dataMappingRecordEntityService.queryDataMappingRecord(initMidTableNumbers)));
        if (CollectionUtils.isNotEmpty(dataMappingRecords)) {
            LOG.info("the DataMappingRecordDomainServiceImpl handle initDataMappingRecord save start");
            this.dataMappingRecordEntityService.save(dataMappingRecords.toArray(new DynamicObject[0]));
        }
        LOG.info("the DataMappingRecordDomainServiceImpl handle initDataMappingRecord end");
    }

    @Override
    public DynamicObject[] queryDataMappingRecord(String batchNumber) {
        return this.dataMappingRecordEntityService.queryDataMappingRecordByBatchNumber(batchNumber);
    }

    private List<DynamicObject> createDataMappingRecord(String batchNumber, Set<String> initMidTableNumbers, Map<String, DataMappingRecordEntity> dataMappingRecordEntityMap, Map<String, DynamicObject> dynamicObjectMap) {
        if (CollectionUtils.isEmpty(initMidTableNumbers)) {
            return null;
        }
        String isFullSync = this.baseConfigDomainService.queryBaseConfigValueByNumber("init.data.mapping.full.sync");
        LOG.info("the DataMappingRecordDomainServiceImpl handle createDataMappingRecord the param isFullSync is :", (Object)isFullSync);
        ArrayList dataMappingRecords = Lists.newArrayListWithExpectedSize((int)initMidTableNumbers.size());
        for (String initMidTableNumber : initMidTableNumbers) {
            DynamicObject[] midTableDataCount;
            DynamicObject newDataMappingRecord = this.dataMappingRecordEntityService.generateEmptyDynamicObject();
            String startOffset = "0";
            if (dynamicObjectMap != null && dynamicObjectMap.get(initMidTableNumber) != null) {
                DynamicObject dynamicObject = dynamicObjectMap.get(initMidTableNumber);
                if (!"1".equals(isFullSync)) {
                    startOffset = dynamicObject.getString("startoffset");
                }
                newDataMappingRecord.set("source", (Object)dynamicObject.getLong("id"));
            }
            if (dataMappingRecordEntityMap != null && dataMappingRecordEntityMap.get(initMidTableNumber) != null) {
                DataMappingRecordEntity dataMappingRecordEntity = dataMappingRecordEntityMap.get(initMidTableNumber);
                newDataMappingRecord.set("intsource", (Object)dataMappingRecordEntity.getIntSource());
                newDataMappingRecord.set("initentityobject", (Object)dataMappingRecordEntity.getInitEntityObject());
                newDataMappingRecord.set("startoffset", (Object)startOffset);
                newDataMappingRecord.set("relationinfo", (Object)dataMappingRecordEntity.getRelationInfo());
            }
            if ((midTableDataCount = this.midTableTplEntityService.getMidTableDataCount(initMidTableNumber, Long.parseLong(startOffset))) != null && midTableDataCount.length > 0) {
                newDataMappingRecord.set("totalcount", (Object)midTableDataCount.length);
                DynamicObject dynamicObject = midTableDataCount[midTableDataCount.length - 1];
                newDataMappingRecord.set("endoffset", (Object)String.valueOf(dynamicObject.getLong("id")));
            } else {
                newDataMappingRecord.set("totalcount", (Object)0);
                newDataMappingRecord.set("endoffset", (Object)startOffset);
            }
            newDataMappingRecord.set("id", (Object)ID.genLongId());
            newDataMappingRecord.set("batchnumber", (Object)batchNumber);
            newDataMappingRecord.set("midtablenumber", (Object)initMidTableNumber);
            newDataMappingRecord.set("successcount", (Object)0);
            newDataMappingRecord.set("failcount", (Object)0);
            newDataMappingRecord.set("ignorecount", (Object)0);
            newDataMappingRecord.set("handlestatus", (Object)"0");
            newDataMappingRecord.set("createtime", (Object)new Date());
            newDataMappingRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
            dataMappingRecords.add(newDataMappingRecord);
        }
        return dataMappingRecords;
    }

    private Set<String> parseInitMidTableNumbers(List<DataMappingRecordParam> params) {
        HashSet allInitMidTableNumbers = Sets.newHashSetWithExpectedSize((int)16);
        params.forEach(dataMappingRecordParam -> {
            IHRICMidTableCovert midTableCovert = new DataMappingFactory().getHRICMidTableCovert(dataMappingRecordParam.getEntityObject());
            Set<String> initMidTableNumbers = midTableCovert.parseInitMidTableNumber(dataMappingRecordParam.getInitMidTableNumber());
            if (CollectionUtils.isNotEmpty(initMidTableNumbers)) {
                allInitMidTableNumbers.addAll(initMidTableNumbers);
                dataMappingRecordParam.setRefMidTableNumberJson(midTableCovert.toRefMidTableNumberJson());
            }
        });
        return allInitMidTableNumbers;
    }

    private Map<String, DataMappingRecordEntity> parseDataMappingRecordFromMemory(String batchNumber, Set<String> initMidTableNumbers, List<DataMappingRecordParam> params) {
        if (CollectionUtils.isEmpty(initMidTableNumbers)) {
            return null;
        }
        HashMap midTableDataMappingRecordMap = Maps.newHashMapWithExpectedSize((int)initMidTableNumbers.size());
        for (DataMappingRecordParam param : params) {
            Map<String, Set<String>> initMidTableNumber = param.getInitMidTableNumber();
            String entityObject = param.getEntityObject();
            DynamicObject intResource = param.getIntResource();
            String refMidTableNumberJson = param.getRefMidTableNumberJson();
            if (CollectionUtils.isEmpty(initMidTableNumber)) continue;
            initMidTableNumber.forEach((initEntityObject, midTableNumbers) -> {
                for (String midTableNumber : midTableNumbers) {
                    if (!initMidTableNumbers.contains(midTableNumber)) continue;
                    DataMappingRecordEntity dataMappingRecordEntity = new DataMappingRecordEntity();
                    dataMappingRecordEntity.setIntSource(intResource);
                    dataMappingRecordEntity.setMidTableNumber(midTableNumber);
                    dataMappingRecordEntity.setBatchNumber(batchNumber);
                    dataMappingRecordEntity.setInitEntityObject((String)initEntityObject);
                    dataMappingRecordEntity.setEntityObject(entityObject);
                    dataMappingRecordEntity.setRelationInfo(refMidTableNumberJson);
                    dataMappingRecordEntity.setStartOffset("0");
                    dataMappingRecordEntity.setHandleStatus("0");
                    dataMappingRecordEntity.setSuccessCount(0);
                    dataMappingRecordEntity.setFailCount(0);
                    dataMappingRecordEntity.setIgnoreCount(0);
                    midTableDataMappingRecordMap.put(midTableNumber, dataMappingRecordEntity);
                }
            });
        }
        return midTableDataMappingRecordMap;
    }

    private Map<String, DynamicObject> parseDataMappingRecordFormDB(List<DynamicObject> dataMappingRecordList) {
        if (CollectionUtils.isEmpty(dataMappingRecordList)) {
            return null;
        }
        HashMap midTableDataMappingRecordMap = Maps.newHashMapWithExpectedSize((int)dataMappingRecordList.size());
        for (DynamicObject dataMappingRecord : dataMappingRecordList) {
            String midTableNumber = dataMappingRecord.getString("midtablenumber");
            midTableDataMappingRecordMap.putIfAbsent(midTableNumber, dataMappingRecord);
        }
        return midTableDataMappingRecordMap;
    }
}

