/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.intgovern.entity.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntEntityCategoryEntityService;

public class IntEntityCategoryEntityServiceImpl
extends AbstractBaseEntityService
implements IIntEntityCategoryEntityService {
    public IntEntityCategoryEntityServiceImpl() {
        super("hrdi_entitycategory");
    }

    @Override
    public Map<String, String> queryBizCategoryByEntityNumberList(Set<String> entityNumberSet) {
        if (CollectionUtils.isEmpty(entityNumberSet)) {
            return new HashMap<String, String>(16);
        }
        QFilter entityObjFilter = new QFilter("entityobj", "in", entityNumberSet);
        Object[] dys = this.query("id,name,entityobj.number,bizcategory", new QFilter[]{entityObjFilter, QFilterConstants.Q_ENABLE});
        HashMap entityObjNumberBizCategoryMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        if (ArrayUtils.isNotEmpty((Object[])dys)) {
            Stream.of(dys).forEach(dy -> entityObjNumberBizCategoryMap.put(dy.getString("entityobj.number"), dy.getString("bizcategory")));
        }
        return entityObjNumberBizCategoryMap;
    }

    @Override
    public String queryBizCategoryByEntityNumber(String entityNumber) {
        QFilter entityObjFilter = new QFilter("entityobj", "=", (Object)entityNumber);
        DynamicObject dyn = this.queryOne("id,name,entityobj.number,bizcategory", new QFilter[]{entityObjFilter, QFilterConstants.Q_ENABLE});
        return dyn == null ? null : dyn.getString("bizcategory");
    }
}

