/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.intgovern.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IntegratedConfEntityService;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;

public class IntEntityCategoryDomainServiceImpl
implements IIntEntityCategoryDomainService {
    private final IntegratedConfEntityService integratedConfEntityService = ServiceFactory.getService(IntegratedConfEntityService.class);

    @Override
    public BizCategoryEnum getCategoryByEntityNumber(String entityNumber) {
        HashSet entityNumberList = Sets.newHashSetWithExpectedSize((int)1);
        entityNumberList.add(entityNumber);
        Map<String, BizCategoryEnum> entityCategoryMap = this.getCategoryByEntityNumber(entityNumberList);
        return entityCategoryMap.get(entityNumber);
    }

    @Override
    public Map<String, BizCategoryEnum> getCategoryByEntityNumber(Set<String> entityNumberSet) {
        Map<String, String> entityCategoryMap = this.integratedConfEntityService.queryEntityTypeByEntityNumberList(entityNumberSet);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)entityNumberSet.size());
        entityNumberSet.forEach(entityNumber -> {
            String category = (String)entityCategoryMap.get(entityNumber);
            BizCategoryEnum categoryEnum = BizCategoryEnum.getCategoryByCode((String)category);
            resultMap.put(entityNumber, categoryEnum == null ? BizCategoryEnum.PERSON_ATTACHED : categoryEnum);
        });
        return resultMap;
    }
}

