/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.intgovern.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntRelationEntityService;

public class IntRelationDomainServiceImpl
implements IIntRelationDomainService {
    private static final Log log = LogFactory.getLog(IntRelationDomainServiceImpl.class);
    private final IIntRelationEntityService iIntRelationEntityService = ServiceFactory.getService(IIntRelationEntityService.class);
    private final IIntSourceDomainService iIntSourceDomainService = ServiceFactory.getService(IIntSourceDomainService.class);

    @Override
    public String queryEntityNumberByMsgSubscriberNumber(String msgSubscriberNumber) {
        QFilter msgSubscriberFilter = new QFilter("msgsubscriber.fbasedataid.msgsubno", "=", (Object)msgSubscriberNumber);
        DynamicObject intRelation = this.iIntRelationEntityService.queryOne("id,name,intsource.entityobj.number", new QFilter[]{msgSubscriberFilter, QFilterConstants.Q_ENABLE});
        return intRelation == null ? "" : intRelation.getString("intsource.entityobj.number");
    }

    @Override
    public List<DynamicObject> queryEnableData(Set<Long> intSourceIdSet, Set<Long> sourceSysIdSet, List<Long> excludePkIdList) {
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        QFilter intSourceIdFilter = new QFilter("intsource.id", "in", intSourceIdSet);
        QFilter sourceSysIdFilter = new QFilter("sourcesys.id", "in", sourceSysIdSet);
        if (CollectionUtils.isNotEmpty(excludePkIdList)) {
            QFilter excludeIdFilter = new QFilter("id", "not in", excludePkIdList);
            qFilterList.add(excludeIdFilter);
        }
        qFilterList.add(intSourceIdFilter);
        qFilterList.add(sourceSysIdFilter);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        String selectProperties = String.join((CharSequence)",", "id", "name", "number", "sourcesys.id", "intdirection", "intsource.id");
        return this.iIntRelationEntityService.queryOriginalList(selectProperties, qFilterList.toArray(new QFilter[0]));
    }

    @Override
    public DynamicObject[] queryEnableData(String intDirection, Long intSourceId, Long sourceSysId) {
        if (intSourceId == null) {
            return new DynamicObject[0];
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        QFilter intSourceIdFilter = new QFilter("intsource.id", "=", (Object)intSourceId);
        qFilterList.add(intSourceIdFilter);
        if (StringUtils.isNotEmpty((String)intDirection)) {
            QFilter intDirectionFilter = new QFilter("intdirection", "=", (Object)intDirection);
            qFilterList.add(intDirectionFilter);
        }
        if (sourceSysId != null) {
            QFilter sourceSysFilter = new QFilter("sourcesys.id", "=", (Object)sourceSysId);
            qFilterList.add(sourceSysFilter);
        }
        String selectProperties = String.join((CharSequence)",", "id", "name", "number", "sourcesys.id", "intdirection", "intsource", "inttype", "intscm");
        return this.iIntRelationEntityService.query(selectProperties, qFilterList.toArray(new QFilter[0]));
    }

    @Override
    public List<Object> queryAllEnableIntScmIdList(String intDirection, String intType) {
        List dynamicObjectList;
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        if (StringUtils.isNotEmpty((String)intDirection)) {
            QFilter intDirectionFilter = new QFilter("intdirection", "=", (Object)intDirection);
            qFilterList.add(intDirectionFilter);
        }
        if (StringUtils.isNotEmpty((String)intType)) {
            QFilter intTypeFilter = new QFilter("inttype", "=", (Object)intType);
            qFilterList.add(intTypeFilter);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dynamicObjectList = this.iIntRelationEntityService.queryOriginalList("intscm.id", qFilterList.toArray(new QFilter[0]))))) {
            // empty if block
        }
        return dynamicObjectList.stream().map(dy -> dy.get("intscm.id")).collect(Collectors.toList());
    }

    @Override
    public DynamicObject[] queryEnableData(String entityNumber, String intDirection, String intType) {
        return this.queryEnableDataByMsgSubNo(entityNumber, intDirection, intType, "");
    }

    @Override
    public DynamicObject[] queryEnableDataByMsgSubNo(String entityNumber, String intDirection, String intType, String msgSubNo) {
        List<Long> intSourceIdList = this.iIntSourceDomainService.queryIdListByEntityNumbers(Collections.singletonList(entityNumber));
        if (CollectionUtils.isEmpty(intSourceIdList)) {
            return new DynamicObject[0];
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        QFilter intSourceIdFilter = new QFilter("intsource.id", "in", intSourceIdList);
        qFilterList.add(intSourceIdFilter);
        if (StringUtils.isNotEmpty((String)intDirection)) {
            QFilter intDirectionFilter = new QFilter("intdirection", "=", (Object)intDirection);
            qFilterList.add(intDirectionFilter);
        }
        if (StringUtils.isNotEmpty((String)intType)) {
            QFilter intTypeFilter = new QFilter("inttype", "=", (Object)intType);
            qFilterList.add(intTypeFilter);
        }
        if (StringUtils.isNotEmpty((String)msgSubNo)) {
            QFilter msgSubscriberFilter = new QFilter("msgsubscriber.fbasedataid.msgsubno", "=", (Object)msgSubNo);
            qFilterList.add(msgSubscriberFilter);
        }
        String selectProperties = String.join((CharSequence)",", "id", "name", "number", "sourcesys.id", "intdirection", "intsource", "inttype", "intscm");
        return this.iIntRelationEntityService.query(selectProperties, qFilterList.toArray(new QFilter[0]));
    }

    @Override
    public Map<String, List<DynamicObject>> queryEnableData(Collection<String> entityNumberList, String intDirection, String intType) {
        return this.queryEnableDataByMsgSubNo(entityNumberList, intDirection, intType, "");
    }

    @Override
    public Map<String, List<DynamicObject>> queryEnableDataByMsgSubNo(Collection<String> entityNumberList, String intDirection, String intType, String msgSubNo) {
        Map<String, List<Long>> entityNumberIntSourceIdsMap = this.iIntSourceDomainService.queryByEntityNumbers(entityNumberList);
        if (CollectionUtils.isEmpty(entityNumberIntSourceIdsMap)) {
            return new HashMap<String, List<DynamicObject>>(16);
        }
        ArrayList intSourceIdList = Lists.newArrayListWithExpectedSize((int)entityNumberList.size());
        entityNumberIntSourceIdsMap.forEach((entityNumber, idList) -> intSourceIdList.addAll(idList));
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        QFilter intSourceIdFilter = new QFilter("intsource.id", "in", (Object)intSourceIdList);
        qFilterList.add(intSourceIdFilter);
        if (StringUtils.isNotEmpty((String)intDirection)) {
            QFilter intDirectionFilter = new QFilter("intdirection", "=", (Object)intDirection);
            qFilterList.add(intDirectionFilter);
        }
        if (StringUtils.isNotEmpty((String)intType)) {
            QFilter intTypeFilter = new QFilter("inttype", "=", (Object)intType);
            qFilterList.add(intTypeFilter);
        }
        if (StringUtils.isNotEmpty((String)msgSubNo)) {
            QFilter msgSubscriberFilter = new QFilter("msgsubscriber.fbasedataid.msgsubno", "=", (Object)msgSubNo);
            qFilterList.add(msgSubscriberFilter);
        }
        String selectProperties = String.join((CharSequence)",", "id", "name", "number", "sourcesys", "intdirection", "intsource", "inttype", "intscm");
        DynamicObject[] intRelations = this.iIntRelationEntityService.query(selectProperties, qFilterList.toArray(new QFilter[0]));
        Map<Long, List<DynamicObject>> intSourceIdIntRelationListMap = Stream.of(intRelations).collect(Collectors.groupingBy(dy -> dy.getLong("intsource.id")));
        HashMap entityNumberIntRelationListMap = Maps.newHashMapWithExpectedSize((int)entityNumberList.size());
        entityNumberIntSourceIdsMap.forEach((entityNumber, idList) -> {
            List intRelationList = entityNumberIntRelationListMap.getOrDefault(entityNumber, new ArrayList());
            idList.forEach(id -> {
                List dynamicObjects = (List)intSourceIdIntRelationListMap.get(id);
                if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                    intRelationList.addAll(dynamicObjects);
                }
            });
            entityNumberIntRelationListMap.put(entityNumber, intRelationList);
        });
        return entityNumberIntRelationListMap;
    }

    @Override
    public Map<Long, DynamicObject> queryRelationById(Collection<Long> relationIds) {
        QFilter idFilter = new QFilter("id", "in", relationIds);
        String selectProperties = String.join((CharSequence)",", "id", "name", "number", "sourcesys.id", "intdirection", "intsource", "inttype", "intscm", "intmode", "eventdef", "evtsubscribe", "msgsubscriber", "msgpublisher");
        DynamicObject[] intRelations = this.iIntRelationEntityService.query(selectProperties, new QFilter[]{idFilter});
        if (intRelations != null) {
            return Arrays.stream(intRelations).collect(Collectors.toMap(relation -> relation.getLong("id"), relation -> relation, (k1, k2) -> k1));
        }
        return Maps.newLinkedHashMapWithExpectedSize((int)0);
    }

    @Override
    public void saveRelation(List<DynamicObject> relationList) {
        this.iIntRelationEntityService.save(relationList.toArray(new DynamicObject[0]));
    }
}

