/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.intgovern.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.enums.MetadataOperateTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.application.external.entity.IOpenApiEntityService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntSourceEntityService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableDomainService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;
import kd.hdtc.hrdi.common.openapi.ApiErrorCodeCustom;
import kd.hdtc.hrdi.common.openapi.OpenApiHrdiUtils;
import kd.hdtc.hrdi.common.pojo.OpenApiEntry;
import kd.hr.hbp.common.util.HRStringUtils;

public class IntSourceDomainServiceImpl
implements IIntSourceDomainService {
    private static final Log LOG = LogFactory.getLog(IntSourceDomainServiceImpl.class);
    private final IOpenApiEntityService openApiEntityService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IOpenApiEntityService.class);
    private final IMidTableConfigEntityService midTableConfigEntityService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableConfigEntityService.class);
    private final IMidTableDomainService midTableDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableDomainService.class);
    private final IIntSourceEntityService iIntSourceEntityService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IIntSourceEntityService.class);
    private final IMidTableConfigDomainService midTableConfigDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableConfigDomainService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private static final String SELECT_COMMON_FIELDS = String.join((CharSequence)",", "id", "name", "number", "entityobj", "midtableconfig");
    private static final String SELECT_PROPERTIES = "midentitynumber,entityobj.name,  treeentryentity.id, treeentryentity.entitynumber, treeentryentity.ismustinput, treeentryentity.entityname,treeentryentity.numberalias, treeentryentity.referenceprop, treeentryentity.isintegrationfield,treeentryentity.defaultvalue,treeentryentity.fielddescription";
    private final String DEFAULT_VALUE = ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u4e3a%s", (String)"IntSourceDomainServiceImpl_16", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private static final String PRESCRIPT_TAG = "var cloudId = 'hdtc';\nvar appId = 'hrdi';\nvar serviceName = 'IIntMidTableService';\nvar methodName = 'syncMidTableData';\nvar params = ['%s',batchnumber,hrdisourcesys,data];\nvar result = MS.invokeBizService(cloudId, appId, serviceName, methodName, params);\n";
    private static final String PRESCRIPT_TAG_DELETE = "var cloudId = 'hdtc';\nvar appId = 'hrdi';\nvar serviceName = 'IIntMidTableService';\nvar methodName = 'deleteMidTableData';\nvar params = ['%s',batchnumber,hrdisourcesys,data];\nvar result = MS.invokeBizService(cloudId, appId, serviceName, methodName, params);\n";
    private final String XH_HR_NAME = ResManager.loadKDString((String)"\u661f\u701aHR", (String)"IntSourceDomainServiceImpl_4", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);

    @Override
    public boolean publishInOpenApiDyn(List<Long> midConfigIdList) {
        DynamicObject[] midTableConfigs = this.queryMidTableConfig(midConfigIdList);
        List<DynamicObject> openApiObjectList = this.packageOpenApiDyList(midTableConfigs);
        return this.publishOpenApiDyn(openApiObjectList, midTableConfigs, "1");
    }

    private boolean publishDeleteApiDyn(List<Long> midConfigIdList) {
        DynamicObject[] midTableConfigs = this.queryMidTableConfig(midConfigIdList);
        List<DynamicObject> openApiObjectList = this.packageDeleteApiDyList(midTableConfigs);
        return this.publishOpenApiDyn(openApiObjectList, midTableConfigs, "2");
    }

    private boolean publishOpenApiDyn(List<DynamicObject> openApiObjectList, DynamicObject[] midTableConfigs, String apiType) {
        this.openApiEntityService.deleteByNumberSet(this.getOpenApiNumberByMidTableConfig(midTableConfigs, apiType));
        return this.openApiEntityService.opSave(openApiObjectList);
    }

    private DynamicObject[] queryMidTableConfig(List<Long> midConfigIdList) {
        QFilter idFilter = new QFilter("id", "in", midConfigIdList);
        return this.midTableConfigEntityService.query(SELECT_PROPERTIES, new QFilter[]{QFilterConstants.Q_ENABLE, idFilter});
    }

    @Override
    public void publishInOpenApiDyn(DynamicObject[] intSourceDyns) {
        if (intSourceDyns == null || intSourceDyns.length == 0) {
            return;
        }
        ArrayList midConfigIdList = Lists.newArrayListWithExpectedSize((int)intSourceDyns.length);
        Arrays.stream(intSourceDyns).forEach(dy -> midConfigIdList.add(dy.getLong("midtableconfig.id")));
        boolean openApiSave = this.publishInOpenApiDyn(midConfigIdList);
        if (openApiSave) {
            this.iIntSourceEntityService.batchChangePublishStatus(intSourceDyns, true);
        }
    }

    @Override
    public void publishDeleteApiDyn(DynamicObject[] intSourceDyns) {
        if (intSourceDyns == null || intSourceDyns.length == 0) {
            return;
        }
        ArrayList midConfigIdList = Lists.newArrayListWithExpectedSize((int)intSourceDyns.length);
        Arrays.stream(intSourceDyns).forEach(dy -> midConfigIdList.add(dy.getLong("midtableconfig.id")));
        boolean openApiSave = this.publishDeleteApiDyn(midConfigIdList);
        if (openApiSave) {
            this.iIntSourceEntityService.batchChangePublishStatus(intSourceDyns, true);
        }
    }

    @Override
    public void publishOpenApiByEntityNumber(Collection<String> entityNumberList) {
        DynamicObject[] intSourceDyns = this.queryIntSourceByEntityNumbers(entityNumberList);
        this.publishInOpenApiDyn(intSourceDyns);
    }

    @Override
    public void cancelInOpenApiDyn(List<Long> midConfigIdList) {
        QFilter idFilter = new QFilter("id", "in", midConfigIdList);
        DynamicObject[] midTableConfigs = this.midTableConfigEntityService.query("midentitynumber,ispublish", new QFilter[]{QFilterConstants.Q_ENABLE, idFilter});
        this.openApiEntityService.deleteByNumberSet(this.getOpenApiNumberByMidTableConfig(midTableConfigs, "3"));
    }

    private Set<String> getOpenApiNumberByMidTableConfig(DynamicObject[] midTableConfigs, String apiType) {
        HashSet<String> apiNumberSet = new HashSet<String>(16);
        Arrays.stream(midTableConfigs).forEach(midTableConfig -> {
            if (StringUtils.equals((String)"1", (String)apiType) || StringUtils.equals((String)"3", (String)apiType)) {
                apiNumberSet.add(midTableConfig.getString("midentitynumber") + "/" + "save");
            }
            if (StringUtils.equals((String)"2", (String)apiType) || StringUtils.equals((String)"3", (String)apiType)) {
                apiNumberSet.add(midTableConfig.getString("midentitynumber") + "/" + "delete");
            }
        });
        return apiNumberSet;
    }

    private List<DynamicObject> packageOpenApiDyList(DynamicObject[] midTableConfigs) {
        ArrayList<DynamicObject> openApiObjectList = new ArrayList<DynamicObject>(midTableConfigs.length);
        for (DynamicObject midTableConfig : midTableConfigs) {
            String midEntityNumber = midTableConfig.getString("midentitynumber");
            if (MetadataUtils.isExist((String)midEntityNumber)) {
                DynamicObject saveOpenApiObject = this.openApiEntityService.generateEmptyDynamicObject();
                this.makeSaveOpenApiDyn(saveOpenApiObject, midTableConfig);
                openApiObjectList.add(saveOpenApiObject);
                continue;
            }
            LOG.info("publish api midEntityNumber is not exist:{}", (Object)midEntityNumber);
        }
        return openApiObjectList;
    }

    private List<DynamicObject> packageDeleteApiDyList(DynamicObject[] midTableConfigs) {
        ArrayList<DynamicObject> openApiObjectList = new ArrayList<DynamicObject>(midTableConfigs.length);
        for (DynamicObject midTableConfig : midTableConfigs) {
            String midEntityNumber = midTableConfig.getString("midentitynumber");
            if (MetadataUtils.isExist((String)midEntityNumber)) {
                DynamicObject deleteOpenApiObject = this.openApiEntityService.generateEmptyDynamicObject();
                this.makeDeleteOpenApiDyn(deleteOpenApiObject, midTableConfig);
                openApiObjectList.add(deleteOpenApiObject);
                continue;
            }
            LOG.info("publish api midEntityNumber is not exist:{}", (Object)midEntityNumber);
        }
        return openApiObjectList;
    }

    private void makeDeleteOpenApiDyn(DynamicObject openApiObject, DynamicObject midTableConfig) {
        this.setApi(openApiObject, midTableConfig, "delete");
        this.setApiBody(openApiObject, midTableConfig, "delete");
        this.setApiResp(openApiObject);
        openApiObject.set("errorcodeentity", (Object)this.setErrorCode());
    }

    private void makeSaveOpenApiDyn(DynamicObject openApiObject, DynamicObject midTableConfig) {
        this.setApi(openApiObject, midTableConfig, "save");
        this.setApiBody(openApiObject, midTableConfig, "save");
        this.setApiResp(openApiObject);
        openApiObject.set("errorcodeentity", (Object)this.setErrorCode());
    }

    private void setApi(DynamicObject openApiObject, DynamicObject midTableConfig, String apiType) {
        Date today = new Date();
        openApiObject.set("number", (Object)(midTableConfig.getString("midentitynumber") + "/" + apiType));
        openApiObject.set("name", (Object)midTableConfig.getString("name"));
        openApiObject.set("httpmethod", (Object)"1");
        openApiObject.set("createtime", (Object)today);
        openApiObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        openApiObject.set("appid_id", (Object)"33ZTSDV7P6VX");
        openApiObject.set("customsort", (Object)"1681353673772554240");
        String url = String.format(Locale.ROOT, "/v2/hrdi/%s/save", midTableConfig.getString("midentitynumber"));
        if ("delete".equals(apiType)) {
            url = String.format(Locale.ROOT, "/v2/hrdi/%s/delete", midTableConfig.getString("midentitynumber"));
        }
        openApiObject.set("urlformat", (Object)url);
        openApiObject.set("enable", (Object)"1");
        openApiObject.set("status", (Object)"C");
        openApiObject.set("apiservicetype", (Object)"3");
        openApiObject.set("version", (Object)"2");
        String isvId = ISVServiceHelper.getISVInfo().getId();
        openApiObject.set("isvid", (Object)isvId);
        openApiObject.set("cosmicver", (Object)"4.0.004");
        openApiObject.set("stdmodifytime", (Object)today);
        openApiObject.set("discription", (Object)ResManager.loadKDString((String)"HR\u6570\u636e\u96c6\u6210\u4e2d\u5fc3\u52a8\u6001\u751f\u6210\u7684\u4e2d\u95f4\u8868\u5199\u5165\u63a5\u53e3\u670d\u52a1", (String)"IntSourceDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        String tableNumber = midTableConfig.getString("midentitynumber");
        if ("delete".equals(apiType)) {
            openApiObject.set("prescript_tag", (Object)String.format(Locale.ROOT, PRESCRIPT_TAG_DELETE, tableNumber));
        } else {
            openApiObject.set("prescript_tag", (Object)String.format(Locale.ROOT, PRESCRIPT_TAG, tableNumber));
        }
    }

    private void setApiBody(DynamicObject openApiObject, DynamicObject midTableConfig, String apiType) {
        DynamicObjectCollection treeEntryEntities = midTableConfig.getDynamicObjectCollection("treeentryentity");
        DynamicObjectCollection bodyEntryEntity = new DynamicObjectCollection();
        long dataId = ID.genLongId();
        ArrayList bodyList = Lists.newArrayListWithCapacity((int)10);
        String batchNumberParamDes = ResManager.loadKDString((String)"\u6279\u6b21\u53f7", (String)"IntSourceDomainServiceImpl_5", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
        String batchNumberExample = ResManager.loadKDString((String)"\u975e\u5fc5\u586b\uff0c\u4f46\u662f\u5982\u679c\u4e3a\u7a7a\uff0c\u4f1a\u9ed8\u8ba4\u751f\u6210\u4e00\u4e2a\u6279\u6b21\uff08\u89c4\u5219\uff1a\u5e74\u6708\u65e5\u65f6\u5206\u79d2\u6beb\u79d2+4\u4f4d\u968f\u673a\u6570\uff0c\u957f\u5ea6\uff1a21\uff09", (String)"IntSourceDomainServiceImpl_6", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
        bodyList.add(new OpenApiEntry("batchnumber", "String", "0", "1", batchNumberParamDes, "0", batchNumberExample));
        String sourceSysParamDes = ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf", (String)"IntSourceDomainServiceImpl_7", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
        String sourceSysExample = ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"IntSourceDomainServiceImpl_8", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
        bodyList.add(new OpenApiEntry("hrdisourcesys", "String", "0", "1", sourceSysParamDes, "1", sourceSysExample));
        String dataParamDes = ResManager.loadKDString((String)"\u9700\u540c\u6b65\u7684\u6570\u636e", (String)"IntSourceDomainServiceImpl_3", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
        bodyList.add(new OpenApiEntry("data", "Struct", "1", "1", dataParamDes, "1", "[]"));
        bodyList.forEach(row -> {
            DynamicObject bodyDyn = this.getApiBodyDynamicObject((OpenApiEntry)row);
            if ("data".equals(row.getParamName())) {
                bodyDyn.set("id", (Object)dataId);
            }
            bodyEntryEntity.add((Object)bodyDyn);
        });
        bodyEntryEntity.addAll((Collection)this.makeMidTableField(treeEntryEntities, midTableConfig.getString("midentitynumber"), dataId, apiType));
        openApiObject.set("bodyentryentity", (Object)bodyEntryEntity);
    }

    private DynamicObject getApiBodyDynamicObject(OpenApiEntry row) {
        DynamicObject bodyDyn = this.openApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
        bodyDyn.set("paramname", (Object)row.getParamName());
        bodyDyn.set("paramtype", (Object)row.getParamType());
        bodyDyn.set("is_req_mul_value", (Object)row.getMulValue());
        bodyDyn.set("body_level", (Object)row.getLevel());
        bodyDyn.set("bodyparamdes", (Object)row.getParamDes());
        bodyDyn.set("must", (Object)row.getMust());
        bodyDyn.set("example", (Object)row.getExample());
        return bodyDyn;
    }

    private void setApiResp(DynamicObject openApiObject) {
        DynamicObjectCollection dynCollection = new DynamicObjectCollection();
        ArrayList<OpenApiEntry> respList = new ArrayList<OpenApiEntry>();
        respList.add(new OpenApiEntry("result", "Any", "0", "1", "result", "1", "result"));
        respList.forEach(row -> {
            DynamicObject resp = this.openApiEntityService.generateEmptyEntryDynamicObject("respentryentity");
            resp.set("respparamname", (Object)row.getParamName());
            resp.set("respparamtype", (Object)row.getParamType());
            resp.set("is_resp_mul_value", (Object)row.getMulValue());
            resp.set("resp_level", (Object)row.getLevel());
            resp.set("respdes", (Object)row.getParamDes());
            resp.set("respexample", (Object)row.getExample());
            dynCollection.add((Object)resp);
        });
        openApiObject.set("respentryentity", (Object)dynCollection);
    }

    private DynamicObjectCollection setErrorCode() {
        DynamicObjectCollection dynCollection = new DynamicObjectCollection();
        for (ApiErrorCodeCustom item : ApiErrorCodeCustom.values()) {
            DynamicObject errorCodeDyn = this.openApiEntityService.generateEmptyEntryDynamicObject("errorcodeentity");
            errorCodeDyn.set("errorcode", (Object)item.getCode());
            errorCodeDyn.set("errorcodedesc", item.getErrorMsg().get());
            dynCollection.add((Object)errorCodeDyn);
        }
        return dynCollection;
    }

    private DynamicObjectCollection makeMidTableField(DynamicObjectCollection treeEntryEntities, String midTableNumber, long dataId, String apiType) {
        DynamicObject midTableDyn = this.midTableDomainService.generateEmptyDynamicObject(midTableNumber);
        DynamicObjectCollection bodyEntryEntity = new DynamicObjectCollection();
        String sourceSysKeyParamDes = ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u552f\u4e00\u6807\u8bc6", (String)"IntSourceDomainServiceImpl_9", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
        String sourceSysKeyExample = ResManager.loadKDString((String)"\u786e\u5b9a\u6570\u636e\u552f\u4e00\u7684\u6807\u8bc6\uff0c\u7531\u6e90\u5934\u63a7\u5236", (String)"IntSourceDomainServiceImpl_10", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
        DynamicObject sourceSysKeyDyn = this.getApiBodyDynamicObject(new OpenApiEntry("hrdisourcesyskey", "String", "0", "2", sourceSysKeyParamDes, "1", sourceSysKeyExample));
        sourceSysKeyDyn.set("pid", (Object)dataId);
        bodyEntryEntity.add((Object)sourceSysKeyDyn);
        if ("delete".equals(apiType)) {
            return bodyEntryEntity;
        }
        for (DynamicObject tree : treeEntryEntities) {
            if (!tree.getBoolean("isintegrationfield")) continue;
            String number = tree.getString("numberalias");
            IDataEntityProperty property = (IDataEntityProperty)midTableDyn.getDataEntityType().getProperties().get((Object)number);
            if (property == null) {
                LOG.info("publish openAPI midTable property is null. midTableNumber= {},  property= {}", (Object)midTableNumber, (Object)number);
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                this.handleMulilangProp(dataId, bodyEntryEntity, tree, number);
                continue;
            }
            DynamicObject body = this.openApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
            body.set("paramname", (Object)number);
            body.set("paramtype", (Object)OpenApiHrdiUtils.getPropertyType((IDataEntityProperty)property));
            body.set("must", (Object)this.isMust(tree));
            body.set("bodyparamdes", (Object)this.getDescription(tree));
            body.set("body_level", (Object)"2");
            body.set("example", OpenApiHrdiUtils.getDefaultValue((IDataEntityProperty)property));
            body.set("pid", (Object)dataId);
            bodyEntryEntity.add((Object)body);
        }
        return bodyEntryEntity;
    }

    private String isMust(DynamicObject tree) {
        String defaultValue = tree.getString("defaultvalue");
        String must = StringUtils.isNotEmpty((String)defaultValue) ? "0" : (tree.getBoolean("ismustinput") ? "1" : "0");
        return must;
    }

    private String getDescription(DynamicObject tree) {
        String defaultValue;
        String description = tree.getString("fielddescription");
        if (StringUtils.isEmpty((String)description) && (description = tree.getString("entityname")).endsWith("*")) {
            description = description.substring(0, description.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)(defaultValue = tree.getString("defaultvalue")))) {
            description = String.join((CharSequence)",", description, String.format(Locale.ROOT, this.DEFAULT_VALUE, defaultValue));
        }
        if (HRStringUtils.isNotEmpty((String)defaultValue) && defaultValue.length() > 255) {
            return defaultValue.substring(0, 249) + "......";
        }
        return description;
    }

    private void handleMulilangProp(long dataId, DynamicObjectCollection bodyEntryEntity, DynamicObject tree, String number) {
        DynamicObject body = this.openApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
        body.set("paramname", (Object)number);
        body.set("paramtype", (Object)"Struct");
        body.set("must", (Object)this.isMust(tree));
        body.set("bodyparamdes", (Object)this.getDescription(tree));
        body.set("is_req_mul_value", (Object)"0");
        body.set("body_level", (Object)"2");
        body.set("example", (Object)"-");
        body.set("pid", (Object)dataId);
        long muliLangRowId = ID.genLongId();
        body.set("id", (Object)muliLangRowId);
        bodyEntryEntity.add((Object)body);
        List enabledLangList = InteServiceHelper.getEnabledLang();
        enabledLangList.forEach(enabledLang -> {
            DynamicObject sonBody = this.openApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
            sonBody.set("paramname", (Object)enabledLang.getNumber());
            sonBody.set("paramtype", (Object)DataType.STRING.type());
            sonBody.set("must", (Object)"0");
            sonBody.set("bodyparamdes", (Object)enabledLang.getName());
            sonBody.set("is_req_mul_value", (Object)"0");
            sonBody.set("body_level", (Object)"3");
            sonBody.set("example", (Object)"-");
            sonBody.set("pid", (Object)muliLangRowId);
            bodyEntryEntity.add((Object)sonBody);
        });
    }

    @Override
    public List<DynamicObject> queryOriginalEnableDataByEntityObjIds(List<String> entityObjIdList, List<Long> excludePkIdList) {
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)3);
        qFilterList.add(QFilterConstants.Q_ENABLE);
        QFilter entityObjIdFilter = new QFilter("entityobj.id", "in", entityObjIdList);
        if (CollectionUtils.isNotEmpty(excludePkIdList)) {
            QFilter excludeIdFilter = new QFilter("id", "not in", excludePkIdList);
            qFilterList.add(excludeIdFilter);
        }
        qFilterList.add(entityObjIdFilter);
        String selectProperties = String.join((CharSequence)",", "id", "entityobj.id");
        return this.iIntSourceEntityService.queryOriginalList(selectProperties, qFilterList.toArray(new QFilter[0]));
    }

    @Override
    public Map<Long, DynamicObject> queryByIds(List<Long> intSourceIdList) {
        QFilter intSourceIdFilter = new QFilter("id", "in", intSourceIdList);
        Object[] intSources = this.iIntSourceEntityService.query(SELECT_COMMON_FIELDS, new QFilter[]{intSourceIdFilter});
        HashMap intSourceIdIntSourceMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!ArrayUtils.isEmpty((Object[])intSources)) {
            intSourceIdIntSourceMap = Maps.newHashMapWithExpectedSize((int)intSources.length);
            for (Object intSource : intSources) {
                intSourceIdIntSourceMap.put(intSource.getLong("id"), intSource);
            }
        }
        return intSourceIdIntSourceMap;
    }

    @Override
    public List<Long> queryIdListByEntityNumbers(List<String> entityNumberList) {
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return new ArrayList<Long>();
        }
        QFilter entityObjFilter = new QFilter("entityobj", "in", entityNumberList);
        List dynamicObjectList = this.iIntSourceEntityService.queryOriginalList(SELECT_COMMON_FIELDS, new QFilter[]{entityObjFilter});
        if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
            return new ArrayList<Long>();
        }
        return dynamicObjectList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<Long>> queryByEntityNumbers(Collection<String> entityNumberList) {
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return new HashMap<String, List<Long>>(16);
        }
        QFilter entityObjFilter = new QFilter("entityobj", "in", entityNumberList);
        String selectFields = String.join((CharSequence)",", "id", "name", "number", "entityobj");
        List dynamicObjectList = this.iIntSourceEntityService.queryOriginalList(selectFields, new QFilter[]{entityObjFilter});
        if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
            return new HashMap<String, List<Long>>(16);
        }
        HashMap<String, List<Long>> entityNumberIntSourceIdsMap = new HashMap<String, List<Long>>(16);
        dynamicObjectList.forEach(dy -> {
            String entityObj = dy.getString("entityobj");
            List intSourceIds = entityNumberIntSourceIdsMap.getOrDefault(entityObj, new ArrayList());
            intSourceIds.add(dy.getLong("id"));
            entityNumberIntSourceIdsMap.put(entityObj, intSourceIds);
        });
        return entityNumberIntSourceIdsMap;
    }

    @Override
    public DynamicObject[] queryIntSourceByEntityNumbers(Collection<String> entityNumberList) {
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return null;
        }
        QFilter entityObjFilter = new QFilter("entityobj", "in", entityNumberList);
        String selectFields = String.join((CharSequence)",", "id", "name", "number", "entityobj", "midtableconfig", "ispublishapi");
        return this.iIntSourceEntityService.query(selectFields, new QFilter[]{entityObjFilter, QFilterConstants.Q_ENABLE});
    }

    @Override
    public DynamicObject[] queryIntSourceByMidEntityNumbers(Collection<String> midEntityNumberList) {
        if (CollectionUtils.isEmpty(midEntityNumberList)) {
            return null;
        }
        QFilter entityObjFilter = new QFilter("midtableconfig.midentitynumber", "in", midEntityNumberList);
        String selectFields = String.join((CharSequence)",", "id", "name", "number", "entityobj");
        return this.iIntSourceEntityService.query(selectFields, new QFilter[]{entityObjFilter, QFilterConstants.Q_ENABLE});
    }

    @Override
    public String getIntRelationNumber(boolean inOrOut, DynamicObject intSource, DynamicObject sourceSys) {
        String sourceSysNumber = sourceSys != null ? sourceSys.getString("number") : "";
        String intSourceNumber = intSource != null ? intSource.getString("number") : "";
        String number = inOrOut ? intSourceNumber + "\uff08" + sourceSysNumber + "\u2192" + "XHHR" + "\uff09" : intSourceNumber + "\uff08" + "XHHR" + "\u2192" + sourceSysNumber + "\uff09";
        return number;
    }

    @Override
    public String getIntRelationName(boolean inOrOut, DynamicObject intSource, DynamicObject sourceSys) {
        String sourceSysName = sourceSys != null ? sourceSys.getString("name") : "";
        String intSourceName = intSource != null ? intSource.getString("name") : "";
        String name = inOrOut ? intSourceName + "\uff08" + sourceSysName + "\u2192" + this.XH_HR_NAME + "\uff09" : intSourceName + "\uff08" + this.XH_HR_NAME + "\u2192" + sourceSysName + "\uff09";
        return name;
    }

    @Override
    public void createIntSource(DynamicObject[] midConfigDyns) {
        List<DynamicObject> midConfigDynList = this.removeExistData(midConfigDyns);
        if (CollectionUtils.isNotEmpty(midConfigDynList)) {
            DynamicObject[] intSourceDyns = new DynamicObject[midConfigDynList.size()];
            AtomicInteger index = new AtomicInteger();
            midConfigDynList.forEach(midConfigDyn -> {
                intSourceDyns[index.getAndIncrement()] = this.buildIntSourceByMidConfig((DynamicObject)midConfigDyn);
            });
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrdi_intsource", (DynamicObject[])intSourceDyns, (OperateOption)OperateOption.create());
            LOG.info("createIntSource result:{}", (Object)operationResult);
        }
    }

    private List<DynamicObject> removeExistData(DynamicObject[] midConfigDyns) {
        if (midConfigDyns == null) {
            return new ArrayList<DynamicObject>(0);
        }
        LinkedHashMap entityIdDynMap = Maps.newLinkedHashMapWithExpectedSize((int)midConfigDyns.length);
        Arrays.stream(midConfigDyns).forEach(midConfigDyn -> entityIdDynMap.put(midConfigDyn.getString("entityobj.id"), midConfigDyn));
        QFilter entityFilter = new QFilter("entityobj.id", "in", entityIdDynMap.keySet());
        List dbIntSourceList = this.iIntSourceEntityService.queryOriginalList("id,entityobj", new QFilter[]{entityFilter, QFilterConstants.Q_ENABLE});
        dbIntSourceList.forEach(dbIntSource -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)entityIdDynMap.remove(dbIntSource.getString("entityobj"));
        });
        return new ArrayList<DynamicObject>(entityIdDynMap.values());
    }

    private DynamicObject buildIntSourceByMidConfig(DynamicObject midConfigDyn) {
        DynamicObject intSourceDyn = this.iIntSourceEntityService.generateEmptyDynamicObject();
        intSourceDyn.set("id", (Object)midConfigDyn.getLong("id"));
        intSourceDyn.set("number", midConfigDyn.get("number"));
        intSourceDyn.set("name", midConfigDyn.get("name"));
        intSourceDyn.set("enable", midConfigDyn.get("enable"));
        intSourceDyn.set("status", (Object)"C");
        intSourceDyn.set("issyspreset", (Object)"1");
        intSourceDyn.set("entityobj", midConfigDyn.get("entityobj"));
        intSourceDyn.set("midtableconfig", (Object)midConfigDyn);
        intSourceDyn.set("bizapp", midConfigDyn.get("bizapp"));
        return intSourceDyn;
    }

    @Override
    public Map<String, DynamicObject> queryIntSourceByNumberList(Collection<String> intSourceNumberList) {
        if (CollectionUtils.isEmpty(intSourceNumberList)) {
            return new HashMap<String, DynamicObject>(16);
        }
        QFilter entityObjFilter = new QFilter("number", "in", intSourceNumberList);
        String selectFields = String.join((CharSequence)",", "id", "name", "number", "entityobj");
        DynamicObject[] dynamicObjects = this.iIntSourceEntityService.query(selectFields, new QFilter[]{entityObjFilter, QFilterConstants.Q_ENABLE});
        return Stream.of(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (it1, it2) -> it1));
    }

    @Override
    public void deleteByEntity(List<String> entityList) {
        QFilter entityFilter = new QFilter("entityobj", "in", entityList);
        this.iIntSourceEntityService.deleteByFilter(new QFilter[]{entityFilter});
    }

    @Override
    public Map<Object, String> afterTransferConfPost(Set<Long> pkIdSet) {
        String selectFields = String.join((CharSequence)",", "id", "name", "number", "entityobj", "midtableconfig", "ispublishapi");
        DynamicObject[] intSourceDyns = this.iIntSourceEntityService.query(selectFields, new QFilter[]{new QFilter("id", "in", pkIdSet)});
        HashSet midTableIdSet = Sets.newHashSetWithExpectedSize((int)intSourceDyns.length);
        for (DynamicObject intSource : intSourceDyns) {
            midTableIdSet.add(intSource.getLong("midtableconfig.id"));
        }
        Map<Object, String> errorMsgMap = this.generate(midTableIdSet);
        this.publishInOpenApiDyn(intSourceDyns);
        return errorMsgMap;
    }

    private Map<Object, String> generate(Set<Long> pkIdSet) {
        Map<Long, MetadataGenParam> paramMap = this.midTableConfigDomainService.batchBuildGenParam(pkIdSet);
        HashMap<Object, String> errorMsgMap = new HashMap<Object, String>(16);
        for (Map.Entry<Long, MetadataGenParam> entry : paramMap.entrySet()) {
            entry.getValue().setMetadataOperateTypeEnum(MetadataOperateTypeEnum.PAGE_SAVE);
            MetadataGenResult result = this.dynamicMetadataApplicationService.generate(entry.getValue());
            if (result.isSuccess()) continue;
            errorMsgMap.put(entry.getKey(), String.join((CharSequence)",", result.getMsgList()));
        }
        return errorMsgMap;
    }
}

