/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.intgovern.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntSourceSysEntityService;

public class IntSourceSysDomainServiceImpl
implements IIntSourceSysDomainService {
    private static final Log LOG = LogFactory.getLog(IntSourceSysDomainServiceImpl.class);
    private static final String SELECT_COMMON_FIELDS = String.join((CharSequence)",", "id", "name", "number");
    private final IIntSourceSysEntityService iIntSourceSysEntityService = ServiceFactory.getService(IIntSourceSysEntityService.class);

    @Override
    public DynamicObject queryById(Long id) {
        return this.iIntSourceSysEntityService.queryOne(SELECT_COMMON_FIELDS, id);
    }

    @Override
    public DynamicObject queryByNumber(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.or(new QFilter("name", "=", (Object)number));
        return this.iIntSourceSysEntityService.queryOne(SELECT_COMMON_FIELDS, new QFilter[]{filter, QFilterConstants.Q_ENABLE});
    }

    @Override
    public Map<String, DynamicObject> querySourceSysByNumberList(Collection<String> sourceSysNumberList) {
        if (CollectionUtils.isEmpty(sourceSysNumberList)) {
            return new HashMap<String, DynamicObject>(16);
        }
        QFilter numberFilter = new QFilter("number", "in", sourceSysNumberList);
        Object[] sourceSystems = this.iIntSourceSysEntityService.query(SELECT_COMMON_FIELDS, new QFilter[]{QFilterConstants.Q_ENABLE, numberFilter});
        if (ArrayUtils.isNotEmpty((Object[])sourceSystems)) {
            return Stream.of(sourceSystems).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity()));
        }
        return new HashMap<String, DynamicObject>(16);
    }

    @Override
    public Map<String, DynamicObject> querySourceSysByHRICNumber(Map<String, DynamicObject> initSourceSysMap) {
        if (CollectionUtils.isEmpty(initSourceSysMap)) {
            return new HashMap<String, DynamicObject>(16);
        }
        Set<String> initSourceSysNumbers = initSourceSysMap.keySet();
        Map<String, DynamicObject> sourSysMap = this.querySourceSysByNumberList(initSourceSysNumbers);
        ArrayList needCreateSourceSysList = Lists.newArrayListWithCapacity((int)16);
        initSourceSysMap.forEach((initSourceSysNumber, initDynamicObject) -> {
            if (!sourSysMap.containsKey(initSourceSysNumber)) {
                DynamicObject dynamicObject = this.iIntSourceSysEntityService.generateEmptyDynamicObject();
                dynamicObject.set("id", (Object)ID.genLongId());
                dynamicObject.set("number", (Object)initDynamicObject.getString("number"));
                dynamicObject.set("name", (Object)initDynamicObject.getString("name"));
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("enable", (Object)"1");
                dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                sourSysMap.put((String)initSourceSysNumber, dynamicObject);
                needCreateSourceSysList.add(dynamicObject);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)needCreateSourceSysList)) {
            this.iIntSourceSysEntityService.save(needCreateSourceSysList.toArray(new DynamicObject[0]));
        }
        return sourSysMap;
    }
}

