/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.middle.bo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.NodeParam;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.MetadataGenParamUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.domain.middle.bo.MidTableConfigEntryBo;
import kd.hdtc.hrdi.business.domain.middle.bo.MidTableConfigEntryLineBo;
import kd.hr.hbp.common.util.HRStringUtils;

public class MidTableConfigGenParamBo {
    private static final Log LOG = LogFactory.getLog(MidTableConfigGenParamBo.class);
    private final String RES_MID_TABLE = ResManager.loadKDString((String)"\u96c6\u6210\u4e2d\u95f4\u8868", (String)"MidTableConfigGenParamBo_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private DynamicObject configDy;
    private DynamicObjectCollection treeEntryCollection;
    private Map<Long, String> idEntityNumberMap;
    private MetadataGenParam metadataGenParam;
    private List<MainEntityType> entityTypeList;
    private List<EntityItem<?>> rangeFieldItemList;
    private MidTableConfigEntryBo midTableConfigEntryBo;
    private String bizObjectNumber;
    private final Map<String, Set<String>> mulBaseDataFieldMap = new HashMap<String, Set<String>>(16);

    public MidTableConfigGenParamBo(DynamicObject configDy) {
        this.configDy = configDy;
        this.treeEntryCollection = configDy.getDynamicObjectCollection("treeentryentity");
        this.metadataGenParam = MetadataGenParamUtils.getDefaultParam();
        this.initEntityMap();
        this.initMulBaseDataPropHandle();
    }

    private void initMulBaseDataPropHandle() {
        List mainEntityTypeList = MetadataUtils.getMainEntityTypes((String)this.configDy.getString("entityobj.id"));
        mainEntityTypeList.forEach(entityType -> entityType.getProperties().forEach(prop -> {
            this.initMulBaseDataPropMap((IDataEntityProperty)prop, entityType.getName());
            if (prop instanceof EntryProp) {
                ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties().forEach(entryProp -> {
                    this.initMulBaseDataPropMap((IDataEntityProperty)entryProp, entityType.getName());
                    if (entryProp instanceof SubEntryProp) {
                        ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties().forEach(subEntryProp -> this.initMulBaseDataPropMap((IDataEntityProperty)subEntryProp, entityType.getName()));
                    }
                });
            }
        }));
    }

    private void initMulBaseDataPropMap(IDataEntityProperty prop, String entityNumber) {
        if (prop instanceof MulBasedataProp) {
            Set mulBaseDataFieldSet = this.mulBaseDataFieldMap.getOrDefault(entityNumber, new HashSet(16));
            mulBaseDataFieldSet.add(prop.getName());
            this.mulBaseDataFieldMap.put(entityNumber, mulBaseDataFieldSet);
        }
    }

    public MetadataGenParam build() {
        this.bizObjectNumber = this.configDy.getDynamicObject("entityobj").getString("number");
        this.rangeFieldItemList = MetadataUtils.getRangeFieldItems((String)this.bizObjectNumber);
        this.entityTypeList = kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils.getEntityTypeList((String)this.bizObjectNumber);
        this.fillBaseParam();
        this.midTableConfigEntryBo = new MidTableConfigEntryBo(this.treeEntryCollection);
        this.metadataGenParam.setFieldParamList(this.buildFieldParamList());
        return this.metadataGenParam;
    }

    @Deprecated
    public void setRangeFieldItemList(List<EntityItem<?>> rangeFieldItemList) {
        this.rangeFieldItemList = rangeFieldItemList;
    }

    private void fillBaseParam() {
        BaseParam baseParam = this.metadataGenParam.getBaseParam();
        baseParam.setParentId("35A6C2WXTWNH");
        baseParam.setBizUnitId("39HSGPRISZ8N");
        baseParam.setType(MetadataGenTypeEnum.MID_TABLE);
        DynamicObject dy = this.configDy.getDynamicObject("entityobj");
        baseParam.setRefEntityNumber(this.bizObjectNumber);
        baseParam.setModelType("BaseFormModel");
        baseParam.setMetadataName(dy.getString("name") + this.RES_MID_TABLE);
        baseParam.setMetadataNumber(this.configDy.getString("midentitynumber"));
    }

    private List<FieldParam> buildFieldParamList() {
        List<Object> fieldParamList = Lists.newArrayListWithExpectedSize((int)this.treeEntryCollection.size());
        for (DynamicObject entry : this.treeEntryCollection) {
            if (!entry.getBoolean("isintegrationfield")) continue;
            String entityNumber = entry.getString("entitynumber");
            DynamicProperty property = this.getProperty(entityNumber, this.idEntityNumberMap.get(entry.getLong("id")));
            if (this.checkIgnoreEntityNumber(entityNumber) || !this.accessProp(property)) continue;
            fieldParamList.add(this.buildFieldParam(entry));
        }
        if (CollectionUtils.isNotEmpty(this.rangeFieldItemList)) {
            fieldParamList = this.dealRangeField((List<FieldParam>)fieldParamList);
        }
        return fieldParamList;
    }

    private List<FieldParam> dealRangeField(List<FieldParam> fieldParamList) {
        Map<String, FieldParam> numberFieldMap = fieldParamList.stream().collect(Collectors.toMap(NodeParam::getNumber, fieldParam -> fieldParam));
        ArrayList<FieldParam> newFieldParamList = new ArrayList<FieldParam>(fieldParamList.size());
        this.rangeFieldItemList.forEach(item -> {
            DateRangeField field;
            String startDateFieldKey = null;
            String endDateFieldKey = null;
            if (item instanceof DateRangeField) {
                field = (DateRangeField)item;
                startDateFieldKey = field.getStartDateFieldKey();
                endDateFieldKey = field.getEndDateFieldKey();
            } else if (item instanceof TimeRangeField) {
                field = (TimeRangeField)item;
                startDateFieldKey = field.getStartDateFieldKey();
                endDateFieldKey = field.getEndDateFieldKey();
            }
            if (numberFieldMap.containsKey(startDateFieldKey) || numberFieldMap.containsKey(endDateFieldKey)) {
                FieldParam fieldParam = (FieldParam)numberFieldMap.remove(startDateFieldKey);
                FieldParam newFieldParam = this.buildNewFieldParam(fieldParam, (EntityItem<?>)item);
                newFieldParam.setFieldRuleMap(this.buildFieldRuleMap((EntityItem<?>)item));
                numberFieldMap.remove(endDateFieldKey);
                newFieldParamList.add(newFieldParam);
            }
        });
        this.resetNumberAlias(newFieldParamList);
        newFieldParamList.addAll(numberFieldMap.values());
        return newFieldParamList;
    }

    private Map<String, Object> buildFieldRuleMap(EntityItem<?> item) {
        DateRangeField field;
        String startDateFieldKey = null;
        String startDateFieldName = null;
        String endDateFieldKey = null;
        String endDateFieldName = null;
        if (item instanceof DateRangeField) {
            field = (DateRangeField)item;
            startDateFieldKey = field.getStartDateFieldKey();
            startDateFieldName = field.getStartDateFieldName();
            endDateFieldKey = field.getEndDateFieldKey();
            endDateFieldName = field.getEndDateFieldName();
        } else if (item instanceof TimeRangeField) {
            field = (TimeRangeField)item;
            startDateFieldKey = field.getStartDateFieldKey();
            startDateFieldName = field.getStartDateFieldName();
            endDateFieldKey = field.getEndDateFieldKey();
            endDateFieldName = field.getEndDateFieldName();
        }
        HashMap<String, Object> fieldRuleMap = new HashMap<String, Object>(16);
        fieldRuleMap.put("StartDateFieldKey", startDateFieldKey);
        fieldRuleMap.put("StartDateFieldName", startDateFieldName);
        fieldRuleMap.put("EndDateFieldKey", endDateFieldKey);
        fieldRuleMap.put("EndDateFieldName", endDateFieldName);
        return fieldRuleMap;
    }

    private FieldParam buildNewFieldParam(FieldParam fieldParam, EntityItem<?> item) {
        FieldParam newFieldParam = new FieldParam();
        this.copyFieldParam(fieldParam, newFieldParam);
        newFieldParam.setNumber(item.getKey());
        newFieldParam.setName(item.getName().getLocaleValue());
        newFieldParam.setBasedataNumber(fieldParam.getBasedataNumber());
        newFieldParam.setOldNumber(item.getKey());
        return newFieldParam;
    }

    private void resetNumberAlias(List<FieldParam> newFieldParamList) {
        HashMap map = new HashMap(16);
        newFieldParamList.forEach(item -> {
            String number = item.getNumber();
            Integer index = (Integer)map.get(number);
            if (index != null) {
                index = index + 1;
                map.put(number, index);
                item.setNumber(number + index);
            } else {
                map.put(number, 0);
            }
        });
    }

    private void copyFieldParam(FieldParam from, FieldParam to) {
        to.setBasedataNumber(from.getBasedataNumber());
        to.setContainerNumber(from.getContainerNumber());
        to.setBasedata(from.isBasedata());
        to.setBasedataPropNumber(from.getBasedataPropNumber());
    }

    private FieldParam buildFieldParam(DynamicObject entry) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setNumber(entry.getString("numberalias"));
        fieldParam.setName(this.getNameString(entry));
        fieldParam.setOldNumber(entry.getString("entitynumber"));
        fieldParam.setBasedata(entry.getBoolean("isbasedata"));
        fieldParam.setBasedataPropNumber(entry.getString("referenceprop"));
        String entityNumber = Optional.ofNullable(this.midTableConfigEntryBo.getBelongEntityLine(entry.getLong("id"))).map(MidTableConfigEntryLineBo::getEntityNumber).orElse(null);
        fieldParam.setBasedataNumber(entityNumber);
        fieldParam.setContainerNumber("businessap");
        if (entry.getBoolean("isbasedata") && CollectionUtils.isNotEmpty((Collection)this.mulBaseDataFieldMap.get(entityNumber)) && this.mulBaseDataFieldMap.get(entityNumber).contains(entry.getString("entitynumber"))) {
            fieldParam.setType("MulBasedataField");
        }
        return fieldParam;
    }

    private String getNameString(DynamicObject entry) {
        String name = entry.getString("entityname");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return name.replaceAll("\\*", "");
        }
        return "";
    }

    private boolean accessProp(DynamicProperty prop) {
        if (prop == null) {
            return false;
        }
        return !this.checkNotAccessProp(prop);
    }

    private boolean checkNotAccessProp(DynamicProperty prop) {
        return this.getNotAccessProps().stream().anyMatch(it -> it.isInstance(prop));
    }

    private List<Class> getNotAccessProps() {
        return Arrays.asList(EntryProp.class, JoinProperty.class);
    }

    private boolean checkIgnoreEntityNumber(String entityNumber) {
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return true;
        }
        return HRStringUtils.equals((String)entityNumber, (String)"id");
    }

    private DynamicProperty getProperty(String entityNumber, String ownEntityNumber) {
        for (MainEntityType entityType : this.entityTypeList) {
            DynamicProperty property;
            if (!HRStringUtils.equals((String)entityType.getName(), (String)ownEntityNumber) || (property = this.findProperty(entityNumber, entityType)) == null) continue;
            return property;
        }
        return null;
    }

    private DynamicProperty findProperty(String entityNumber, MainEntityType entityType) {
        for (Map.Entry subEntityTypeEntry : entityType.getAllEntities().entrySet()) {
            DynamicProperty property = ((EntityType)subEntityTypeEntry.getValue()).getProperty(entityNumber);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    private void initEntityMap() {
        this.idEntityNumberMap = Maps.newHashMapWithExpectedSize((int)this.treeEntryCollection.size());
        Map<Long, String> pidMap = this.treeEntryCollection.stream().filter(dy -> dy.getLong("pid") == 0L).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("entitynumber")));
        Map<Long, Long> idPidMap = this.treeEntryCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("pid"), (o1, o2) -> o1));
        for (int row = 0; row < this.treeEntryCollection.size(); ++row) {
            DynamicObject rowDy = (DynamicObject)this.treeEntryCollection.get(row);
            this.idEntityNumberMap.put(rowDy.getLong("id"), MidTableConfigGenParamBo.findEntityNumber(rowDy.getLong("pid"), idPidMap, pidMap));
        }
    }

    private static String findEntityNumber(long pid, Map<Long, Long> entityMap, Map<Long, String> pidMap) {
        if (entityMap.get(pid) == null || entityMap.get(pid) == 0L) {
            return pidMap.get(pid);
        }
        return MidTableConfigGenParamBo.findEntityNumber(entityMap.get(pid), entityMap, pidMap);
    }
}

