/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.middle.bo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;

public class MidTableDataVersionValidateBo {
    private final IBaseCommonDomainService commonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    private final IHRDIBaseConfigDomainService configDomainService = ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private boolean validate = false;
    private final List<DynamicObject> midTableDataList;
    private Map<String, DynamicObject> lastDataMap;

    public MidTableDataVersionValidateBo(List<DynamicObject> midTableDataList) {
        this.midTableDataList = midTableDataList;
        this.init();
    }

    private void init() {
        this.validate = this.isValidate();
        if (!this.validate) {
            return;
        }
        this.initLastDataMap();
    }

    private void initLastDataMap() {
        DynamicObject[] dbMidTableDatas = this.queryMidTableData();
        this.lastDataMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dbMidTableData : dbMidTableDatas) {
            String key = this.getKey(dbMidTableData);
            if (this.lastDataMap.containsKey(key)) continue;
            this.lastDataMap.put(key, dbMidTableData);
        }
    }

    private DynamicObject[] queryMidTableData() {
        String midTableNumber = this.midTableDataList.get(0).getDataEntityType().getName();
        Set sourceSysKeySet = this.midTableDataList.stream().map(dyn -> dyn.getString("hrdisourcesyskey")).collect(Collectors.toSet());
        QFilter filter = new QFilter("hrdisourcesyskey", "in", sourceSysKeySet);
        QFilter statusFilter = new QFilter("hrdiintstatus", "=", (Object)"2");
        return this.commonDomainService.queryByFilters(midTableNumber, "hrdisourcesys,hrdisourcesyskey,hrdimodifydate", new QFilter[]{filter, statusFilter}, "hrdimodifydate desc");
    }

    private String getKey(DynamicObject dyn) {
        return dyn.getString("hrdisourcesyskey") + dyn.getString("hrdisourcesys");
    }

    private boolean isValidate() {
        String baseParam = this.configDomainService.queryBaseConfigValueByNumber("is.save.midtable.data");
        return "1".equals(baseParam);
    }

    public boolean isLastVersion(DynamicObject midTableDyn) {
        if (!this.validate) {
            return true;
        }
        String key = this.getKey(midTableDyn);
        DynamicObject lastVersionDyn = this.lastDataMap.get(key);
        return lastVersionDyn == null || lastVersionDyn.getDate("hrdimodifydate").before(midTableDyn.getDate("hrdimodifydate"));
    }

    public Map<DynamicObject, Boolean> getValidateResult() {
        HashMap<DynamicObject, Boolean> resultMap = new HashMap<DynamicObject, Boolean>(16);
        this.midTableDataList.forEach(dyn -> resultMap.put((DynamicObject)dyn, this.isLastVersion((DynamicObject)dyn)));
        return resultMap;
    }
}

