/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.middle.entity.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;

public class MidTableConfigEntityServiceImpl
extends AbstractBaseEntityService
implements IMidTableConfigEntityService {
    public MidTableConfigEntityServiceImpl() {
        super("hrdi_midtableconfig");
    }

    @Override
    public List<DynamicObject> queryMidTableByEntityIds(String queryFields, Set<String> entityIdSet) {
        QFilter entityFilter = new QFilter("entityobj", "in", entityIdSet);
        return this.queryOriginalList(queryFields, new QFilter[]{QFilterConstants.Q_ENABLE, entityFilter});
    }

    @Override
    public Map<String, DynamicObject> queryMidTablesByEntityIds(String queryFields, Set<String> entityIdSet) {
        if (CollectionUtils.isEmpty(entityIdSet) || StringUtils.isEmpty((String)queryFields)) {
            return new HashMap<String, DynamicObject>(16);
        }
        QFilter entityFilter = new QFilter("entityobj", "in", entityIdSet);
        Object[] dynamicObjects = this.hrBaseServiceHelper.query(queryFields, new QFilter[]{QFilterConstants.Q_ENABLE, entityFilter});
        HashMap entityIdObjMap = Maps.newHashMapWithExpectedSize((int)entityIdSet.size());
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            Stream.of(dynamicObjects).forEach(dy -> entityIdObjMap.put(dy.getString("entityobj.id"), dy));
        }
        return entityIdObjMap;
    }

    @Override
    public List<DynamicObject> queryPresetMidTableByEntityIds(String queryFields, Set<String> entityIdSet) {
        QFilter entityFilter = new QFilter("entityobj", "in", entityIdSet);
        return this.queryOriginalList(queryFields, new QFilter[]{QFilterConstants.Q_ENABLE, QFilterConstants.Q_PRESET, entityFilter});
    }

    @Override
    public List<DynamicObject> queryMidTableGenConfig(Set<Long> pkSet) {
        Map configMap = this.getMapFromCache("entityobj,midentitynumber,treeentryentity.entityname,treeentryentity.entitynumber,treeentryentity.referenceprop,treeentryentity.isintegrationfield,treeentryentity.numberalias,treeentryentity.istablehead,treeentryentity.pid,treeentryentity.isbasedata", new QFilter("id", "in", pkSet).toArray());
        if (CollectionUtils.isEmpty((Map)configMap)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return configMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public String queryEntityIdByMidTableNumber(String midTableNumber) {
        QFilter midEntityNumberFilter = this.buildMidTableNumberQFilter(midTableNumber);
        List dynamicObjectList = this.queryOriginalList("entityobj", new QFilter[]{QFilterConstants.Q_ENABLE, midEntityNumberFilter});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectList)) {
            return ((DynamicObject)dynamicObjectList.get(0)).getString("entityobj");
        }
        return "";
    }

    @Override
    public String queryMidTableNumberByEntityObjNumber(String entityObjNumber) {
        QFilter entityObjFilter = new QFilter("entityobj.number", "=", (Object)entityObjNumber);
        List dynamicObjectList = this.queryOriginalList("midentitynumber", new QFilter[]{QFilterConstants.Q_ENABLE, entityObjFilter});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectList)) {
            return ((DynamicObject)dynamicObjectList.get(0)).getString("midentitynumber");
        }
        return "";
    }

    private QFilter buildMidTableNumberQFilter(String midTableNumber) {
        return new QFilter("midentitynumber", "=", (Object)midTableNumber);
    }

    @Override
    public DynamicObject loadFromCache(String midTableNumber) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)this.entityNumber, (String)(DynamicObjectUtils.getFieldByPage((String)this.entityNumber) + ",pid"), (QFilter[])this.buildMidTableNumberQFilter(midTableNumber).toArray());
    }
}

