/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.middle.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.blacklist.IBizFieldBlackListDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.bo.MidTableConfigBo;
import kd.hdtc.hrdi.business.domain.middle.bo.MidTableConfigGenParamBo;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigTplEntityService;
import kd.hdtc.hrdi.common.middle.constants.MidTableConfigConstants;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hdtc.hrdi.common.pojo.MidTableConfigField;
import org.apache.commons.lang3.ObjectUtils;

public class MidTableConfigDomainServiceImpl
implements IMidTableConfigDomainService {
    private final IMidTableConfigTplEntityService midTableConfigTplEntityService = ServiceFactory.getService(IMidTableConfigTplEntityService.class);
    private final IMidTableConfigEntityService midTableConfigEntityService = ServiceFactory.getService(IMidTableConfigEntityService.class);
    private final IBizFieldBlackListDomainService blackListDomainService = ServiceFactory.getService(IBizFieldBlackListDomainService.class);
    private final String RES_BILLHEAD_NAME = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"MidTableConfigServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final String RES_ID_NAME = ResManager.loadKDString((String)"\u5185\u7801", (String)"MidTableConfigServiceImpl_1", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final String RES_PARENT_ID_NAME = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"MidTableConfigServiceImpl_2", (String)"hdtc-hrdi-business", (Object[])new Object[0]);

    @Override
    public String getMidTableName(String entityName) {
        String tableName = Optional.ofNullable(entityName).orElse("");
        if (StringUtils.isNotEmpty((String)tableName)) {
            if (!ISVServiceHelper.isKingdeeISV()) {
                tableName = tableName.substring(tableName.indexOf(95) + 1);
            }
            tableName = tableName.substring(tableName.indexOf(95) + 1);
        }
        tableName = (tableName = "hrdi_0" + tableName).length() > MidTableConfigConstants.TABLE_NAME_MAX_LENGTH ? tableName.substring(0, MidTableConfigConstants.TABLE_NAME_MAX_LENGTH) : tableName;
        return tableName;
    }

    @Override
    public List<DynamicObject> buildEntryByOldValue(DynamicObjectCollection oldValues, MidTableConfigBo bo) {
        this.setPropertyValueByOldValue(oldValues, bo.getDynamicObjectList());
        return bo.getDynamicObjectList();
    }

    @Override
    public DynamicObject[] synPresetDataFromMidTableTpl() {
        DynamicObject[] midTableTpls = this.midTableConfigTplEntityService.queryMidTableTplPresetData();
        Map<String, DynamicObject> entityIdDynMap = Arrays.stream(midTableTpls).collect(Collectors.toMap(midTableTpl -> midTableTpl.getString("entityobj.id"), midTableTpl -> midTableTpl));
        List<DynamicObject> midTableDynList = this.midTableConfigEntityService.queryMidTableByEntityIds("entityobj", entityIdDynMap.keySet());
        midTableDynList.forEach(midTableDyn -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)entityIdDynMap.remove(midTableDyn.getString("entityobj"));
        });
        if (!CollectionUtils.isEmpty(entityIdDynMap)) {
            DynamicObject[] midTables = new DynamicObject[entityIdDynMap.size()];
            AtomicInteger index = new AtomicInteger();
            entityIdDynMap.forEach((key, midTableTplDyn) -> {
                DynamicObject midTableDyn = this.midTableConfigEntityService.generateEmptyDynamicObject();
                DynamicObjectUtils.copy((DynamicObject)midTableTplDyn, (DynamicObject)midTableDyn);
                this.dealEntryPid((DynamicObject)midTableTplDyn, midTableDyn);
                midTableDyn.set("id", midTableTplDyn.get("id"));
                midTables[index.getAndIncrement()] = midTableDyn;
            });
            this.midTableConfigEntityService.save(midTables);
            return midTables;
        }
        return null;
    }

    private void dealEntryPid(DynamicObject midTableTplDyn, DynamicObject midTableDyn) {
        DynamicObjectCollection treeEntryTplCollection = midTableTplDyn.getDynamicObjectCollection("treeentryentity");
        DynamicObjectCollection treeEntryCollection = midTableDyn.getDynamicObjectCollection("treeentryentity");
        int index = 0;
        for (DynamicObject treeEntry : treeEntryCollection) {
            treeEntry.set("id", ((DynamicObject)treeEntryTplCollection.get(index++)).get("id"));
        }
    }

    @Override
    public List<String> getBizAppIds() {
        List midTableConfigList = this.midTableConfigEntityService.queryOriginalList("bizapp", null);
        ArrayList<String> appIdList = new ArrayList<String>(midTableConfigList.size());
        midTableConfigList.forEach(midTable -> appIdList.add(midTable.getString("bizapp")));
        return appIdList;
    }

    @Override
    public Map<Long, MetadataGenParam> batchBuildGenParam(Set<Long> pkSet) {
        if (CollectionUtils.isEmpty(pkSet)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        List<DynamicObject> configDyList = this.midTableConfigEntityService.queryMidTableGenConfig(pkSet);
        HashMap configMap = Maps.newHashMapWithExpectedSize((int)pkSet.size());
        for (DynamicObject configDy : configDyList) {
            configMap.put(configDy.getLong("id"), new MidTableConfigGenParamBo(configDy).build());
        }
        return configMap;
    }

    private void setPropertyValueByOldValue(DynamicObjectCollection oldDynamicObjectCollection, List<DynamicObject> newDynamicList) {
        Map<String, DynamicObject> oldDynMap = oldDynamicObjectCollection.stream().filter(dyc -> !dyc.getBoolean("istablehead")).collect(Collectors.toMap(dyc -> dyc.getString("numberalias"), dyc -> dyc, (k1, k2) -> k1));
        newDynamicList.forEach(dyn -> {
            if (oldDynMap.containsKey(dyn.getString("numberalias"))) {
                DynamicObject oldEntryDyn = (DynamicObject)oldDynMap.get(dyn.getString("numberalias"));
                this.copy(oldEntryDyn, (DynamicObject)dyn);
                if (dyn.getBoolean("isbasedata") && oldEntryDyn.getBoolean("isbasedata")) {
                    dyn.set("referenceprop", (Object)oldEntryDyn.getString("referenceprop"));
                    dyn.set("isvalidateexist", (Object)oldEntryDyn.getString("isvalidateexist"));
                }
            }
        });
    }

    private void copy(DynamicObject fromObj, DynamicObject toObj) {
        if (fromObj != null && toObj != null) {
            toObj.set("isintegrationfield", fromObj.get("isintegrationfield"));
            toObj.set("ismustinput", fromObj.get("ismustinput"));
        }
    }

    @Override
    public void buildFieldsTreeByEntity(MidTableConfigBo bo) {
        List entityTypeList = MetadataUtils.getMainEntityTypes((String)bo.getBizEntity());
        if (CollectionUtils.isEmpty((Collection)entityTypeList)) {
            return;
        }
        bo.setBizFieldBlackListMap(this.getBizFieldBlackList(entityTypeList));
        bo.setEntityIndexMap(entityTypeList);
        entityTypeList.forEach(mainEntityType -> this.buildEntityFieldsTree((MainEntityType)mainEntityType, bo));
    }

    private Map<String, Set<String>> getBizFieldBlackList(List<MainEntityType> entityTypes) {
        List<String> entityList = entityTypes.stream().map(DynamicObjectType::getName).collect(Collectors.toList());
        return this.blackListDomainService.getBizFieldBlackLit(entityList);
    }

    private void buildEntityFieldsTree(MainEntityType mainType, MidTableConfigBo bo) {
        int size = bo.getDynamicObjectListSize();
        Integer[] pRow = new Integer[]{size - 1 <= 0 ? 0 : size, null};
        bo.setEntityIndexRange(mainType.getName(), pRow);
        this.buildEntityRow(mainType, bo);
        this.buildSubEntityRow(mainType, bo, pRow);
    }

    private void buildEntityRow(MainEntityType mainType, MidTableConfigBo bo) {
        DynamicObject dyn = new DynamicObject(bo.getDynamicObjectType());
        long entryId = DBServiceHelper.genLongIds((String)bo.getPageEntry(), (int)1)[0];
        String entityNumber = mainType.getName();
        dyn.set("id", (Object)entryId);
        this.fillPartialFieldsInfo(mainType.getDisplayName(), entityNumber, dyn);
        bo.addDynamicObject(dyn);
    }

    private void buildSubEntityTypeRow(Long parentId, MidTableConfigBo bo, LocaleString entityName, String entityNumber) {
        DynamicObject subDyn = new DynamicObject(bo.getDynamicObjectType());
        subDyn.set("id", (Object)DBServiceHelper.genLongIds((String)bo.getPageEntry(), (int)1)[0]);
        subDyn.set("pid", (Object)parentId);
        this.fillPartialFieldsInfo(entityName, entityNumber, subDyn);
        bo.addDynamicObject(subDyn);
    }

    private void buildSubEntityRow(MainEntityType mainType, MidTableConfigBo bo, Integer[] pRow) {
        List newItemList = MetadataUtils.getEntityFieldItems((String)mainType.getName());
        if (CollectionUtils.isEmpty((Collection)newItemList)) {
            return;
        }
        Map<String, EntityItem<?>> itemKeyItemMap = this.buildItemKeyItemMap(newItemList);
        List apList = MetadataUtils.getFormMetadata((String)mainType.getName());
        boolean isAllCheck = true;
        int row = -1;
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (entityType instanceof LinkEntryType) continue;
            boolean queryEntity = entityType instanceof QueryEntityType;
            IDataEntityType parentType = entityType.getParent();
            boolean hasField = true;
            if (entityType instanceof EntryType) {
                Set<String> bizFieldBlackListSet = bo.getBizFieldBlackList(mainType.getName());
                HashSet entryFieldSet = new HashSet(16);
                ((EntryType)entityType).getFields().forEach((field, prop) -> {
                    if (!bizFieldBlackListSet.contains(field)) {
                        entryFieldSet.add(field);
                    }
                });
                hasField = CollectionUtils.isNotEmpty(entryFieldSet);
            }
            if (!hasField) continue;
            pRow = bo.getEntityIndexRangeMap().get(parentType != null ? parentType.getName() : entityType.getName());
            if (row < 0) {
                DynamicObject parentDyn = bo.getDynamicObjectList().get(pRow[0]);
                Long parentId = parentDyn.getLong("id");
                if (entityType.getParent() == null) {
                    this.buildSubEntityTypeRow(parentId, bo, new LocaleString(this.RES_BILLHEAD_NAME), "billhead");
                } else {
                    this.buildSubEntityTypeRow(parentId, bo, entityType.getDisplayName(), entityType.getName());
                }
                row = bo.getDynamicObjectListSize() - 1;
            }
            List<IDataEntityProperty> properties = entityType.getFields().values().stream().filter(prop -> queryEntity && !(prop instanceof JoinProperty) || this.isProperty(itemKeyItemMap, (IDataEntityProperty)prop, bo)).collect(Collectors.toList());
            this.getSortProperties(properties, apList, entityType, bo);
            if (properties.isEmpty()) continue;
            isAllCheck = this.buildEntryFieldTreeRow(row, mainType.getName(), (String)entry.getKey(), properties, bo);
            row = -1;
        }
        if (row > 0) {
            bo.getDynamicObjectList().remove(row);
        }
        if (isAllCheck) {
            bo.getDynamicObjectList().get(pRow[0]).set("ismustinput", (Object)Boolean.TRUE);
            bo.getDynamicObjectList().get(pRow[0]).set("isintegrationfield", (Object)Boolean.TRUE);
        }
    }

    private Map<String, EntityItem<?>> buildItemKeyItemMap(List<EntityItem<?>> newItems) {
        HashMap itemKeyItemMap = new HashMap(newItems.size());
        for (EntityItem<?> item : newItems) {
            DateRangeField field;
            if (item instanceof DateRangeField) {
                field = (DateRangeField)item;
                itemKeyItemMap.put(field.getStartDateFieldKey(), item);
                itemKeyItemMap.put(field.getEndDateFieldKey(), item);
                continue;
            }
            if (item instanceof TimeRangeField) {
                field = (TimeRangeField)item;
                itemKeyItemMap.put(field.getStartDateFieldKey(), item);
                itemKeyItemMap.put(field.getEndDateFieldKey(), item);
                continue;
            }
            itemKeyItemMap.put(item.getKey(), item);
        }
        return itemKeyItemMap;
    }

    private boolean buildEntryFieldTreeRow(int row, String entity, String entryKey, List<IDataEntityProperty> properties, MidTableConfigBo bo) {
        boolean isAllChildrenCheck = true;
        Set<String> bizFieldBlackListSet = bo.getBizFieldBlackList(entity);
        List propertyList = properties.stream().filter(Objects::nonNull).filter(property -> !bizFieldBlackListSet.contains(property.getName())).collect(Collectors.toList());
        Integer entityIndex = bo.getEntityIndex(entity);
        if (CollectionUtils.isEmpty(propertyList)) {
            isAllChildrenCheck = false;
        } else {
            int[] rows = new int[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                DynamicObject dyc = new DynamicObject(bo.getDynamicObjectType());
                dyc.set("id", (Object)DBServiceHelper.genLongIds((String)bo.getPageEntry(), (int)1)[0]);
                dyc.set("pid", bo.getDynamicObjectList().get(row).get("id"));
                bo.getDynamicObjectList().add(dyc);
                rows[i] = bo.getDynamicObjectList().size() - 1;
            }
            int index = 0;
            for (IDataEntityProperty property2 : propertyList) {
                if (!this.buildFldTreeNode(property2, rows[index], bo, entityIndex)) {
                    isAllChildrenCheck = false;
                }
                ++index;
            }
            if (!bo.getEntityIndexRangeMap().containsKey(entryKey) && !CollectionUtils.isEmpty(Collections.singleton(rows))) {
                bo.getEntityIndexRangeMap().put(entryKey, new Integer[]{row, rows[rows.length - 1]});
            }
        }
        bo.getDynamicObjectList().get(row).set("ismustinput", (Object)isAllChildrenCheck);
        bo.getDynamicObjectList().get(row).set("isintegrationfield", (Object)isAllChildrenCheck);
        return isAllChildrenCheck;
    }

    private boolean buildFldTreeNode(IDataEntityProperty fldProperty, int row, MidTableConfigBo bo, Integer entityIndex) {
        boolean isBaseData;
        boolean flag;
        List<DynamicObject> dynamicObjectList = bo.getDynamicObjectList();
        String page = bo.getPage();
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (ObjectUtils.isEmpty((Object)prop)) {
            return false;
        }
        String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
        String entityNumber = prop.getName();
        if (prop == prop.getParent().getPrimaryKey()) {
            fldNodeName = this.RES_ID_NAME;
            if (prop.getParent() instanceof EntryType) {
                entityNumber = prop.getParent().getName() + "." + prop.getName();
            }
        } else if (prop.getName().equals("pid") && prop.getParent() instanceof TreeEntryType) {
            fldNodeName = this.RES_PARENT_ID_NAME;
            entityNumber = prop.getParent().getName() + "." + prop.getName();
        }
        boolean bl = flag = fldProperty instanceof FieldProp && ((FieldProp)fldProperty).isMustInput() || fldProperty instanceof BasedataProp && ((BasedataProp)fldProperty).isMustInput() || fldProperty instanceof MulBasedataProp && ((MulBasedataProp)fldProperty).isMustInput();
        if (flag) {
            fldNodeName = fldNodeName + "*";
        }
        if (isBaseData = fldProperty instanceof IBasedataField) {
            dynamicObjectList.get(row).set("referenceprop", (Object)"number");
            dynamicObjectList.get(row).set("isbasedata", (Object)Boolean.TRUE);
        } else {
            dynamicObjectList.get(row).set("referenceprop", null);
            dynamicObjectList.get(row).set("isbasedata", (Object)Boolean.FALSE);
        }
        dynamicObjectList.get(row).set("entityname", (Object)fldNodeName);
        boolean isMustInput = fldNodeName.endsWith("*");
        if (isMustInput) {
            dynamicObjectList.get(row).set("ismustinput", (Object)Boolean.TRUE);
            dynamicObjectList.get(row).set("isintegrationfield", (Object)Boolean.TRUE);
        }
        dynamicObjectList.get(row).set("entitynumber", (Object)entityNumber);
        bo.getNumberMap().merge(entityNumber, 1, Integer::sum);
        String numberAlias = entityNumber;
        if (entityIndex != null) {
            numberAlias = numberAlias + entityIndex;
        }
        dynamicObjectList.get(row).set("numberalias", (Object)numberAlias);
        dynamicObjectList.get(row).set("isfield", (Object)Boolean.TRUE);
        return isMustInput;
    }

    private boolean isProperty(Map<String, EntityItem<?>> itemKeyItemMap, IDataEntityProperty prop, MidTableConfigBo bo) {
        if (prop instanceof AttachmentProp || prop instanceof AttachmentCountProp || "id".equalsIgnoreCase(prop.getName()) || "seq".equalsIgnoreCase(prop.getName())) {
            return false;
        }
        String controlKey = null;
        if (prop instanceof FlexProp) {
            controlKey = ((FlexProp)prop).getBasePropertyKey();
        } else if (prop instanceof ItemClassProp) {
            controlKey = ((ItemClassProp)prop).getTypePropName();
        }
        boolean existControlField = false;
        boolean existProp = false;
        EntityItem<?> entityItem = itemKeyItemMap.get(prop.getName());
        if (entityItem != null) {
            existProp = true;
            if (entityItem instanceof DateRangeField || entityItem instanceof TimeRangeField) {
                bo.setDataRange(prop.getParent().getName() + "." + prop.getName(), entityItem.getKey());
            }
            if (controlKey != null && controlKey.equals(entityItem.getKey())) {
                existControlField = true;
            }
        }
        return existProp && (controlKey == null || existControlField);
    }

    private void getSortProperties(List<IDataEntityProperty> properties, List<ControlAp<?>> apList, EntityType entityType, MidTableConfigBo bo) {
        if (CollectionUtils.isEmpty(apList)) {
            return;
        }
        int index = 0;
        block0: for (ControlAp<?> ap : apList) {
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty prop = properties.get(i);
                if (ap.getKey().equals(prop.getName())) {
                    Collections.swap(properties, i, index++);
                    continue block0;
                }
                IDataEntityType rootEntityType = prop.getParent();
                while (rootEntityType.getParent() != null) {
                    rootEntityType = rootEntityType.getParent();
                }
                String propFullName = rootEntityType.getName() + "." + prop.getName();
                if (!ap.getKey().equals(bo.getDataRangeMap().get(propFullName))) continue;
                Collections.swap(properties, i, index++);
            }
        }
        ArrayList<Object> mustInputProps = new ArrayList<Object>();
        ArrayList<IDataEntityProperty> notMustInputProps = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty propertie : properties) {
            if (propertie instanceof FieldProp && ((FieldProp)propertie).isMustInput()) {
                mustInputProps.add(propertie);
                continue;
            }
            notMustInputProps.add(propertie);
        }
        mustInputProps.addAll(notMustInputProps);
        properties.clear();
        properties.addAll(mustInputProps);
        if (entityType != null) {
            if (entityType instanceof TreeEntryType) {
                properties.add(0, (IDataEntityProperty)entityType.getProperty("pid"));
            }
            properties.add(0, (IDataEntityProperty)entityType.getPrimaryKey());
        }
    }

    private void fillPartialFieldsInfo(LocaleString entityName, String entityNumber, DynamicObject dyn) {
        dyn.set("entityname", (Object)entityName);
        dyn.set("entitynumber", (Object)entityNumber);
        dyn.set("isfield", (Object)Boolean.FALSE);
        dyn.set("istablehead", (Object)Boolean.TRUE);
    }

    @Override
    public MidTableConfig getMidTableConfigByMidTable(String midTable) {
        QFilter midTableFilter = new QFilter("midentitynumber", "=", (Object)midTable);
        return this.getMidTableConfig(new QFilter[]{midTableFilter});
    }

    @Override
    public MidTableConfig getMidTableConfigByBizNumber(String bizNumber) {
        QFilter bizNumberFilter = new QFilter("entityobj.id", "=", (Object)bizNumber);
        return this.getMidTableConfig(new QFilter[]{bizNumberFilter, QFilterConstants.Q_ENABLE});
    }

    @Override
    public Map<String, List<MidTableConfigField>> getEntityFieldByBizNumber(String bizNumber, boolean intField) {
        QFilter bizNumberFilter = new QFilter("entityobj.id", "=", (Object)bizNumber);
        DynamicObject midTableConfigDyn = this.getMidTableDyn(new QFilter[]{bizNumberFilter, QFilterConstants.Q_ENABLE});
        HashMap<String, List<MidTableConfigField>> resultMap = new HashMap<String, List<MidTableConfigField>>(16);
        if (midTableConfigDyn != null) {
            DynamicObjectCollection treeEntryCollection = midTableConfigDyn.getDynamicObjectCollection("treeentryentity");
            HashMap entryMap = Maps.newHashMapWithExpectedSize((int)treeEntryCollection.size());
            treeEntryCollection.forEach(entryDyn -> entryMap.put(entryDyn.getLong("id"), entryDyn));
            HashMap<Long, String> pIdEntityNumberMap = new HashMap<Long, String>(16);
            for (DynamicObject entryDyn2 : treeEntryCollection) {
                ArrayList<MidTableConfigField> midTableConfigFieldList;
                boolean dbIntField = entryDyn2.getBoolean("isintegrationfield");
                if (intField && !dbIntField || !entryDyn2.getBoolean("isfield")) continue;
                long pEntryId = entryDyn2.getLong("pid");
                String entityNumber = (String)pIdEntityNumberMap.get(pEntryId);
                if (StringUtils.isEmpty((String)entityNumber)) {
                    entityNumber = this.getEntityNumber(entryMap, pEntryId);
                    pIdEntityNumberMap.put(pEntryId, entityNumber);
                }
                if (CollectionUtils.isEmpty((Collection)(midTableConfigFieldList = (ArrayList<MidTableConfigField>)resultMap.get(entityNumber)))) {
                    midTableConfigFieldList = new ArrayList<MidTableConfigField>(16);
                }
                midTableConfigFieldList.add(this.buildMidTableConfigFieldInfo(entryDyn2));
                resultMap.put(entityNumber, midTableConfigFieldList);
            }
            return resultMap;
        }
        return resultMap;
    }

    private String getEntityNumber(Map<Long, DynamicObject> entryMap, Long pEntryId) {
        String entityNumber = null;
        while (pEntryId > 0L) {
            DynamicObject pEntryDyn = entryMap.get(pEntryId);
            pEntryId = pEntryDyn.getLong("pid");
            String pEntryDynNumber = pEntryDyn.getString("entitynumber");
            if ("billhead".equals(pEntryDynNumber)) continue;
            if (StringUtils.isEmpty(entityNumber)) {
                entityNumber = pEntryDynNumber;
                continue;
            }
            entityNumber = pEntryDynNumber + "." + entityNumber;
        }
        return entityNumber;
    }

    private MidTableConfig getMidTableConfig(QFilter[] filters) {
        DynamicObject midTableConfigDyn = this.getMidTableDyn(filters);
        if (midTableConfigDyn != null) {
            MidTableConfig configInfo = new MidTableConfig();
            configInfo.setMidEntityNumber(midTableConfigDyn.getString("midentitynumber"));
            configInfo.setEntityNumber(midTableConfigDyn.getString("entityobj.id"));
            DynamicObjectCollection treeEntryCollection = midTableConfigDyn.getDynamicObjectCollection("treeentryentity");
            ArrayList<MidTableConfigField> fieldConfigList = new ArrayList<MidTableConfigField>(treeEntryCollection.size());
            for (DynamicObject treeEntry : treeEntryCollection) {
                fieldConfigList.add(this.buildMidTableConfigFieldInfo(treeEntry));
            }
            configInfo.setFieldConfigList(fieldConfigList);
            return configInfo;
        }
        return null;
    }

    private DynamicObject getMidTableDyn(QFilter[] filters) {
        return this.midTableConfigEntityService.getSingleFromCache("id,name,number,entityobj,midentitynumber,bizapp,treeentryentity.entitynumber,treeentryentity.numberalias,treeentryentity.entityname,treeentryentity.referenceprop,treeentryentity.isintegrationfield,treeentryentity.isfield,treeentryentity.ismustinput,treeentryentity.isvalidateexist,treeentryentity.isbasedata,treeentryentity.istablehead,treeentryentity.pid,treeentryentity.defaultvalue", filters);
    }

    @Override
    public List<String> getMidTableIntFieldListByMidTable(String midTable) {
        List fieldConfigList;
        Map allFieldMap = MetadataUtils.getMainEntityType((String)midTable).getAllFields();
        MidTableConfig tableConfig = this.getMidTableConfigByMidTable(midTable);
        ArrayList fieldNameList = Lists.newArrayList();
        if (tableConfig != null && CollectionUtils.isNotEmpty((Collection)(fieldConfigList = tableConfig.getFieldConfigList()))) {
            fieldConfigList.forEach(dy -> {
                if (!dy.isIntField() || !dy.isField()) {
                    return;
                }
                IDataEntityProperty property = (IDataEntityProperty)allFieldMap.get(dy.getNumberAlias());
                if (property instanceof LargeTextProp) {
                    String field = dy.getEntityNumber();
                    fieldNameList.add(field);
                    fieldNameList.add(field + "_tag");
                } else {
                    fieldNameList.add(dy.getEntityNumber());
                }
            });
        }
        return fieldNameList;
    }

    @Override
    public DynamicObject[] queryMidTableConfig(String entityNumber, String selectProperties, List<Long> ids) {
        if ("hrdi_midtableconfigtpl".equals(entityNumber)) {
            return this.midTableConfigTplEntityService.query(selectProperties, new QFilter[]{new QFilter("id", "not in", ids)});
        }
        if ("hrdi_midtableconfig".equals(entityNumber)) {
            return this.midTableConfigEntityService.query(selectProperties, new QFilter[]{new QFilter("id", "not in", ids)});
        }
        return null;
    }

    @Override
    public DynamicObject[] queryMidTableConfigById(String selectProperties, Set<Long> idSet) {
        return this.midTableConfigEntityService.query(selectProperties, new QFilter[]{new QFilter("id", "in", idSet)});
    }

    @Override
    public void deleteMidTableConfigById(Long midTableConfigId) {
        this.midTableConfigEntityService.delete(midTableConfigId);
    }

    @Override
    public void deleteMidTableConfigByNumber(String midTableConfigNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)midTableConfigNumber);
        this.midTableConfigEntityService.deleteByFilter(new QFilter[]{numberFilter});
    }

    @Override
    public void deleteByEntity(List<String> entityList) {
        QFilter entityFilter = new QFilter("entityobj", "in", entityList);
        this.midTableConfigEntityService.deleteByFilter(new QFilter[]{entityFilter});
    }

    @Override
    public boolean isConfigTplMustInput(String entityId, String fieldAlias) {
        QFilter entityFilter = new QFilter("entityobj", "=", (Object)entityId);
        DynamicObject configTplDyn = this.midTableConfigTplEntityService.queryOne("treeentryentity.numberalias,treeentryentity.ismustinput", new QFilter[]{entityFilter, QFilterConstants.Q_ENABLE, QFilterConstants.Q_PRESET});
        if (configTplDyn != null) {
            DynamicObjectCollection entryEntityCollection = configTplDyn.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entryEntity : entryEntityCollection) {
                if (!StringUtils.equals((String)fieldAlias, (String)entryEntity.getString("numberalias"))) continue;
                return entryEntity.getBoolean("ismustinput");
            }
        }
        return false;
    }

    private MidTableConfigField buildMidTableConfigFieldInfo(DynamicObject treeEntry) {
        MidTableConfigField configFieldInfo = new MidTableConfigField();
        configFieldInfo.setBaseData(treeEntry.getBoolean("isbasedata"));
        configFieldInfo.setEntityName(treeEntry.getString("entityname"));
        configFieldInfo.setEntityNumber(treeEntry.getString("entitynumber"));
        configFieldInfo.setIntField(treeEntry.getBoolean("isintegrationfield"));
        configFieldInfo.setMustInput(treeEntry.getBoolean("ismustinput"));
        configFieldInfo.setNumberAlias(treeEntry.getString("numberalias"));
        configFieldInfo.setRefProp(treeEntry.getString("referenceprop"));
        configFieldInfo.setTableHead(treeEntry.getBoolean("istablehead"));
        configFieldInfo.setValidateExist(treeEntry.getBoolean("isvalidateexist"));
        configFieldInfo.setField(treeEntry.getBoolean("isfield"));
        configFieldInfo.setDefaultValue(treeEntry.getString("defaultvalue"));
        return configFieldInfo;
    }
}

