/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.middle.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigTplDomainService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigTplEntityService;

public class MidTableConfigTplDomainService
implements IMidTableConfigTplDomainService {
    private final IMidTableConfigTplEntityService midTableConfigTplEntityService = ServiceFactory.getService(IMidTableConfigTplEntityService.class);

    @Override
    public List<String> getBizAppIds() {
        List midTableConfigList = this.midTableConfigTplEntityService.queryOriginalList("bizapp", null);
        ArrayList<String> appIdList = new ArrayList<String>(midTableConfigList.size());
        midTableConfigList.forEach(midTable -> appIdList.add(midTable.getString("bizapp")));
        return appIdList;
    }

    @Override
    public Set<String> getMustFieldsByBizNumber(String bizNumber) {
        QFilter bizNumberFilter = new QFilter("entityobj.id", "=", (Object)bizNumber);
        DynamicObject midTableDyn = this.getMidTableDyn(new QFilter[]{bizNumberFilter, QFilterConstants.Q_ENABLE});
        HashSet<String> mustFieldSet = new HashSet<String>(16);
        if (midTableDyn != null) {
            DynamicObjectCollection treeEntryCollection = midTableDyn.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject treeEntry : treeEntryCollection) {
                Boolean intField = treeEntry.getBoolean("isintegrationfield");
                Boolean mustField = treeEntry.getBoolean("ismustinput");
                Boolean field = treeEntry.getBoolean("isfield");
                String numberAlias = treeEntry.getString("numberalias");
                if (!intField.booleanValue() || !mustField.booleanValue() || !field.booleanValue()) continue;
                mustFieldSet.add(numberAlias);
            }
        }
        return mustFieldSet;
    }

    private DynamicObject getMidTableDyn(QFilter[] filters) {
        return this.midTableConfigTplEntityService.getSingleFromCache("id,treeentryentity.numberalias,treeentryentity.isintegrationfield,treeentryentity.isfield,treeentryentity.ismustinput,treeentryentity.istablehead,treeentryentity.pid", filters);
    }
}

