/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.middle.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableDomainService;
import kd.hdtc.hrdi.common.HRDIAppConstants;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hdtc.hrdi.common.pojo.MidTableConfigField;

public class MidTableDomainServiceImpl
implements IMidTableDomainService {
    private final Log logger = LogFactory.getLog(MidTableDomainServiceImpl.class);
    private final IBaseCommonDomainService commonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    private final IMidTableConfigDomainService configDomainService = ServiceFactory.getService(IMidTableConfigDomainService.class);

    @Override
    public DynamicObject generateEmptyDynamicObject(String midTableNumber) {
        return this.commonDomainService.generateEmptyDynamicObject(midTableNumber);
    }

    @Override
    public DynamicObject[] transferMidTableDyn(String tableNumber, String batchNumber, String sourceSys, List<Map<String, Object>> dataList) {
        MidTableConfig tableConfig = this.configDomainService.getMidTableConfigByMidTable(tableNumber);
        if (tableConfig == null) {
            this.logger.error("TableNumber:{} has not midtableconfig", (Object)tableNumber);
            return null;
        }
        ArrayList midTableList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        Map<String, IDataEntityProperty> propertyMap = this.generateEmptyDynamicObject(tableNumber).getDataEntityType().getProperties().stream().collect(Collectors.toMap(IMetadata::getName, property -> property));
        HashSet<String> timeFieldSet = new HashSet<String>(16);
        propertyMap.forEach((field, prop) -> {
            if (prop instanceof TimeProp) {
                timeFieldSet.add((String)field);
            }
        });
        Map<String, String> aliasDefaultValueMap = tableConfig.getFieldConfigList().stream().filter(MidTableConfigField::isIntField).filter(field -> kd.hdtc.hrdbs.common.util.StringUtils.isNotEmpty((String)field.getDefaultValue())).collect(Collectors.toMap(MidTableConfigField::getNumberAlias, MidTableConfigField::getDefaultValue));
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        long[] midTableDynIds = ID.genLongIds((int)dataList.size());
        int index = 1;
        for (Map<String, Object> dataRow : dataList) {
            DynamicObject midTableDy = this.generateEmptyDynamicObject(tableNumber);
            this.specialFieldHandle(timeFieldSet, dataRow, midTableDy);
            this.fillBizField(midTableDy, dataRow, aliasDefaultValueMap, propertyMap);
            String intNumber = batchNumber + decimalFormat.format(index);
            this.fillSysField(midTableDy, batchNumber, intNumber, sourceSys, index, midTableDynIds[index - 1]);
            ++index;
            midTableList.add(midTableDy);
        }
        return midTableList.toArray(new DynamicObject[0]);
    }

    private void specialFieldHandle(Set<String> timeFieldSet, Map<String, Object> dataRow, DynamicObject midTableDy) {
        timeFieldSet.forEach(field -> {
            if (!dataRow.containsKey(field)) {
                midTableDy.set(field, (Object)-1);
            }
        });
    }

    private void fillBizField(DynamicObject midTableDy, Map<String, Object> dataRow, Map<String, String> aliasDefaultValueMap, Map<String, IDataEntityProperty> propertyMap) {
        dataRow.forEach((field, value) -> this.setValue(midTableDy, propertyMap, (String)field, value));
        if (((Boolean)dataRow.get("is_delete")).booleanValue()) {
            return;
        }
        aliasDefaultValueMap.forEach((field, defaultValue) -> {
            Object value = dataRow.get(field);
            if (ObjectUtils.isEmpty(value)) {
                value = defaultValue;
            }
            if (propertyMap.get(field) instanceof MuliLangTextProp && value instanceof JSONObject) {
                Locale locale = RequestContext.get().getLang().getLocale();
                ((JSONObject)value).put(locale.toString(), defaultValue);
            }
            this.setValue(midTableDy, propertyMap, (String)field, value);
        });
    }

    private void fillSysField(DynamicObject midTableDy, String batchNumber, String intNumber, String sourceSys, int index, long id) {
        midTableDy.set("id", (Object)id);
        midTableDy.set("hrdibatchnumber", (Object)batchNumber);
        midTableDy.set("hrdisequence", (Object)index);
        midTableDy.set("hrdinumber", (Object)intNumber);
        midTableDy.set("hrdiintstatus", (Object)"0");
        midTableDy.set("hrdisourcesys", (Object)sourceSys);
    }

    private void setValue(DynamicObject midTableDy, Map<String, IDataEntityProperty> propertyMap, String field, Object value) {
        if (!propertyMap.containsKey(field)) {
            return;
        }
        if (value == null) {
            midTableDy.set(field, null);
            return;
        }
        if (propertyMap.get(field) instanceof DateTimeProp) {
            this.setDateValue(midTableDy, propertyMap.get(field), value);
        } else if (propertyMap.get(field) instanceof LargeTextProp) {
            DynamicObjectUtils.setBigText((DynamicObject)midTableDy, (String)field, (String)((String)value));
        } else {
            midTableDy.set(field, value);
        }
    }

    @Override
    public void saveMidTableData(DynamicObject[] midTableDyns) {
        SaveServiceHelper.save((DynamicObject[])midTableDyns);
    }

    private void setDateValue(DynamicObject midTableDy, IDataEntityProperty prop, Object timeValue) {
        if (timeValue == null) {
            midTableDy.set(prop.getName(), null);
            return;
        }
        if (timeValue instanceof Date) {
            midTableDy.set(prop.getName(), timeValue);
            return;
        }
        midTableDy.set(prop.getName(), (Object)this.parseDate((DateTimeProp)prop, midTableDy, timeValue.toString()));
    }

    private Date parseDate(DateTimeProp timeProp, DynamicObject midTableDy, String timeStr) {
        try {
            return timeProp.parse((Object)midTableDy, timeStr);
        }
        catch (ParseException parseException) {
            try {
                Long timestamp = Long.parseLong(timeStr);
                TimeZone timeZone = timeProp.getTimeZone(this.getOrgId(midTableDy)).getTimeZone();
                return DateTimeUtils.parseDateByTimeStamp((Long)timestamp, (TimeZone)timeZone);
            }
            catch (Exception exception) {
                String errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd HH:mm:ss \u6216 yyyy-MM-dd HH:mm:ss:SSS", (String)"MidTableDomainServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]), timeProp.getName(), timeStr);
                throw new OpenApiException(ApiErrorCode.Data_Invalid, errMsg, new Object[]{""});
            }
        }
    }

    private Long getOrgId(DynamicObject midTableDy) {
        DynamicObject org;
        IDataEntityType entityType = midTableDy.getDataEntityType();
        String orgKey = ((MainEntityType)entityType).getMainOrg();
        Long orgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)orgKey) && (org = midTableDy.getDynamicObject(orgKey)) != null) {
            orgId = (Long)org.getPkValue();
        }
        return orgId;
    }

    @Override
    public void syncMidTableValidate(String midTableNumber, List<Map<String, Object>> dataList) {
        boolean midTableExist = MetadataUtils.isExist((String)midTableNumber);
        if (!midTableExist) {
            String kdString = ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u4e0d\u5b58\u5728\uff1a%s\u3002", (String)"MidTableDomainServiceImpl_1", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
            throw new OpenApiException(ApiErrorCode.Data_NotFound, String.format(Locale.ROOT, kdString, midTableNumber), new Object[]{""});
        }
        if (CollectionUtils.isNotEmpty(dataList) && (long)dataList.size() > HRDIAppConstants.ONE_WRITE_MAX_COUNT) {
            String kdString = ResManager.loadKDString((String)"\u5355\u6b21\u6570\u636e\u603b\u91cf\u4e0d\u5f97\u8d85\u8fc710000\u3002", (String)"MidTableDomainServiceImpl_2", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
            throw new OpenApiException(ApiErrorCode.Data_Invalid, kdString, new Object[]{""});
        }
    }
}

