/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.middle.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.middle.IMidTableLogDomainService;
import kd.hdtc.hrdi.business.domain.middle.bo.MidModifyLogInfo;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidModifyLogEntityService;
import kd.hr.hbp.business.log.EntityModifyInfo;
import kd.hr.hbp.business.log.FieldModifyInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MidTableLogDomainServiceImpl
implements IMidTableLogDomainService {
    private static final Log LOG = LogFactory.getLog(MidTableLogDomainServiceImpl.class);
    private MainEntityType mainEntityType;
    private DynamicObject[] successObjs;
    private Map<String, EntityModifyInfo> modifyInfoMap = Maps.newHashMapWithExpectedSize((int)16);
    private String operate;
    private Map<String, IDataEntityProperty> monitorFields;
    private IMidModifyLogEntityService midModifyLogEntityService = ServiceFactory.getService(IMidModifyLogEntityService.class);

    @Override
    public EntityModifyInfo getEntityModifyInfo(String pkValue) {
        return this.modifyInfoMap.get(pkValue);
    }

    public List<MidModifyLogInfo> buildLogInfo(DynamicObject[] dys) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dys.length);
        HashSet sourceSysNumbers = new HashSet();
        Stream.of(dys).forEach(dy -> {
            String sourceSysNumber = dy.getString("hrdisourcesys");
            if (!StringUtils.isEmpty((CharSequence)sourceSysNumber)) {
                sourceSysNumbers.add(sourceSysNumber);
            }
        });
        QFilter idFilter = new QFilter("number", "in", sourceSysNumbers);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrdi_sourcesys");
        Object[] dynamicObjects = serviceHelper.query(new QFilter[]{idFilter});
        HashMap sourceSysNumberSourceSysIdMap = new HashMap(16);
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            Arrays.stream(dynamicObjects).forEach(dd -> sourceSysNumberSourceSysIdMap.put(dd.getString("number"), dd));
        }
        Date now = TimeServiceHelper.now();
        ObjectMapper mapper = new ObjectMapper();
        for (DynamicObject mainObj : dys) {
            Object pkValObj = mainObj.getPkValue();
            if (pkValObj == null) continue;
            String pkValStr = pkValObj.toString();
            EntityModifyInfo entityModifyInfo = this.getEntityModifyInfo(pkValStr);
            MidModifyLogInfo logInfo = new MidModifyLogInfo();
            logInfo.setUserID(RequestContext.get().getCurrUserId());
            String formId = mainObj.getDynamicObjectType().getName();
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
            logInfo.setBizAppID(appId);
            logInfo.setBizObjID(formId);
            logInfo.setOpTime(now);
            logInfo.setOpName(this.operate);
            logInfo.setNumber(mainObj.getString("hrdinumber"));
            String sourceSysNumber = mainObj.getString("hrdisourcesys");
            if (!StringUtils.isEmpty((CharSequence)sourceSysNumber)) {
                DynamicObject dynamicObject = (DynamicObject)sourceSysNumberSourceSysIdMap.get(sourceSysNumber);
                logInfo.setSourceSys(dynamicObject);
            }
            logInfo.setSourceSysKey(mainObj.getString("hrdisourcesyskey"));
            if (entityModifyInfo == null || entityModifyInfo.isEmpty()) continue;
            String flag = entityModifyInfo.getFlag() == null ? "" : entityModifyInfo.getFlag();
            logInfo.setModifyBillID(pkValObj + flag);
            logInfo.setModifyBillNo(entityModifyInfo.getCaption());
            String modifyContentStr = null;
            try {
                modifyContentStr = mapper.writeValueAsString((Object)entityModifyInfo);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (StringUtils.isBlank((CharSequence)modifyContentStr)) continue;
            logInfo.setModifyContent(modifyContentStr);
            list.add(logInfo);
        }
        return list;
    }

    @Override
    public void init(DynamicObjectType dynamicObjectType, DynamicObject[] successObjs, String operate) {
        this.mainEntityType = (MainEntityType)dynamicObjectType;
        this.successObjs = successObjs;
        this.operate = operate;
        this.modifyInfoMap = new HashMap<String, EntityModifyInfo>(16);
        try {
            this.monitorFields = EntityMetadataCache.getDataEntityType((String)dynamicObjectType.getName()).getAllFields();
            this.build();
        }
        catch (Exception e) {
            LOG.info("MidtableLogDomainServiceImpl init error:", (Object)e);
        }
    }

    @Override
    public EntityModifyInfo compare(DynamicObject sourceBizObj, DynamicObject targetBizObj) {
        return this.buildMainEntry(sourceBizObj, targetBizObj, false, false);
    }

    private void build() {
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])Stream.of(this.successObjs).map(DataEntityBase::getPkValue).distinct().toArray(), (DynamicObjectType)this.mainEntityType);
        for (DynamicObject mainObj : this.successObjs) {
            Object pkValObj = mainObj.getPkValue();
            if (pkValObj == null) continue;
            String pkValStr = pkValObj.toString();
            boolean isDeleteMainObj = this.isDeleteOperate();
            boolean isNewMainObj = !mainObj.getDataEntityState().getFromDatabase() && !isDeleteMainObj;
            DynamicObject cacheObj = (DynamicObject)objectDynamicObjectMap.get(pkValObj);
            EntityModifyInfo info = this.buildMainEntry(mainObj, cacheObj, isDeleteMainObj, isNewMainObj);
            this.modifyInfoMap.put(pkValStr, info);
        }
    }

    protected String getBillNo(DynamicObject dynamicObject) {
        IDataEntityProperty billNoProp = null;
        if (this.mainEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.mainEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.mainEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this.mainEntityType instanceof BillEntityType) {
            billNoProp = this.mainEntityType.findProperty(((BillEntityType)this.mainEntityType).getBillNo());
        }
        if (billNoProp != null) {
            return (String)billNoProp.getValue((Object)dynamicObject);
        }
        return "";
    }

    public EntityModifyInfo buildMainEntry(DynamicObject mainObj, DynamicObject oldMainObj, boolean isDeleteMainObj, boolean isNewMainObj) {
        String pkValueStr = mainObj.getPkValue().toString();
        ArrayList<IDataEntityProperty> mainDirtyPropList = new ArrayList<IDataEntityProperty>();
        EntityModifyInfo mainModifyInfo = new EntityModifyInfo();
        mainModifyInfo.setKeyID(pkValueStr);
        String billNo = this.getBillNo(mainObj);
        if (!StringUtils.isBlank((CharSequence)billNo)) {
            mainModifyInfo.setCaption(billNo);
        }
        this.handleMainEntity(mainObj, oldMainObj, isDeleteMainObj, isNewMainObj, mainDirtyPropList, mainModifyInfo);
        return mainModifyInfo;
    }

    private void handleMainEntity(DynamicObject mainObj, DynamicObject oldMainObj, boolean isDeleteMainObj, boolean isNewMainObj, List<IDataEntityProperty> mainDirtyPropList, EntityModifyInfo mainModifyInfo) {
        if (!isDeleteMainObj) {
            if (isNewMainObj) {
                this.parseDirtyProp(mainObj, mainDirtyPropList, false);
                for (IDataEntityProperty mainDirtyProp : mainDirtyPropList) {
                    FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, mainDirtyProp, false);
                    if (Objects.isNull(fieldModifyInfo)) continue;
                    mainModifyInfo.addField(mainDirtyProp.getName(), fieldModifyInfo);
                }
                mainModifyInfo.setFlag("+");
            } else {
                this.parseDirtyProp(mainObj, mainDirtyPropList, true);
                for (IDataEntityProperty mainDirtyProp : mainDirtyPropList) {
                    FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, mainDirtyProp, false);
                    if (Objects.isNull(fieldModifyInfo) || "hrdimodifydate".equals(mainDirtyProp.getName())) continue;
                    mainModifyInfo.addField(mainDirtyProp.getName(), fieldModifyInfo);
                }
            }
        }
    }

    private String getPropertyValue(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof DynamicSimpleProperty) {
            if (dynamicProperty instanceof IFieldHandle) {
                return this.getFieldHandle(dynamicObject, dynamicProperty);
            }
            return dynamicObject.getString(dynamicProperty.getName());
        }
        if (dynamicProperty instanceof DynamicComplexProperty) {
            try {
                return this.getComplexProp(dynamicObject, dynamicProperty);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String getComplexProp(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof FlexProp) {
            List flexValueList = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dynamicObject, (FlexProp)((FlexProp)dynamicProperty), (String)((FlexProp)dynamicProperty).getBasePropertyKey());
            ArrayList<String> displayValueList = new ArrayList<String>();
            for (Map item : flexValueList) {
                String alias = (String)item.get("alias");
                if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                displayValueList.add(alias);
            }
            return String.join((CharSequence)"; ", displayValueList);
        }
        DynamicObject obj = dynamicObject.getDynamicObject(dynamicProperty);
        return Objects.requireNonNull(Optional.ofNullable(obj).map(sd -> sd.getString("name")).orElse(null));
    }

    private String getFieldHandle(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof TimeProp) {
            TimeProp timeProp = (TimeProp)dynamicProperty;
            Object timePropObj = timeProp.getBasePropDisplayValue((Object)dynamicObject);
            return timePropObj != null ? timePropObj.toString() : null;
        }
        try {
            Object[] val;
            IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
            ListField listField = new ListField(dynamicProperty.getName());
            listField.setSrcFieldProp(dynamicProperty);
            listField.setFieldProp(dynamicProperty);
            AbstractColumnDesc listColumnDesc = fldHandle.getListColumnDesc(listField);
            listColumnDesc.setFormaType(2);
            Object valueObj = listColumnDesc.getValue(dynamicObject);
            if (valueObj instanceof Object[] && (val = (Object[])valueObj).length > 0) {
                Object obj = val[0];
                return obj != null ? obj.toString() : null;
            }
            return valueObj != null ? valueObj.toString() : null;
        }
        catch (Exception e1) {
            try {
                IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
                Object dispValueObj = fldHandle.getBasePropDisplayValue((Object)dynamicObject);
                return dispValueObj != null ? dispValueObj.toString() : null;
            }
            catch (Exception e) {
                return dynamicObject.getString(dynamicProperty.getName());
            }
        }
    }

    private FieldModifyInfo buildFieldModifyInfo(DynamicObject obj, DynamicObject oldObj, IDataEntityProperty property, boolean isDelete) {
        LocaleString name = property.getDisplayName();
        String displayName = name != null ? name.toString() : property.getName();
        String newValue = null;
        if (obj != null && !isDelete) {
            newValue = this.getPropertyValue(obj, property);
        }
        String oldValue = null;
        if (oldObj != null) {
            oldValue = this.getPropertyValue(oldObj, property);
        }
        Object desensitizeNewValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)obj, (Object)newValue);
        Object desensitizeOldValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)obj, (Object)oldValue);
        if (HRStringUtils.equals((String)newValue, (String)oldValue)) {
            return null;
        }
        return new FieldModifyInfo(desensitizeOldValue, desensitizeNewValue, displayName);
    }

    private void parseDirtyProp(DynamicObject obj, List<IDataEntityProperty> dirtyPropList, boolean isUpdate) {
        ArrayList<IDataEntityProperty> monitorProps = new ArrayList<IDataEntityProperty>();
        this.parseDirtyPropByMonitor(obj, monitorProps);
        if (isUpdate) {
            ArrayList<IDataEntityProperty> dirtyStatePropList = new ArrayList<IDataEntityProperty>();
            this.parseDirtyPropByState(obj, dirtyStatePropList);
            if (dirtyStatePropList.size() == 0) {
                return;
            }
            for (IDataEntityProperty dirtyStateProp : dirtyStatePropList) {
                if (dirtyStateProp instanceof CreaterProp || dirtyStateProp instanceof CreateDateProp || HRStringUtils.isEmpty((String)dirtyStateProp.getAlias()) || dirtyStateProp instanceof ISimpleProperty && ((ISimpleProperty)dirtyStateProp).isEncrypt()) continue;
                dirtyPropList.add(dirtyStateProp);
            }
        } else {
            dirtyPropList.addAll(monitorProps);
        }
        dirtyPropList.sort(Comparator.comparingInt(IDataEntityProperty::getOrdinal));
    }

    private void parseDirtyPropByMonitor(DynamicObject obj, List<IDataEntityProperty> dirtyPropList) {
        if (this.monitorFields == null || this.monitorFields.size() == 0) {
            return;
        }
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        for (Map.Entry<String, IDataEntityProperty> stringIDataEntityPropertyEntry : this.monitorFields.entrySet()) {
            IDataEntityProperty prop;
            String key = stringIDataEntityPropertyEntry.getKey();
            IDataEntityProperty property = stringIDataEntityPropertyEntry.getValue();
            if (property instanceof CreaterProp || property instanceof CreateDateProp || HRStringUtils.isEmpty((String)property.getAlias()) || property instanceof ISimpleProperty && ((ISimpleProperty)property).isEncrypt() || (prop = (IDataEntityProperty)properties.get((Object)key)) == null) continue;
            dirtyPropList.add(prop);
        }
    }

    private void parseDirtyPropByState(DynamicObject obj, List<IDataEntityProperty> dirtyPropList) {
        Iterator iterator = obj.getDataEntityState().getBizChangedProperties().iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty property;
            IDataEntityProperty realProperty = property = (IDataEntityProperty)iterator.next();
            if (property instanceof PKFieldProp && property.getName().endsWith("_id")) {
                String bdPropName = property.getName().substring(0, property.getName().length() - 3);
                realProperty = (IDataEntityProperty)property.getParent().getProperties().get((Object)bdPropName);
                if (realProperty == null) {
                    realProperty = property;
                }
            }
            dirtyPropList.add(realProperty);
        }
    }

    private boolean isDeleteOperate() {
        return "delete".equals(this.operate);
    }

    @Override
    public void batchInsertLog(DynamicObject[] dys) {
        try {
            List<MidModifyLogInfo> appLogInfoList = this.buildLogInfo(dys);
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            for (MidModifyLogInfo appLogInfo : appLogInfoList) {
                DynamicObject dyn = this.midModifyLogEntityService.generateEmptyDynamicObject();
                dyn.set("user", (Object)appLogInfo.getUserID());
                dyn.set("bizapp", (Object)appLogInfo.getBizAppID());
                dyn.set("bizobj", (Object)appLogInfo.getBizObjID());
                dyn.set("optime", (Object)appLogInfo.getOpTime());
                dyn.set("modifybillid", (Object)appLogInfo.getModifyBillID());
                dyn.set("modifybillno", (Object)appLogInfo.getModifyBillNo());
                dyn.set("modifycontent", (Object)appLogInfo.getModifyContent());
                dyn.set("number", (Object)appLogInfo.getNumber());
                dyn.set("sourcesys", (Object)appLogInfo.getSourceSys());
                dyn.set("sourcedatakey", (Object)appLogInfo.getSourceSysKey());
                dynamicObjectCollection.add((Object)dyn);
            }
            this.midModifyLogEntityService.save((DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[0]));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

