/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.monitor.bo;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.id.ID;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IIntLogEntityService;

public class IntLogBuilder {
    private final IIntLogEntityService iIntLogEntityService = ServiceFactory.getService(IIntLogEntityService.class);
    private final IIntSourceDomainService iIntSourceDomainService = ServiceFactory.getService(IIntSourceDomainService.class);
    private final IIntSourceSysDomainService sourceSysDomainService = ServiceFactory.getService(IIntSourceSysDomainService.class);
    private DynamicObject parent;
    private String entityNumber;
    private String batchNumber;
    private String operateStatus;
    private String errorInfo;
    private Long dataCount;
    private String startNumber;
    private String endNumber;
    private List<String> selectNumberList;
    private String sourceSys;

    public IntLogBuilder setParent(DynamicObject parent) {
        this.parent = parent;
        return this;
    }

    public IntLogBuilder setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
        return this;
    }

    public IntLogBuilder setBatchNumber(String batchNumber) {
        this.batchNumber = batchNumber;
        return this;
    }

    public IntLogBuilder setSourceSys(String sourceSys) {
        this.sourceSys = sourceSys;
        return this;
    }

    public IntLogBuilder setOperateStatus(String operateStatus) {
        this.operateStatus = operateStatus;
        return this;
    }

    public IntLogBuilder setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    public IntLogBuilder setDataCount(Long dataCount) {
        this.dataCount = dataCount;
        return this;
    }

    public IntLogBuilder setStartNumber(String startNumber) {
        this.startNumber = startNumber;
        return this;
    }

    public IntLogBuilder setEndNumber(String endNumber) {
        this.endNumber = endNumber;
        return this;
    }

    public IntLogBuilder setSelectNumberList(List<String> selectNumberList) {
        this.selectNumberList = selectNumberList;
        return this;
    }

    public DynamicObject build() {
        DynamicObject intLog = this.iIntLogEntityService.generateEmptyDynamicObject();
        Object[] intSources = this.iIntSourceDomainService.queryIntSourceByEntityNumbers(Collections.singletonList(this.entityNumber));
        DynamicObject sourceSys = this.sourceSysDomainService.queryByNumber(this.sourceSys);
        long id = ID.genLongId();
        intLog.set("id", (Object)id);
        intLog.set("number", (Object)id);
        intLog.set("parent", (Object)this.parent);
        intLog.set("intsource", ArrayUtils.isNotEmpty((Object[])intSources) ? intSources[0] : null);
        intLog.set("batchnumber", (Object)this.batchNumber);
        intLog.set("operatestatus", (Object)this.operateStatus);
        DynamicObjectUtils.setBigText((DynamicObject)intLog, (String)"errorinfo", (String)this.errorInfo);
        intLog.set("datacount", (Object)this.dataCount);
        intLog.set("startnumber", (Object)this.startNumber);
        intLog.set("endnumber", (Object)this.endNumber);
        if (CollectionUtils.isNotEmpty(this.selectNumberList)) {
            String selectNumber = String.join((CharSequence)",", this.selectNumberList);
            intLog.set("selectnumber_tag", (Object)selectNumber);
            intLog.set("selectnumber", (Object)(selectNumber.length() >= 255 ? selectNumber.substring(0, 255) : selectNumber));
        }
        intLog.set("retrycount", (Object)0L);
        intLog.set("transtarttime", (Object)new Date());
        intLog.set("sourcesys", (Object)sourceSys);
        return intLog;
    }
}

