/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.monitor.entity.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.domain.monitor.bean.CommonSubMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.bean.EventMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.bean.PersonSubMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;
import kd.hdtc.hrdi.common.enums.MsgRecordLogStatusEnum;

public class MsgRecordLogEntityServiceImpl
extends AbstractBaseEntityService
implements IMsgRecordLogEntityService {
    private static final String SELECT_PROPERTIES = "id,intsource,sourcesys,operatestatus,errorinfo,errorinfo_tag,entitycategory,msgnumber,msgcontent,msgcontent_tag,msgtype";

    public MsgRecordLogEntityServiceImpl() {
        super("hrdi_msgrecordlog");
    }

    @Override
    public Long getMsgRecordLogId(String msgType, String msgNumber, DynamicObject intRelation) {
        DynamicObject eventMsgRecordLog = this.getMsgRecordLog(msgType, msgNumber, intRelation);
        return eventMsgRecordLog == null ? null : Long.valueOf(eventMsgRecordLog.getLong("id"));
    }

    @Override
    public DynamicObject getMsgRecordLog(String msgType, String msgNumber, DynamicObject intRelation) {
        if (msgType == null || intRelation == null) {
            return null;
        }
        QFilter intSourceFilter = new QFilter("intsource", "=", intRelation.get("intsource"));
        QFilter sourceSysFilter = new QFilter("sourcesys", "=", intRelation.get("sourcesys"));
        QFilter msgNumberFilter = new QFilter("msgnumber", "=", (Object)msgNumber);
        QFilter msgTypeFilter = new QFilter("msgtype", "=", (Object)msgType);
        return this.queryOne(SELECT_PROPERTIES, new QFilter[]{intSourceFilter, sourceSysFilter, msgNumberFilter, msgTypeFilter});
    }

    @Override
    public Long saveEventMsgRecordLog(EventMsgRecordContentBean eventMsgRecordContentBean, DynamicObject intRelation) {
        if (eventMsgRecordContentBean == null || intRelation == null) {
            return 0L;
        }
        DynamicObject msgRecordLog = this.getEventMsgRecordLog(eventMsgRecordContentBean, intRelation);
        this.save(msgRecordLog);
        return msgRecordLog.getLong("id");
    }

    @Override
    public Long saveCommonSubMsgRecordLog(CommonSubMsgRecordContentBean commonSubMsgRecordContentBean, DynamicObject intRelation) {
        if (commonSubMsgRecordContentBean == null || intRelation == null) {
            return 0L;
        }
        DynamicObject msgRecordLog = this.getCommonSubMsgRecordLog(commonSubMsgRecordContentBean, intRelation);
        this.save(msgRecordLog);
        return msgRecordLog.getLong("id");
    }

    private DynamicObject getCommonSubMsgRecordLog(CommonSubMsgRecordContentBean commonSubMsgRecordContentBean, DynamicObject intRelation) {
        DynamicObject msgRecordLog = this.initMsgRecordLog(intRelation);
        DynamicObjectUtils.setBigText((DynamicObject)msgRecordLog, (String)"msgcontent", (String)JSONObject.toJSONString((Object)commonSubMsgRecordContentBean));
        msgRecordLog.set("msgnumber", (Object)commonSubMsgRecordContentBean.getNumber());
        msgRecordLog.set("msgtype", (Object)"3");
        msgRecordLog.set("operatestatus", (Object)MsgRecordLogStatusEnum.PROCESSING.getCode());
        return msgRecordLog;
    }

    @Override
    public boolean updateEventMsgRecordLogStatus(Long eventMsgRecordId, String errorInfo, boolean exception) {
        DynamicObject msgRecordLog = this.queryOne(SELECT_PROPERTIES, eventMsgRecordId);
        if (msgRecordLog == null) {
            return false;
        }
        errorInfo = this.errorInfoHandle(errorInfo);
        String code = MsgRecordLogStatusEnum.FINISH.getCode();
        if (StringUtils.isNotEmpty((String)errorInfo)) {
            code = exception ? MsgRecordLogStatusEnum.SERVICE_EXCEPTION.getCode() : MsgRecordLogStatusEnum.ERROR.getCode();
        }
        msgRecordLog.set("operatestatus", (Object)code);
        DynamicObjectUtils.setBigText((DynamicObject)msgRecordLog, (String)"errorinfo", (String)errorInfo);
        this.save(msgRecordLog);
        return true;
    }

    private String errorInfoHandle(String errorMsg) {
        if (StringUtils.isEmpty((String)errorMsg) || "null".equalsIgnoreCase(errorMsg)) {
            return "";
        }
        return errorMsg;
    }

    @Override
    public boolean updateMsgRecordLogStatus(DynamicObject msgRecordLog, MsgRecordLogStatusEnum msgRecordLogStatusEnum) {
        if (msgRecordLog == null || msgRecordLogStatusEnum == null) {
            return false;
        }
        msgRecordLog.set("operatestatus", (Object)msgRecordLogStatusEnum.getCode());
        this.save(msgRecordLog);
        return true;
    }

    @Override
    public Long savePersonSubMsgRecordLog(PersonSubMsgRecordContentBean personSubMsgRecordContentBean, DynamicObject intRelation) {
        if (personSubMsgRecordContentBean == null || intRelation == null) {
            return 0L;
        }
        DynamicObject msgRecordLog = this.getPersonSubMsgRecordLog(personSubMsgRecordContentBean, intRelation);
        this.save(msgRecordLog);
        return msgRecordLog.getLong("id");
    }

    private DynamicObject getEventMsgRecordLog(EventMsgRecordContentBean eventMsgRecordContentBean, DynamicObject intRelation) {
        DynamicObject msgRecordLog = this.initMsgRecordLog(intRelation);
        DynamicObjectUtils.setBigText((DynamicObject)msgRecordLog, (String)"msgcontent", (String)JSONObject.toJSONString((Object)eventMsgRecordContentBean));
        msgRecordLog.set("msgnumber", (Object)eventMsgRecordContentBean.getEventId());
        msgRecordLog.set("msgtype", (Object)"1");
        msgRecordLog.set("operatestatus", (Object)MsgRecordLogStatusEnum.PROCESSING.getCode());
        return msgRecordLog;
    }

    private DynamicObject getPersonSubMsgRecordLog(PersonSubMsgRecordContentBean personSubMsgRecordContentBean, DynamicObject intRelation) {
        DynamicObject msgRecordLog = this.initMsgRecordLog(intRelation);
        DynamicObjectUtils.setBigText((DynamicObject)msgRecordLog, (String)"msgcontent", (String)JSONObject.toJSONString((Object)personSubMsgRecordContentBean));
        msgRecordLog.set("msgnumber", (Object)personSubMsgRecordContentBean.getNumber());
        msgRecordLog.set("msgtype", (Object)"2");
        msgRecordLog.set("operatestatus", (Object)MsgRecordLogStatusEnum.PROCESSING.getCode());
        return msgRecordLog;
    }

    private DynamicObject initMsgRecordLog(DynamicObject intRelation) {
        DynamicObject msgRecordLog = this.generateEmptyDynamicObject();
        Long msgRecordLogId = ID.genLongId();
        msgRecordLog.set("id", (Object)msgRecordLogId);
        msgRecordLog.set("number", (Object)msgRecordLogId.toString());
        msgRecordLog.set("intsource", (Object)intRelation.getDynamicObject("intsource"));
        msgRecordLog.set("sourcesys", (Object)intRelation.getDynamicObject("sourcesys"));
        msgRecordLog.set("operatestatus", (Object)MsgRecordLogStatusEnum.PROCESSING.getCode());
        return msgRecordLog;
    }
}

