/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.monitor.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBizSyncDomainService;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IIntLogEntityService;
import kd.hdtc.hrdi.common.enums.OperateStatusEnum;
import kd.hdtc.hrdi.common.enums.WarnStatusEnum;

public class IntLogDomainServiceImpl
implements IIntLogDomainService {
    private static final Log LOG = LogFactory.getLog(IntLogDomainServiceImpl.class);
    private final IIntLogEntityService iIntLogEntityService = ServiceFactory.getService(IIntLogEntityService.class);
    private final IBizSyncDomainService iBizSyncDomainService = ServiceFactory.getService(IBizSyncDomainService.class);
    private static final String SELECT_COMMON_FIELDS = String.join((CharSequence)",", "id", "number", "intsource", "parent", "batchnumber", "operatestatus", "errorinfo", "errorinfo_tag", "retrycount", "transtarttime", "tranendtime", "lastretrytime", "selectnumber", "selectnumber_tag", "startnumber", "endnumber", "warnstatus");

    @Override
    public void saveIntLog(DynamicObject intLog) {
        this.iIntLogEntityService.save(intLog);
    }

    @Override
    public DynamicObject queryOneById(Long id) {
        return this.iIntLogEntityService.queryOne(SELECT_COMMON_FIELDS, id);
    }

    @Override
    public DynamicObject[] query(String selectProperties, Object[] pks) {
        return this.iIntLogEntityService.query(selectProperties, pks);
    }

    @Override
    public DynamicObject[] queryListByParentIdList(List<Long> parentIntLogList) {
        if (CollectionUtils.isEmpty(parentIntLogList)) {
            return new DynamicObject[0];
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        QFilter parentIdFilter = new QFilter("parent.id", "in", parentIntLogList);
        qFilterList.add(parentIdFilter);
        QFilter statusFilter = new QFilter("operatestatus", "=", (Object)OperateStatusEnum.SERVICE_EXCEPTION.getCode());
        qFilterList.add(statusFilter);
        return this.iIntLogEntityService.query(SELECT_COMMON_FIELDS, qFilterList.toArray(new QFilter[0]));
    }

    @Override
    public DynamicObject[] queryListByNumberList(Collection<String> numberList) {
        if (CollectionUtils.isEmpty(numberList)) {
            return new DynamicObject[0];
        }
        QFilter numberFilter = new QFilter("number", "in", numberList);
        return this.iIntLogEntityService.query(SELECT_COMMON_FIELDS, new QFilter[]{numberFilter});
    }

    @Override
    public Set<Long> queryWithErrorParentIntLogIdList(List<Long> parentIntLogList) {
        if (CollectionUtils.isEmpty(parentIntLogList)) {
            return new HashSet<Long>();
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        QFilter parentIdFilter = new QFilter("parent", "in", parentIntLogList);
        qFilterList.add(parentIdFilter);
        QFilter statusFilter = new QFilter("operatestatus", "=", (Object)OperateStatusEnum.SERVICE_EXCEPTION.getCode());
        qFilterList.add(statusFilter);
        List dynamicObjectList = this.iIntLogEntityService.queryOriginalList("parent", qFilterList.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
            return new HashSet<Long>();
        }
        return dynamicObjectList.stream().map(dy -> dy.getLong("parent")).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIntLog(Long id, String operateStatus, String errorInfo, Date tranEndTime) {
        DynamicObject intLog = this.queryOneById(id);
        if (intLog != null) {
            intLog.set("tranendtime", (Object)tranEndTime);
            if (OperateStatusEnum.ALL_SUCCESS.getCode().equals(operateStatus)) {
                DynamicObjectUtils.setBigText((DynamicObject)intLog, (String)"errorinfo", (String)"");
            } else {
                DynamicObjectUtils.setBigText((DynamicObject)intLog, (String)"errorinfo", (String)errorInfo);
                intLog.set("warnstatus", (Object)WarnStatusEnum.PENDING_WARNING.getCode());
            }
            try (TXHandle txHandle = TX.requiresNew();){
                intLog.set("operatestatus", (Object)operateStatus);
                Object object = this.iIntLogEntityService.save(intLog);
            }
        } else {
            LOG.error("updateIntLog id: {} intLog is null ", (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIntLogWarnStatus(Collection<String> intNumberList, WarnStatusEnum warnStatus) {
        Object[] intLogs = this.queryListByNumberList(intNumberList);
        if (ArrayUtils.isNotEmpty((Object[])intLogs)) {
            Stream.of(intLogs).forEach(dy -> dy.set("warnstatus", (Object)warnStatus.getCode()));
            try (TXHandle txHandle = TX.requiresNew();){
                Object[] objectArray = this.iIntLogEntityService.save((DynamicObject[])intLogs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIntLogRetryCount(DynamicObject intLog) {
        if (intLog != null) {
            intLog.set("retrycount", (Object)(intLog.getLong("retrycount") + 1L));
            intLog.set("lastretrytime", (Object)new Date());
            try (TXHandle txHandle = TX.requiresNew();){
                this.iIntLogEntityService.save(intLog);
            }
        } else {
            LOG.error("updateIntLogRetryCount intLog is null ");
        }
    }

    @Override
    public DynamicObject[] queryNeedRetryIntLogList(QFilter[] qFilters, int pageIndex, int pageSize) {
        return BusinessDataServiceHelper.load((String)"hrdi_intlog", (String)"id,number,batchnumber,intsource,operatestatus,startnumber,endnumber,selectnumber", (QFilter[])qFilters, (String)"id", (int)pageIndex, (int)pageSize);
    }

    @Override
    public void handleIntLogRetry(DynamicObject intLog) {
        long start = System.currentTimeMillis();
        try {
            this.iBizSyncDomainService.bizRetrySync(intLog.getLong("id"), intLog.getDynamicObject("intsource"), intLog.getString("batchnumber"), intLog.getString("startnumber"), intLog.getString("endnumber"), intLog.getString("selectnumber"));
        }
        catch (Exception e) {
            this.updateIntLog(intLog.getLong("id"), OperateStatusEnum.SERVICE_EXCEPTION.getCode(), ThrowableUtils.toString((Throwable)e), new Date());
            LOG.error("handleIntLogRetry  error:", (Throwable)e);
            return;
        }
        LOG.info("handleIntLogRetry  number:{}  end  cast: {} s", (Object)intLog.getString("number"), (Object)((System.currentTimeMillis() - start) / 1000L));
    }
}

