/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.monitor.impl;

import java.util.Collection;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IIntWarnLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IIntWarnLogEntityService;

public class IntWarnLogDomainServiceImpl
implements IIntWarnLogDomainService {
    private static final Log LOG = LogFactory.getLog(IntWarnLogDomainServiceImpl.class);
    private final IIntWarnLogEntityService iIntWarnLogEntityService = ServiceFactory.getService(IIntWarnLogEntityService.class);
    private static final String SELECT_COMMON_FIELDS = String.join((CharSequence)",", "id", "batchnumber", "intnumber", "intnumber_tag", "warninfo", "warninfo_tag");

    @Override
    public DynamicObject generateIntWarnLog(Collection<String> intLogNumberList, String batchNumber) {
        if (StringUtils.isNotEmpty((String)batchNumber) && CollectionUtils.isNotEmpty(intLogNumberList)) {
            DynamicObject intWarnLog = this.iIntWarnLogEntityService.generateEmptyDynamicObject();
            long id = ID.genLongId();
            intWarnLog.set("id", (Object)id);
            intWarnLog.set("batchnumber", (Object)ID.genLongId());
            DynamicObjectUtils.setBigText((DynamicObject)intWarnLog, (String)"intnumber", (String)String.join((CharSequence)",", intLogNumberList));
            return intWarnLog;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult saveIntWarnLog(DynamicObject intWarnLog) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrdi_intwarnlog", (DynamicObject[])new DynamicObject[]{intWarnLog}, (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence[])new CharSequence[]{operationResult.getMessage()}) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u9884\u8b66\u65e5\u5fd7\u5931\u8d25\u3002", (String)"IntWarnLogDomainServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    @Override
    public DynamicObject queryOneById(Long id) {
        return this.iIntWarnLogEntityService.queryOne(SELECT_COMMON_FIELDS, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIntWarnLog(Long id, String warnInfo) {
        DynamicObject intWarnLog = this.queryOneById(id);
        if (intWarnLog != null) {
            DynamicObjectUtils.setBigText((DynamicObject)intWarnLog, (String)"warninfo", (String)String.join((CharSequence)",", warnInfo));
            try (TXHandle txHandle = TX.requiresNew();){
                Object object = this.iIntWarnLogEntityService.save(intWarnLog);
            }
        } else {
            LOG.error("updateIntWarnLog id: {} intWarnLog is null ", (Object)id);
        }
    }
}

