/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.monitor.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.application.external.ICommonIntDomainService;
import kd.hdtc.hrdi.business.application.external.IPersonDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBasicCommonIntDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.monitor.IMsgRecordLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.bean.EventMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.bean.PersonSubMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;

public class MsgRecordLogDomainServiceImpl
implements IMsgRecordLogDomainService {
    private static final Log LOG = LogFactory.getLog(MsgRecordLogDomainServiceImpl.class);
    private final IMsgRecordLogEntityService msgRecordLogEntityService = ServiceFactory.getService(IMsgRecordLogEntityService.class);
    private final IIntRelationDomainService iIntRelationDomainService = ServiceFactory.getService(IIntRelationDomainService.class);
    private final IBasicCommonIntDomainService basicCommonIntDomainService = ServiceFactory.getService(IBasicCommonIntDomainService.class);
    private final ICommonIntDomainService iCommonIntDomainService = ServiceFactory.getService(ICommonIntDomainService.class);
    private final IPersonDomainService personDomainService = ServiceFactory.getService(IPersonDomainService.class);

    @Override
    public void handleMsgRecordLogRetry(DynamicObject msgRecordLog) {
        DynamicObject[] intRelations;
        String msgType = msgRecordLog.getString("msgtype");
        String msgContent = DynamicObjectUtils.getBigText((DynamicObject)msgRecordLog, (String)"msgcontent");
        for (DynamicObject intRelation : intRelations = this.iIntRelationDomainService.queryEnableData("2", msgRecordLog.getLong("intsource.id"), msgRecordLog.getLong("sourcesys.id"))) {
            String errorInfo;
            boolean exception = false;
            try {
                errorInfo = this.doOutIntHandle(msgType, msgContent, intRelation);
            }
            catch (Exception e) {
                errorInfo = ThrowableUtils.toString((Throwable)e);
                LOG.error("doOutIntHandle error, errorInfo:{}", (Object)errorInfo);
                exception = true;
            }
            this.msgRecordLogEntityService.updateEventMsgRecordLogStatus(msgRecordLog.getLong("id"), errorInfo, exception);
        }
    }

    private String doOutIntHandle(String msgType, String msgContent, DynamicObject intRelation) {
        String errorInfo = "";
        switch (msgType) {
            case "1": {
                EventMsgRecordContentBean eventMsgRecordContentBean = (EventMsgRecordContentBean)JSONObject.parseObject((String)msgContent, EventMsgRecordContentBean.class);
                errorInfo = this.basicCommonIntDomainService.basicOutIntHandle(intRelation, eventMsgRecordContentBean.getEntityNumber(), eventMsgRecordContentBean.getBusinessKeys(), eventMsgRecordContentBean.getOperation());
                break;
            }
            case "2": {
                PersonSubMsgRecordContentBean personSubMsgRecordContentBean = (PersonSubMsgRecordContentBean)JSONObject.parseObject((String)msgContent, PersonSubMsgRecordContentBean.class);
                String entityNumber = personSubMsgRecordContentBean.getEntityNumber();
                if ("hrpi_emp_integrate".equals(entityNumber)) {
                    errorInfo = this.personDomainService.personMainOutInt(personSubMsgRecordContentBean.getFourFloorPersonIdEntry(), personSubMsgRecordContentBean.isDelete(), personSubMsgRecordContentBean.getCaller(), personSubMsgRecordContentBean.getVariationType(), personSubMsgRecordContentBean.getChangePersonEntityList(), intRelation);
                    break;
                }
                errorInfo = this.personDomainService.personAttachOutInt(personSubMsgRecordContentBean.getIdList(), personSubMsgRecordContentBean.isDelete(), personSubMsgRecordContentBean.getCaller(), intRelation);
                break;
            }
            case "3": {
                errorInfo = this.iCommonIntDomainService.outCommonIntHandle(msgContent, intRelation);
                break;
            }
        }
        return errorInfo;
    }
}

