/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.monitor.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.common.enums.OperateStatusEnum;

public class IntLogRetryTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(IntLogRetryTask.class);
    private final IIntLogDomainService iIntLogDomainService = ServiceFactory.getService(IIntLogDomainService.class);
    protected final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    private static final int PAGE_SIZE = 100;
    private static final int MS_TIMEOUT = 10000;
    private final DLock lock = DLock.create((String)"IntLogRetryTask", (String)ResManager.loadKDString((String)"\u96c6\u6210\u65e5\u5fd7\u91cd\u8bd5\u64cd\u4f5c\u8c03\u5ea6\u4efb\u52a1", (String)"IntLogRetryTask_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (this.lock.tryLock(10000L)) {
            try {
                long start = System.currentTimeMillis();
                LOG.info("IntLogRetryTask start  map: {}", map);
                QFilter[] qFilters = this.buildQFilter();
                int count = this.iBaseCommonDomainService.count("hrdi_intlog", qFilters);
                int pageCount = (int)Math.ceil((double)count / 100.0);
                for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                    Object[] intLogs = this.iIntLogDomainService.queryNeedRetryIntLogList(qFilters, pageIndex, 100);
                    if (!ArrayUtils.isNotEmpty((Object[])intLogs)) continue;
                    Stream.of(intLogs).forEach(this.iIntLogDomainService::handleIntLogRetry);
                }
                LOG.info("IntLogRetryTask end  cast: {} s", (Object)((System.currentTimeMillis() - start) / 1000L));
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private QFilter[] buildQFilter() {
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)16);
        QFilter parentFilter = new QFilter("parent", "is not null", null);
        qFilters.add(parentFilter);
        QFilter operateStatusFilter = new QFilter("operatestatus", "=", (Object)OperateStatusEnum.SERVICE_EXCEPTION.getCode());
        qFilters.add(operateStatusFilter);
        Date date = DateTimeUtils.addMinute((Date)new Date(), (long)-5L);
        QFilter lastRetryTimeFilter1 = new QFilter("operatestatus", "<=", (Object)date);
        QFilter lastRetryTimeFilter2 = new QFilter("operatestatus", "is null", null);
        QFilter lastRetryTimeFilter = lastRetryTimeFilter1.or(lastRetryTimeFilter2);
        qFilters.add(lastRetryTimeFilter);
        QFilter retryCountFilter = new QFilter("retrycount", "<=", (Object)10);
        qFilters.add(retryCountFilter);
        return qFilters.toArray(new QFilter[0]);
    }
}

