/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.queryapi.bo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryApiEntityInfoParseBo;
import kd.hdtc.hrdi.common.queryapi.model.QueryFieldModel;

public class QueryApiConfigBo {
    private static final Log LOG = LogFactory.getLog(QueryApiConfigBo.class);
    private static final String HRDI_DATA_CONVERT_ID = "HRDI_DATA_CONVERT_ID";
    private final String queryConfigNumber;
    private final String queryConfigType;
    private Map<String, QueryFieldModel> fieldAliasAndQueryFieldModelMap;
    private List<String> queryFieldNumberList;
    private List<OrderFieldInfo> orderFieldInfoList;
    private List<QueryFieldModel> queryFieldModelList = Lists.newArrayListWithExpectedSize((int)16);
    private Map<String, QueryFieldModel> fullFieldNumberAndQueryFieldModelMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Set<Object>> entityNumberAndIdSetMap = Maps.newHashMapWithExpectedSize((int)16);
    Map<String, Set<String>> entityNumberAndFieldNumberSetMap = Maps.newHashMapWithExpectedSize((int)16);
    Map<String, Map<String, MulBaseDataValueCovertInfo>> resultMapIdAndMulBaseDataValueCovertInfoMap = Maps.newHashMapWithExpectedSize((int)16);
    private final DynamicObject queryApiConfig;
    private String selectProperty;
    private String orderBy;
    private Integer pageIndex;
    private Integer pageSize;
    private Integer start;
    private Integer limit;
    private IBaseCommonDomainService iBaseCommonDomainService;

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getSelectProperty() {
        return this.selectProperty;
    }

    public QueryApiConfigBo(DynamicObject queryApiConfig, IBaseCommonDomainService iBaseCommonDomainService) {
        this.iBaseCommonDomainService = iBaseCommonDomainService;
        this.queryApiConfig = queryApiConfig;
        this.queryConfigNumber = queryApiConfig.getString("queryconfignumber");
        this.queryConfigType = queryApiConfig.getString("queryconfigtype");
        this.init();
    }

    public void parsePageParam(String limitAndOffsetStr, String limitMaxStr, Map<String, Object> params) {
        if (StringUtils.isNotEmpty((String)limitMaxStr)) {
            this.limit = Integer.parseInt(limitMaxStr);
        }
        if (StringUtils.isNotEmpty((String)limitAndOffsetStr)) {
            String offSetName;
            Object offSetObj;
            int limitParam;
            String[] limitAndOffset = limitAndOffsetStr.split(",");
            String limitName = limitAndOffset[0];
            Object limitObj = params.get(limitName);
            if (!ObjectUtils.isEmpty((Object)limitObj) && (limitParam = Integer.parseInt(limitObj.toString())) < this.limit) {
                this.limit = limitParam;
            }
            if (!ObjectUtils.isEmpty((Object)(offSetObj = params.get(offSetName = limitAndOffset[1])))) {
                this.start = Integer.parseInt(offSetObj.toString());
            }
        }
        this.pageIndex = this.start / this.limit;
        this.pageSize = this.limit;
    }

    private void init() {
        this.pageIndex = 0;
        this.pageSize = 1000;
        this.start = 0;
        this.limit = 1000;
        QueryApiEntityInfoParseBo queryApiEntityInfoParseBo = new QueryApiEntityInfoParseBo(this.queryApiConfig);
        QueryEntityType queryEntityType = queryApiEntityInfoParseBo.getQueryEntityType();
        queryApiEntityInfoParseBo.getQueryEntityModelList(queryEntityType);
        this.queryFieldModelList = queryApiEntityInfoParseBo.getQueryFieldModelList();
        this.queryFieldModelList.forEach(queryFieldModel -> this.fullFieldNumberAndQueryFieldModelMap.put(queryFieldModel.getFullFieldNumber(), (QueryFieldModel)queryFieldModel));
        DynamicObjectCollection queryEntryCollection = this.queryApiConfig.getDynamicObjectCollection("queryentryentity");
        this.fieldAliasAndQueryFieldModelMap = Maps.newHashMapWithExpectedSize((int)queryEntryCollection.size());
        this.queryFieldNumberList = Lists.newArrayListWithExpectedSize((int)queryEntryCollection.size());
        queryEntryCollection.forEach(queryEntry -> {
            QueryFieldModel queryField = new QueryFieldModel();
            queryField.setValueType(queryEntry.getString("fieldvaluetype"));
            queryField.setFieldType(queryEntry.getString("fieldtype"));
            queryField.setFieldName(queryEntry.getString("fieldname"));
            queryField.setFieldAlias(queryEntry.getString("fieldalias"));
            queryField.setFieldNumber(queryEntry.getString("fieldnumber"));
            queryField.setEntityNumber(queryEntry.getString("queryentitynumber"));
            queryField.setEntityName(queryEntry.getString("queryentityname"));
            queryField.setFullFieldNumber(queryEntry.getString("fullfieldnumber"));
            queryField.setQueryFieldNumber(queryField.getFieldNumber());
            String comboItemStr = queryEntry.getString("comboitemmap");
            if (StringUtils.isNotEmpty((String)comboItemStr)) {
                List comboItemList = JSONObject.parseArray((String)comboItemStr, JSONObject.class);
                queryField.setComboItemList(comboItemList);
            }
            this.queryFieldNumberList.add(queryField.getQueryFieldNumber());
            this.fieldAliasAndQueryFieldModelMap.put(queryField.getFieldAlias(), queryField);
        });
        DynamicObjectCollection orderEntryCollection = this.queryApiConfig.getDynamicObjectCollection("orderentryentity");
        this.orderFieldInfoList = Lists.newArrayListWithExpectedSize((int)orderEntryCollection.size());
        ArrayList orderRuleList = Lists.newArrayListWithExpectedSize((int)orderEntryCollection.size());
        orderEntryCollection.forEach(orderEntry -> {
            OrderFieldInfo orderFieldInfo = new OrderFieldInfo(orderEntry.getString("orderfieldnumber"), orderEntry.getString("orderrule"));
            orderRuleList.add(orderFieldInfo.getFieldNumber() + " " + orderFieldInfo.getOrderRule());
            this.orderFieldInfoList.add(orderFieldInfo);
        });
        this.orderBy = CollectionUtils.isEmpty((Collection)orderRuleList) ? "id" : String.join((CharSequence)",", orderRuleList);
        this.selectProperty = String.join((CharSequence)",", this.queryFieldNumberList);
    }

    private Set<Object> getBaseDataIds(String baseDataNumber, Object value) {
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        if (ObjectUtils.isEmpty((Object)value)) {
            return idSet;
        }
        String[] ids = value.toString().split(",");
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)baseDataNumber);
        String simpleName = mainEntityType.getPrimaryKey().getPropertyType().getSimpleName();
        if ("long".equals(simpleName)) {
            Stream.of(ids).forEach(id -> idSet.add(Long.parseLong(id)));
        } else {
            idSet.addAll(Arrays.asList(ids));
        }
        return idSet;
    }

    private String getCurrentEntityQueryFieldNumber(String queryFieldNumber, String entityNumber) {
        String prefix = entityNumber + ".";
        if (queryFieldNumber.startsWith(prefix)) {
            return queryFieldNumber.substring(prefix.length());
        }
        return queryFieldNumber;
    }

    public List<Map<String, Object>> parseQueryResult(DataSet queryDataSet) {
        long start = System.currentTimeMillis();
        ArrayList resultMapList = Lists.newArrayListWithExpectedSize((int)16);
        while (queryDataSet.hasNext()) {
            Row row = queryDataSet.next();
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.fieldAliasAndQueryFieldModelMap.size());
            String resultMapId = ID.genStringId();
            resultMap.put(HRDI_DATA_CONVERT_ID, resultMapId);
            HashMap fieldAliasAndMulBaseDataValueCovertInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            this.fieldAliasAndQueryFieldModelMap.forEach((fieldAlias, queryFieldModel) -> {
                Object value = row.get(queryFieldModel.getQueryFieldNumber());
                resultMap.put(fieldAlias, value);
                MulBaseDataValueCovertInfo mulBaseDataValueCovertInfo = this.buildBaseDataConvertInfo((String)fieldAlias, (QueryFieldModel)queryFieldModel, value);
                if (mulBaseDataValueCovertInfo != null) {
                    fieldAliasAndMulBaseDataValueCovertInfoMap.put(fieldAlias, mulBaseDataValueCovertInfo);
                }
            });
            this.resultMapIdAndMulBaseDataValueCovertInfoMap.put(resultMapId, fieldAliasAndMulBaseDataValueCovertInfoMap);
            resultMapList.add(resultMap);
        }
        queryDataSet.close();
        LOG.info("queryApi parseQueryResult where end cost {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
        Map<String, Map<Object, DynamicObject>> entityNumberAndDataMap = this.getEntityNumberAndDataMap(this.entityNumberAndIdSetMap, this.entityNumberAndFieldNumberSetMap);
        this.assembleResult(resultMapList, this.resultMapIdAndMulBaseDataValueCovertInfoMap, entityNumberAndDataMap);
        LOG.info("queryApi parseQueryResult cost {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
        return resultMapList;
    }

    private void assembleResult(List<Map<String, Object>> resultMapList, Map<String, Map<String, MulBaseDataValueCovertInfo>> resultMapIdAndMulBaseDataValueCovertInfoMap, Map<String, Map<Object, DynamicObject>> entityNumberAndDataMap) {
        resultMapList.forEach(resultMap -> {
            Map mulBaseDataValueCovertInfoMap = (Map)resultMapIdAndMulBaseDataValueCovertInfoMap.get(resultMap.get(HRDI_DATA_CONVERT_ID));
            if (CollectionUtils.isNotEmpty((Map)mulBaseDataValueCovertInfoMap)) {
                mulBaseDataValueCovertInfoMap.forEach((fieldAlias, mbvci) -> {
                    Set<Object> idSet = mbvci.getIdSet();
                    Map idAndDyMap = (Map)entityNumberAndDataMap.get(mbvci.getEntityNumber());
                    String queryFieldNumber = mbvci.getQueryFieldNumber();
                    int markerIndex = queryFieldNumber.indexOf(".");
                    String entityField = queryFieldNumber.substring(0, markerIndex);
                    String valueField = queryFieldNumber.substring(markerIndex + 1);
                    ArrayList valueList = Lists.newArrayListWithExpectedSize((int)idSet.size());
                    idSet.forEach(id -> {
                        DynamicObject dy = (DynamicObject)idAndDyMap.get(id);
                        if (dy != null) {
                            DynamicObjectCollection collection = dy.getDynamicObjectCollection(entityField);
                            collection.forEach(dd -> {
                                DynamicObject baseData = dd.getDynamicObject("fbasedataid");
                                if (baseData != null) {
                                    Object value = baseData.get(valueField);
                                    if (value instanceof ILocaleString) {
                                        value = ((ILocaleString)value).getLocaleValue();
                                    }
                                    if (!ObjectUtils.isEmpty((Object)value)) {
                                        valueList.add(value.toString());
                                    }
                                }
                            });
                        }
                    });
                    resultMap.put(fieldAlias, String.join((CharSequence)",", valueList));
                });
            }
            resultMap.remove(HRDI_DATA_CONVERT_ID);
        });
    }

    private Map<String, Map<Object, DynamicObject>> getEntityNumberAndDataMap(Map<String, Set<Object>> entityNumberAndIdSetMap, Map<String, Set<String>> entityNumberAndFieldNumberSetMap) {
        HashMap entityNumberAndDataMap = Maps.newHashMapWithExpectedSize((int)16);
        entityNumberAndIdSetMap.forEach((entityNumber, idSet) -> {
            Set queryFieldNumberSet = (Set)entityNumberAndFieldNumberSetMap.get(entityNumber);
            if (CollectionUtils.isNotEmpty((Collection)queryFieldNumberSet)) {
                String selectProperties = String.join((CharSequence)",", queryFieldNumberSet);
                Map<Object, DynamicObject> idAndDyMap = this.iBaseCommonDomainService.queryDataByIdList((String)entityNumber, selectProperties, (Collection<Object>)idSet);
                entityNumberAndDataMap.put(entityNumber, idAndDyMap);
            }
        });
        return entityNumberAndDataMap;
    }

    private MulBaseDataValueCovertInfo buildBaseDataConvertInfo(String fieldAlias, QueryFieldModel queryFieldModel, Object value) {
        if (!ObjectUtils.isEmpty((Object)value)) {
            String fullFieldNumber = queryFieldModel.getFullFieldNumber();
            QueryFieldModel fieldModel = this.fullFieldNumberAndQueryFieldModelMap.get(fullFieldNumber);
            if (!ObjectUtils.isEmpty((Object)value) && fieldModel != null && "MulBasedataProp".equals(fieldModel.getBelongComplexFieldType())) {
                Set idSet = this.entityNumberAndIdSetMap.getOrDefault(fieldModel.getBaseEntityName(), new HashSet());
                Set<Object> baseDataIds = this.getBaseDataIds(fieldModel.getBaseEntityName(), value);
                idSet.addAll(baseDataIds);
                this.entityNumberAndIdSetMap.put(fieldModel.getEntityNumber(), idSet);
                MulBaseDataValueCovertInfo mbvci = new MulBaseDataValueCovertInfo();
                mbvci.setFieldAlias(fieldAlias);
                mbvci.setEntityNumber(fieldModel.getEntityNumber());
                mbvci.setIdSet(idSet);
                String currentEntityQueryFieldNumber = this.getCurrentEntityQueryFieldNumber(fieldModel.getQueryFieldNumber(), fieldModel.getEntityNumber());
                mbvci.setQueryFieldNumber(currentEntityQueryFieldNumber);
                Set fieldNumberSet = this.entityNumberAndFieldNumberSetMap.getOrDefault(fieldModel.getEntityNumber(), new HashSet());
                fieldNumberSet.add(currentEntityQueryFieldNumber);
                this.entityNumberAndFieldNumberSetMap.put(fieldModel.getEntityNumber(), fieldNumberSet);
                return mbvci;
            }
        }
        return null;
    }

    public String getQueryConfigNumber() {
        return this.queryConfigNumber;
    }

    public String getQueryConfigType() {
        return this.queryConfigType;
    }

    public Map<String, QueryFieldModel> getFieldAliasAndQueryFieldModelMap() {
        return this.fieldAliasAndQueryFieldModelMap;
    }

    public List<String> getQueryFieldNumberList() {
        return this.queryFieldNumberList;
    }

    public List<OrderFieldInfo> getOrderFieldInfoList() {
        return this.orderFieldInfoList;
    }

    static class OrderFieldInfo {
        private String fieldNumber;
        private String orderRule;

        public String getFieldNumber() {
            return this.fieldNumber;
        }

        public String getOrderRule() {
            return this.orderRule;
        }

        public OrderFieldInfo(String fieldNumber, String orderRule) {
            this.fieldNumber = fieldNumber;
            this.orderRule = orderRule;
        }
    }

    static class MulBaseDataValueCovertInfo {
        private String fieldAlias;
        private String queryFieldNumber;
        private Set<Object> idSet;
        private String entityNumber;

        MulBaseDataValueCovertInfo() {
        }

        public String getQueryFieldNumber() {
            return this.queryFieldNumber;
        }

        public void setQueryFieldNumber(String queryFieldNumber) {
            this.queryFieldNumber = queryFieldNumber;
        }

        public Set<Object> getIdSet() {
            return this.idSet;
        }

        public void setIdSet(Set<Object> idSet) {
            this.idSet = idSet;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public String getFieldAlias() {
            return this.fieldAlias;
        }

        public void setFieldAlias(String fieldAlias) {
            this.fieldAlias = fieldAlias;
        }
    }
}

