/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.queryapi.bo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.common.queryapi.model.QueryEntityModel;
import kd.hdtc.hrdi.common.queryapi.model.QueryFieldModel;

public class QueryApiEntityInfoParseBo {
    private static final Log LOG = LogFactory.getLog(QueryApiEntityInfoParseBo.class);
    private DynamicObject queryApiConfig;
    private DynamicObject mainEntity;
    private DynamicObjectCollection relEntryEntity;
    private List<QueryEntityModel> queryEntityModelList = Lists.newArrayListWithExpectedSize((int)16);
    private List<QueryFieldModel> queryFieldModelList = Lists.newArrayListWithExpectedSize((int)16);
    Map<String, List<TreeNode>> entityNumberAndFieldTreeNodeListMap = Maps.newHashMapWithExpectedSize((int)16);

    public QueryApiEntityInfoParseBo(DynamicObject queryApiConfig) {
        this.queryApiConfig = queryApiConfig;
        this.mainEntity = queryApiConfig.getDynamicObject("mainentityobj");
        this.relEntryEntity = queryApiConfig.getDynamicObjectCollection("relentryentity");
    }

    public QueryEntityType getQueryEntityType() {
        if (this.mainEntity == null) {
            return null;
        }
        String entityType = this.queryApiConfig.getString("queryconfigtype");
        if (StringUtils.equals((String)"2", (String)entityType)) {
            MainEntityType queryEntityType = MetadataUtils.getMainEntityType((String)this.mainEntity.getString("number"));
            return (QueryEntityType)queryEntityType;
        }
        return null;
    }

    public List<QueryEntityModel> getQueryEntityModelList(QueryEntityType queryEntityType) {
        ArrayList queryEntityModelList = Lists.newArrayListWithCapacity((int)16);
        if (this.mainEntity == null) {
            return queryEntityModelList;
        }
        QueryEntityModel mainEntityModel = QueryApiEntityInfoParseBo.buildQueryEntityModel(this.mainEntity, true, queryEntityType);
        queryEntityModelList.add(mainEntityModel);
        HashSet entityNumberSet = Sets.newHashSetWithExpectedSize((int)this.relEntryEntity.size());
        entityNumberSet.add(mainEntityModel.getEntityNumber());
        if (CollectionUtils.isNotEmpty((Collection)this.relEntryEntity)) {
            for (DynamicObject dynObj : this.relEntryEntity) {
                DynamicObject rightEntity;
                DynamicObject leftEntity = dynObj.getDynamicObject("leftentityobj");
                if (leftEntity != null && !entityNumberSet.contains(leftEntity.getString("number"))) {
                    queryEntityModelList.add(QueryApiEntityInfoParseBo.buildQueryEntityModel(leftEntity, false, null));
                    entityNumberSet.add(leftEntity.getString("number"));
                }
                if ((rightEntity = dynObj.getDynamicObject("rightentityobj")) == null || entityNumberSet.contains(rightEntity.getString("number"))) continue;
                queryEntityModelList.add(QueryApiEntityInfoParseBo.buildQueryEntityModel(rightEntity, false, null));
                entityNumberSet.add(rightEntity.getString("number"));
            }
        }
        this.queryEntityModelList = queryEntityModelList;
        this.getQueryFieldList();
        return queryEntityModelList;
    }

    private void getQueryFieldList() {
        LinkedHashMap entityNumberAndFieldTreeNodeListMap = Maps.newLinkedHashMapWithExpectedSize((int)this.queryEntityModelList.size());
        ArrayList queryFieldModelList = Lists.newArrayListWithExpectedSize((int)16);
        for (QueryEntityModel queryEntityModel : this.queryEntityModelList) {
            Map allEntities;
            List fieldNumberList = MetadataUtils.getFieldNumberList((String)queryEntityModel.getEntityNumber());
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)queryEntityModel.getEntityNumber());
            if (mainEntityType instanceof QueryEntityType || CollectionUtils.isEmpty((Map)(allEntities = mainEntityType.getAllEntities()))) continue;
            ArrayList fieldTreeNodeList = Lists.newArrayListWithExpectedSize((int)16);
            allEntities.forEach((entryKey, entityType) -> {
                String queryFieldNumberPrefix;
                String fullFieldNumberPrefix = queryEntityModel.getEntityNumber() + ".";
                String fullFieldNamePrefix = queryEntityModel.getEntityName() + ".";
                String string = queryFieldNumberPrefix = queryEntityModel.getMainEntity() != false ? "" : queryEntityModel.getEntityNumber() + ".";
                if (entityType instanceof EntryType) {
                    TreeNode entryFieldTreeNode = this.getEntryFieldTreeNode(queryFieldModelList, queryEntityModel, (EntryType)entityType, fieldNumberList);
                    fieldTreeNodeList.add(entryFieldTreeNode);
                } else {
                    QueryFieldModel idQueryFieldModel = this.getIdQueryFieldModel((IDataEntityType)entityType, queryEntityModel, fullFieldNumberPrefix, queryFieldNumberPrefix, fullFieldNamePrefix);
                    queryFieldModelList.add(idQueryFieldModel);
                    TreeNode idTreeNode = this.buildFieldTreeNode(queryEntityModel.getEntityNumber(), idQueryFieldModel);
                    fieldTreeNodeList.add(idTreeNode);
                    List<TreeNode> treeNodeList = this.buildQueryFieldInfoList(queryEntityModel.getEntityNumber(), queryFieldModelList, queryEntityModel, fieldNumberList, (EntityType)entityType, fullFieldNumberPrefix, queryFieldNumberPrefix, fullFieldNamePrefix);
                    fieldTreeNodeList.addAll(treeNodeList);
                }
            });
            entityNumberAndFieldTreeNodeListMap.put(queryEntityModel.getEntityNumber(), fieldTreeNodeList);
        }
        this.queryFieldModelList = queryFieldModelList;
        this.entityNumberAndFieldTreeNodeListMap = entityNumberAndFieldTreeNodeListMap;
    }

    private TreeNode buildFieldTreeNode(String parentId, QueryFieldModel queryFieldModel) {
        TreeNode treeNode = new TreeNode(parentId, queryFieldModel.getFullFieldNumber(), queryFieldModel.getFieldName());
        treeNode.setIsOpened(false);
        return treeNode;
    }

    private List<TreeNode> buildQueryFieldInfoList(String parentId, List<QueryFieldModel> queryFieldModelList, QueryEntityModel queryEntityModel, List<String> fieldNumberList, EntityType entityType, String fullFieldNumberPrefix, String queryFieldNumberPrefix, String fullFieldNamePrefix) {
        Map fields = entityType.getFields();
        ArrayList fieldTreeNodeList = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (Map.Entry entry : fields.entrySet()) {
            if (StringUtils.isEmpty((String)((IDataEntityProperty)entry.getValue()).getAlias())) continue;
            if (entry.getValue() instanceof BasedataProp || entry.getValue() instanceof MulBasedataProp) {
                TreeNode baseDataFieldTreeNode = this.getBaseDataFieldTreeNode(queryFieldModelList, queryEntityModel, parentId, fullFieldNumberPrefix, queryFieldNumberPrefix, fullFieldNamePrefix, (IDataEntityProperty)entry.getValue(), true);
                fieldTreeNodeList.add(baseDataFieldTreeNode);
                continue;
            }
            if (!fieldNumberList.contains(entry.getKey()) || !StringUtils.isNotEmpty((String)((IDataEntityProperty)entry.getValue()).getAlias())) continue;
            QueryFieldModel queryFieldModel = this.getQueryFieldModel((IDataEntityProperty)entry.getValue());
            if (queryFieldModel != null) {
                queryFieldModel.setEntityNumber(queryEntityModel.getEntityNumber());
                queryFieldModel.setEntityName(queryEntityModel.getEntityName());
                queryFieldModel.setFullFieldNumber(fullFieldNumberPrefix + (String)entry.getKey());
                queryFieldModel.setFullFieldName(fullFieldNamePrefix + ((IDataEntityProperty)entry.getValue()).getDisplayName().getLocaleValue());
                queryFieldModel.setQueryFieldNumber(queryFieldNumberPrefix + (String)entry.getKey());
                TreeNode treeNode = this.buildFieldTreeNode(parentId, queryFieldModel);
                fieldTreeNodeList.add(treeNode);
                queryFieldModelList.add(queryFieldModel);
                continue;
            }
            LOG.info("entityNumber:{},fieldNumber:{} is not DisplayName", (Object)queryEntityModel.getEntityNumber(), (Object)((IDataEntityProperty)entry.getValue()).getName());
        }
        return fieldTreeNodeList;
    }

    private TreeNode getBaseDataFieldTreeNode(List<QueryFieldModel> queryFieldModelList, QueryEntityModel queryEntityModel, String parentId, String fullFieldNumberPrefix, String queryFieldNumberPrefix, String fullFieldNamePrefix, IDataEntityProperty baseDataProperty, boolean buildBasedata) {
        TreeNode treeNode = new TreeNode(parentId, fullFieldNumberPrefix + baseDataProperty.getName(), baseDataProperty.getDisplayName().getLocaleValue());
        treeNode.setIsOpened(true);
        QueryFieldModel queryField = this.buildBaseDataQueryFieldModel(queryEntityModel, fullFieldNumberPrefix, queryFieldNumberPrefix, fullFieldNamePrefix, baseDataProperty);
        queryFieldModelList.add(queryField);
        Map fields = ((MainEntityType)this.getBaseComplexType(baseDataProperty)).getFields();
        String currentFullFieldNumberPrefix = fullFieldNumberPrefix + baseDataProperty.getName() + ".";
        String currentQueryFieldNumberPrefix = queryFieldNumberPrefix + baseDataProperty.getName() + ".";
        String currentQueryFullFieldNamePrefix = fullFieldNamePrefix + baseDataProperty.getDisplayName().getLocaleValue() + ".";
        boolean mulBaseData = this.isMulBaseData(baseDataProperty);
        ArrayList childNodes = Lists.newArrayListWithExpectedSize((int)fields.size());
        QueryFieldModel idQueryFieldModel = this.getIdQueryFieldModel(this.getBaseComplexType(baseDataProperty), queryEntityModel, currentFullFieldNumberPrefix, currentQueryFieldNumberPrefix, currentQueryFullFieldNamePrefix);
        idQueryFieldModel.setBaseEntityName(queryField.getBaseEntityName());
        idQueryFieldModel.setBelongComplexFieldType(queryField.getFieldType());
        idQueryFieldModel.setBelongQueryField("id");
        this.setQueryFieldModelType(mulBaseData, idQueryFieldModel);
        queryFieldModelList.add(idQueryFieldModel);
        TreeNode idTreeNode = this.buildFieldTreeNode(treeNode.getId(), idQueryFieldModel);
        childNodes.add(idTreeNode);
        fields.forEach((fieldNumber, propType) -> {
            if (propType instanceof BasedataProp && buildBasedata) {
                TreeNode baseDataFieldTreeNode = this.getBaseDataFieldTreeNode(queryFieldModelList, queryEntityModel, parentId, currentFullFieldNumberPrefix, currentQueryFieldNumberPrefix, currentQueryFullFieldNamePrefix, (IDataEntityProperty)propType, false);
                childNodes.add(baseDataFieldTreeNode);
            } else {
                QueryFieldModel queryFieldModel = this.getQueryFieldModel((IDataEntityProperty)propType);
                if (queryFieldModel != null) {
                    this.setQueryFieldModelType(mulBaseData, queryFieldModel);
                    queryFieldModel.setEntityNumber(queryEntityModel.getEntityNumber());
                    queryFieldModel.setEntityName(queryEntityModel.getEntityName());
                    queryFieldModel.setFullFieldNumber(currentFullFieldNumberPrefix + propType.getName());
                    queryFieldModel.setFullFieldName(currentQueryFullFieldNamePrefix + propType.getDisplayName().getLocaleValue());
                    queryFieldModel.setQueryFieldNumber(currentQueryFieldNumberPrefix + propType.getName());
                    queryFieldModel.setBaseEntityName(queryField.getBaseEntityName());
                    queryFieldModel.setBelongComplexFieldType(queryField.getFieldType());
                    queryFieldModel.setBelongQueryField(propType.getName());
                    TreeNode fieldTreeNode = this.buildFieldTreeNode(treeNode.getId(), queryFieldModel);
                    childNodes.add(fieldTreeNode);
                    queryFieldModelList.add(queryFieldModel);
                } else {
                    LOG.info("entityNumber:{},baseDataFieldNumber:{},fieldNumber:{} is not DisplayName or not table field ", new Object[]{queryEntityModel.getEntityNumber(), baseDataProperty.getName(), propType.getName()});
                }
            }
        });
        treeNode.setChildren((List)childNodes);
        return treeNode;
    }

    private IDataEntityType getBaseComplexType(IDataEntityProperty baseDataProperty) {
        if (baseDataProperty instanceof BasedataProp) {
            return ((BasedataProp)baseDataProperty).getComplexType();
        }
        return ((MulBasedataProp)baseDataProperty).getComplexType();
    }

    private void setQueryFieldModelType(boolean isMulBaseData, QueryFieldModel queryFieldModel) {
        if (isMulBaseData) {
            queryFieldModel.setFieldType(TextProp.class.getSimpleName());
            queryFieldModel.setValueType(String.class.getSimpleName());
        }
    }

    private boolean isMulBaseData(IDataEntityProperty baseDataProperty) {
        return baseDataProperty instanceof MulBasedataProp;
    }

    private QueryFieldModel buildBaseDataQueryFieldModel(QueryEntityModel queryEntityModel, String fullFieldNumberPrefix, String queryFieldNumberPrefix, String fullFieldNamePrefix, IDataEntityProperty baseDataProperty) {
        QueryFieldModel queryField = new QueryFieldModel();
        String simpleName = this.getBaseComplexType(baseDataProperty).getPrimaryKey().getPropertyType().getSimpleName();
        String valueType = String.class.getSimpleName();
        if ("long".equals(simpleName)) {
            valueType = Long.class.getSimpleName();
        }
        queryField.setValueType(valueType);
        queryField.setFieldName(baseDataProperty.getDisplayName().getLocaleValue());
        queryField.setFieldNumber(baseDataProperty.getName());
        queryField.setComplexType(true);
        if (baseDataProperty instanceof BasedataProp) {
            queryField.setFieldType("BasedataProp");
            queryField.setBaseEntityName(((BasedataProp)baseDataProperty).getBaseEntityId());
        } else {
            queryField.setFieldType("MulBasedataProp");
            queryField.setBaseEntityName(((MulBasedataProp)baseDataProperty).getBaseEntityId());
        }
        queryField.setEntityNumber(queryEntityModel.getEntityNumber());
        queryField.setEntityName(queryEntityModel.getEntityName());
        queryField.setFullFieldNumber(fullFieldNumberPrefix + baseDataProperty.getName());
        queryField.setFullFieldName(fullFieldNamePrefix + baseDataProperty.getDisplayName().getLocaleValue());
        queryField.setQueryFieldNumber(queryFieldNumberPrefix + baseDataProperty.getName());
        return queryField;
    }

    private QueryFieldModel getQueryFieldModel(IDataEntityProperty property) {
        if (StringUtils.isEmpty((String)property.getAlias())) {
            return null;
        }
        if (property.getDisplayName() == null) {
            LOG.info("fieldNumber:{} is not DisplayName", (Object)property.getName());
            return null;
        }
        QueryFieldModel queryField = new QueryFieldModel();
        String valueType = "";
        String fieldType = "";
        if (property instanceof LongProp) {
            valueType = Long.class.getSimpleName();
            fieldType = LongProp.class.getSimpleName();
        }
        if (property instanceof IntegerProp) {
            valueType = Integer.class.getSimpleName();
            fieldType = IntegerProp.class.getSimpleName();
        } else if (property instanceof DecimalProp) {
            valueType = "Decimal";
            fieldType = DecimalProp.class.getSimpleName();
        } else if (property instanceof DateProp) {
            valueType = Date.class.getSimpleName();
            fieldType = DateProp.class.getSimpleName();
        } else if (property instanceof BooleanProp) {
            valueType = Boolean.class.getSimpleName();
            fieldType = BooleanProp.class.getSimpleName();
        } else if (property instanceof ComboProp) {
            valueType = String.class.getSimpleName();
            fieldType = ComboProp.class.getSimpleName();
            ArrayList comboItemList = Lists.newArrayListWithExpectedSize((int)((ComboProp)property).getComboItems().size());
            ((ComboProp)property).getComboItems().forEach(item -> {
                JSONObject comboItem = new JSONObject();
                comboItem.put("name", (Object)item.getName());
                comboItem.put("value", (Object)item.getValue());
                comboItemList.add(comboItem);
            });
            queryField.setComboItemList((List)comboItemList);
        } else if (property instanceof TextProp) {
            valueType = String.class.getSimpleName();
            fieldType = TextProp.class.getSimpleName();
        } else if (property instanceof DateTimeProp) {
            valueType = "DateTime";
            fieldType = DateTimeProp.class.getSimpleName();
        }
        if (StringUtils.isEmpty((String)valueType)) {
            return null;
        }
        queryField.setValueType(valueType);
        queryField.setFieldType(fieldType);
        if (property.getDisplayName() != null) {
            queryField.setFieldName(property.getDisplayName().getLocaleValue());
        } else {
            queryField.setFieldName("no_name");
        }
        queryField.setFieldNumber(property.getName());
        queryField.setComplexType(false);
        return queryField;
    }

    private TreeNode getEntryFieldTreeNode(List<QueryFieldModel> queryFieldModelList, QueryEntityModel queryEntityModel, EntryType entryType, List<String> fieldNumberList) {
        String fullFieldNumberPrefix = queryEntityModel.getEntityNumber() + ".";
        String fullFieldNamePrefix = queryEntityModel.getEntityName() + ".";
        String queryFieldNumberPrefix = queryEntityModel.getMainEntity() != false ? "" : queryEntityModel.getEntityNumber() + ".";
        QueryFieldModel queryField = new QueryFieldModel();
        queryField.setValueType("Long");
        queryField.setFieldType("EntryProp");
        queryField.setFieldName(entryType.getDisplayName().getLocaleValue());
        queryField.setFieldNumber(entryType.getName());
        queryField.setComplexType(true);
        queryField.setEntityNumber(queryEntityModel.getEntityNumber());
        queryField.setEntityName(queryEntityModel.getEntityName());
        queryField.setFullFieldNumber(fullFieldNumberPrefix + entryType.getName());
        queryField.setFullFieldName(fullFieldNamePrefix + entryType.getDisplayName().getLocaleValue());
        queryField.setQueryFieldNumber(queryFieldNumberPrefix + entryType.getName());
        queryFieldModelList.add(queryField);
        TreeNode treeNode = new TreeNode(queryEntityModel.getEntityNumber(), fullFieldNumberPrefix + entryType.getName(), entryType.getDisplayName().getLocaleValue());
        treeNode.setIsOpened(true);
        List<TreeNode> treeNodes = this.buildQueryFieldInfoList(treeNode.getId(), queryFieldModelList, queryEntityModel, fieldNumberList, (EntityType)entryType, fullFieldNumberPrefix + entryType.getName() + ".", queryFieldNumberPrefix + entryType.getName() + ".", fullFieldNamePrefix + entryType.getDisplayName().getLocaleValue() + ".");
        treeNode.setChildren(treeNodes);
        return treeNode;
    }

    private QueryFieldModel getIdQueryFieldModel(IDataEntityType iDataEntityType, QueryEntityModel queryEntityModel, String fullFieldNumberPrefix, String queryFieldNumberPrefix, String fullFieldNamePrefix) {
        QueryFieldModel queryField = new QueryFieldModel();
        String simpleName = iDataEntityType.getPrimaryKey().getPropertyType().getSimpleName();
        String valueType = String.class.getSimpleName();
        String fieldType = TextProp.class.getSimpleName();
        if ("long".equals(simpleName)) {
            valueType = Long.class.getSimpleName();
            fieldType = LongProp.class.getSimpleName();
        }
        queryField.setFieldType(fieldType);
        queryField.setValueType(valueType);
        queryField.setFieldName("id");
        queryField.setFieldNumber("id");
        queryField.setFieldAlias(queryFieldNumberPrefix + "id");
        queryField.setComplexType(false);
        queryField.setEntityNumber(queryEntityModel.getEntityNumber());
        queryField.setEntityName(queryEntityModel.getEntityName());
        queryField.setFullFieldNumber(fullFieldNumberPrefix + "id");
        queryField.setFullFieldName(fullFieldNamePrefix + "id");
        queryField.setQueryFieldNumber(queryFieldNumberPrefix + "id");
        return queryField;
    }

    public static QueryEntityModel buildQueryEntityModel(DynamicObject mainEntity, boolean isMainEntity, QueryEntityType queryEntityType) {
        String entityNumber = mainEntity.getString("number");
        String entityName = mainEntity.getString("name");
        if (queryEntityType != null) {
            MainEntityType mainEntityType = queryEntityType.getMainEntityType();
            entityNumber = mainEntityType.getName();
            entityName = mainEntityType.getDisplayName().getLocaleValue();
        }
        QueryEntityModel queryEntityModel = new QueryEntityModel();
        queryEntityModel.setEntityNumber(entityNumber);
        queryEntityModel.setEntityName(entityName);
        queryEntityModel.setMainEntity(Boolean.valueOf(isMainEntity));
        return queryEntityModel;
    }

    public DynamicObject getQueryApiConfig() {
        return this.queryApiConfig;
    }

    public DynamicObject getMainEntity() {
        return this.mainEntity;
    }

    public DynamicObjectCollection getRelEntryEntity() {
        return this.relEntryEntity;
    }

    public List<QueryEntityModel> getQueryEntityModelList() {
        return this.queryEntityModelList;
    }

    public List<QueryFieldModel> getQueryFieldModelList() {
        return this.queryFieldModelList;
    }

    public Map<String, List<TreeNode>> getEntityNumberAndFieldTreeNodeListMap() {
        return this.entityNumberAndFieldTreeNodeListMap;
    }
}

