/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.queryapi.bo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class QueryApiRelEntryEntityBo {
    private TreeNode rootNode;
    private DynamicObjectCollection relEntryEntityCollection;
    private DynamicObject mainEntityObj;
    private Map<String, String> leftAndRightObjIdMap;

    public QueryApiRelEntryEntityBo(DynamicObjectCollection relEntryEntityCollection, DynamicObject mainEntityObj) {
        this.relEntryEntityCollection = relEntryEntityCollection;
        this.mainEntityObj = mainEntityObj;
        this.buildRootNode();
    }

    public int[] getDeleteEntryRows(int[] selectRows) {
        int i;
        HashSet affectedObjIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (int i2 = 0; i2 < this.relEntryEntityCollection.size(); ++i2) {
            DynamicObject rightEntityObj = ((DynamicObject)this.relEntryEntityCollection.get(i2)).getDynamicObject("rightentityobj");
            if (rightEntityObj == null) continue;
            for (int selectRow : selectRows) {
                if (i2 != selectRow) continue;
                affectedObjIdSet.add(rightEntityObj.getString("id"));
            }
        }
        ArrayList affectedTreeNodeList = Lists.newArrayListWithExpectedSize((int)16);
        affectedObjIdSet.forEach(affectedObjId -> {
            TreeNode treeNode = this.rootNode.getTreeNode(affectedObjId);
            if (treeNode != null) {
                affectedTreeNodeList.add(treeNode);
            }
        });
        affectedTreeNodeList.forEach(node -> this.findAffectedObjId((TreeNode)node, affectedObjIdSet));
        TreeSet affectedIdxSet = Sets.newTreeSet();
        for (i = 0; i < selectRows.length; ++i) {
            affectedIdxSet.add(selectRows[i]);
        }
        for (i = 0; i < this.relEntryEntityCollection.size(); ++i) {
            DynamicObject leftEntityObj = ((DynamicObject)this.relEntryEntityCollection.get(i)).getDynamicObject("leftentityobj");
            if (leftEntityObj == null || !affectedObjIdSet.contains(leftEntityObj.getString("id"))) continue;
            affectedIdxSet.add(i);
        }
        return QueryApiRelEntryEntityBo.convertIntegerArrayToIntArray(affectedIdxSet.toArray(new Integer[0]));
    }

    public static int[] convertIntegerArrayToIntArray(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int[] intArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            intArray[i] = integerArray[i] != null ? integerArray[i] : 0;
        }
        return intArray;
    }

    private void findAffectedObjId(TreeNode treeNode, Set<String> affectedObjIdList) {
        affectedObjIdList.add(treeNode.getId());
        while (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            treeNode.getChildren().forEach(node -> this.findAffectedObjId((TreeNode)node, affectedObjIdList));
        }
    }

    private void buildRootNode() {
        this.rootNode = new TreeNode("", this.mainEntityObj.getString("id"), this.mainEntityObj.getString("name"));
        HashMap nodeIdAndNodeMap = Maps.newHashMapWithExpectedSize((int)16);
        nodeIdAndNodeMap.put(this.mainEntityObj.getString("id"), this.rootNode);
        this.leftAndRightObjIdMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        this.relEntryEntityCollection.forEach(relEntry -> {
            DynamicObject leftEntityObj = relEntry.getDynamicObject("leftentityobj");
            DynamicObject rightEntityObj = relEntry.getDynamicObject("rightentityobj");
            if (leftEntityObj != null && rightEntityObj != null) {
                String leftEntityObjId = leftEntityObj.getString("id");
                TreeNode parentTreeNode = (TreeNode)nodeIdAndNodeMap.get(leftEntityObjId);
                if (parentTreeNode == null) {
                    parentTreeNode = new TreeNode("", leftEntityObjId, leftEntityObj.getString("name"));
                    nodeIdAndNodeMap.put(leftEntityObjId, parentTreeNode);
                }
                String rightEntityObjId = rightEntityObj.getString("id");
                TreeNode childTreeNode = new TreeNode(parentTreeNode.getId(), rightEntityObjId, rightEntityObj.getString("name"));
                nodeIdAndNodeMap.put(rightEntityObjId, childTreeNode);
                ArrayList<TreeNode> children = parentTreeNode.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>();
                }
                children.add(childTreeNode);
                parentTreeNode.setChildren(children);
                this.leftAndRightObjIdMap.put(leftEntityObjId, rightEntityObjId);
            }
        });
        this.leftAndRightObjIdMap.forEach((leftObjId, rightObjId) -> {
            TreeNode parentNode = (TreeNode)nodeIdAndNodeMap.get(leftObjId);
            List children = parentNode.getChildren();
            boolean isExistChild = children.stream().anyMatch(node -> node.getId().equals(rightObjId));
            if (!isExistChild) {
                TreeNode treeNode = (TreeNode)nodeIdAndNodeMap.get(rightObjId);
                treeNode.setParentid(parentNode.getId());
                children.add(treeNode);
            }
        });
    }
}

