/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.queryapi.bo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryValueParamBo;
import kd.hdtc.hrdi.common.queryapi.enums.QueryConditionExpressType;
import kd.hdtc.hrdi.common.queryapi.enums.QueryParamType;
import kd.hdtc.hrdi.common.queryapi.model.QueryFieldModel;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryCondition;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryConditionExpress;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryConditionValue;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryParamCommon;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryValueParam;

public class QueryConditionValueBo {
    private final String conditionErrorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6%s\u4e0d\u5b8c\u6574\uff0c\u8bf7\u7ef4\u62a4\u5b8c\u6574\u3002", (String)"QueryConditionValueBo_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final String filterErrorMsg = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d", (String)"QueryConditionValueBo_1", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final Log logger = LogFactory.getLog(QueryConditionValueBo.class);
    private QueryConditionValue conditionValue;
    private String queryEntityNumber;
    private DynamicObject queryApiDyn;
    private final Set<String> mulValueOperateTypeSet = ImmutableSet.builder().add((Object)CompareTypeEnum.IN.getId()).add((Object)CompareTypeEnum.NOTIN.getId()).build();
    private final Set<String> notNeedValueOperateTypeSet = ImmutableSet.builder().add((Object)CompareTypeEnum.ISNULL.getId()).add((Object)CompareTypeEnum.ISNOTNULL.getId()).add((Object)CompareTypeEnum.TODAY.getId()).add((Object)CompareTypeEnum.YESTERDAY.getId()).add((Object)CompareTypeEnum.TOMORROW.getId()).add((Object)CompareTypeEnum.THISWEEK.getId()).add((Object)CompareTypeEnum.LASTWEEK.getId()).add((Object)CompareTypeEnum.NEXTWEEK.getId()).add((Object)CompareTypeEnum.THISMONTH.getId()).add((Object)CompareTypeEnum.LASTMONTH.getId()).add((Object)CompareTypeEnum.NEXTMONTH.getId()).add((Object)CompareTypeEnum.LASTTHREEMONTH.getId()).add((Object)CompareTypeEnum.FUTURETHREEMONTH.getId()).add((Object)CompareTypeEnum.THISQUARTER.getId()).add((Object)CompareTypeEnum.LASTQUARTER.getId()).add((Object)CompareTypeEnum.NEXTQUARTER.getId()).add((Object)CompareTypeEnum.THISYEAR.getId()).add((Object)CompareTypeEnum.LASTYEAR.getId()).add((Object)CompareTypeEnum.NEXTYEAR.getId()).add((Object)CompareTypeEnum.LESSTHANOREQUALTODAY.getId()).add((Object)CompareTypeEnum.MORETHANOREQUALTODAY.getId()).add((Object)CompareTypeEnum.COMBOBOXISNULL.getId()).add((Object)CompareTypeEnum.COMBOBOXISNOTNULL.getId()).build();

    public QueryConditionValueBo(DynamicObject queryApiDyn) {
        this.init(queryApiDyn, null, null, null);
    }

    public QueryConditionValueBo(DynamicObject queryApiDyn, Map<String, QueryFieldModel> queryFieldModelMap, QueryValueParamBo valueParamBo, String paramNumber) {
        this.init(queryApiDyn, queryFieldModelMap, valueParamBo, paramNumber);
    }

    private void init(DynamicObject queryApiDyn, Map<String, QueryFieldModel> queryFieldModelMap, QueryValueParamBo valueParamBo, String paramNumber) {
        this.queryApiDyn = queryApiDyn;
        String jsonData = queryApiDyn.getString("conditionvalue_tag");
        if (StringUtils.isNotEmpty((String)jsonData)) {
            this.conditionValue = (QueryConditionValue)JSONObject.parseObject((String)jsonData, QueryConditionValue.class);
        } else {
            this.conditionValue = new QueryConditionValue();
            this.conditionValue.setConditionExpressType("0");
        }
        this.queryEntityNumber = queryApiDyn.getString("queryconfignumber");
        if (CollectionUtils.isNotEmpty(queryFieldModelMap)) {
            this.deleteConditionByQueryFieldModel(queryFieldModelMap);
        }
        if (valueParamBo != null) {
            this.removeValueByValueParam(valueParamBo, paramNumber);
        }
    }

    public String getConditionValueJsonData() {
        return JSONObject.toJSONString((Object)this.conditionValue);
    }

    public String conditionCompleteValidate() {
        List conditionList = this.conditionValue.getConditionList();
        StringBuilder msgBuider = new StringBuilder();
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return msgBuider.toString();
        }
        for (QueryCondition condition : conditionList) {
            String msg = String.format(Locale.ROOT, this.conditionErrorMsg, condition.getName());
            if (this.notNeedValueOperateTypeSet.contains(condition.getOperators())) {
                if (!StringUtils.isEmpty((String)condition.getParam())) continue;
                msgBuider.append(msg);
                continue;
            }
            if (!StringUtils.isEmpty((String)condition.getParam()) && !StringUtils.isEmpty((String)condition.getValue()) && !StringUtils.isEmpty((String)condition.getValueType()) && !StringUtils.isEmpty((String)condition.getOperators())) continue;
            msgBuider.append(msg);
        }
        return msgBuider.toString();
    }

    private void deleteConditionByQueryFieldModel(Map<String, QueryFieldModel> queryFieldModelMap) {
        List conditionList = this.conditionValue.getConditionList();
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return;
        }
        ArrayList needDeleteConditionList = new ArrayList(10);
        HashSet conditionNameSet = new HashSet(16);
        conditionList.forEach(condition -> {
            if (!queryFieldModelMap.containsKey(condition.getParam())) {
                needDeleteConditionList.add(condition);
                conditionNameSet.add(condition.getName());
            }
        });
        conditionList.removeAll(needDeleteConditionList);
        List conditionExpressList = this.conditionValue.getConditionExpressList();
        conditionExpressList.removeIf(express -> conditionNameSet.contains(express.getName()));
        this.conditionValue.setConditionExpressList(conditionExpressList);
    }

    private void removeValueByValueParam(QueryValueParamBo valueParamBo, String paramNumber) {
        List conditionList = this.conditionValue.getConditionList();
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return;
        }
        Map<String, QueryValueParam> valueParamMap = valueParamBo.getValueParamList().stream().collect(Collectors.toMap(QueryParamCommon::getId, param -> param, (k1, k2) -> k1));
        for (QueryCondition condition : conditionList) {
            if (!StringUtils.equals((String)condition.getValueType(), (String)"1") || condition.getValue() == null) continue;
            QueryValueParam queryValueParam = valueParamMap.get(condition.getValue());
            if (queryValueParam == null || StringUtils.equals((String)paramNumber, (String)condition.getValue())) {
                condition.setValue("");
                condition.setDisplayValue("");
                continue;
            }
            condition.setDisplayValue(queryValueParam.getName());
        }
    }

    public String getValue() {
        return JSONObject.toJSONString((Object)this.conditionValue);
    }

    public QueryCondition getCondition(int index) {
        return (QueryCondition)this.conditionValue.getConditionList().get(index);
    }

    public Map<String, String> getCondition() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("value", this.getConditionExpress());
        return result;
    }

    private String getConditionExpress() {
        StringBuilder express = new StringBuilder();
        if (this.conditionValue == null || CollectionUtils.isEmpty((Collection)this.conditionValue.getConditionExpressList())) {
            return express.toString();
        }
        List conditionExpressList = this.conditionValue.getConditionExpressList();
        for (QueryConditionExpress conditionExpress : conditionExpressList) {
            this.appendCondition(express, conditionExpress.getLeftBracket());
            this.appendCondition(express, conditionExpress.getName());
            this.appendCondition(express, conditionExpress.getLogical());
            this.appendCondition(express, conditionExpress.getRightBracket());
        }
        return express.toString();
    }

    private void appendCondition(StringBuilder express, String condition) {
        if (StringUtils.isNotEmpty((String)condition)) {
            express.append(condition);
        }
    }

    public QFilter getQueryFilter(Map<String, Object> paramValueMap) {
        List<QueryConditionExpress> expressList = this.getExpress();
        if (CollectionUtils.isEmpty(expressList)) {
            return null;
        }
        Map<String, QueryCondition> conditionMap = this.conditionValue.getConditionList().stream().collect(Collectors.toMap(QueryCondition::getName, condition -> condition));
        FilterCondition filterCondition = this.buildFilterCondition(expressList, conditionMap, paramValueMap);
        QFilter filter = this.conditionToQFilter(filterCondition);
        this.logger.info("conditionValue={}, filter={}", (Object)this.getValue(), (Object)filter.toString());
        return filter;
    }

    public String qFilterValidate() {
        block3: {
            List<QueryConditionExpress> expressList = this.getExpress();
            if (CollectionUtils.isEmpty(expressList)) {
                return "";
            }
            Map<String, QueryCondition> conditionMap = this.conditionValue.getConditionList().stream().collect(Collectors.toMap(QueryCondition::getName, condition -> condition));
            FilterCondition filterCondition = this.buildFilterCondition(expressList, conditionMap, this.getValidateParamMap());
            try {
                this.conditionToQFilter(filterCondition);
            }
            catch (KDException exception) {
                if (!StringUtils.equals((String)"bos.filterSqlBuilder", (String)exception.getErrorCode().getCode())) break block3;
                return this.getErrorMsg(exception);
            }
        }
        return "";
    }

    private Map<String, Object> getValidateParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        DynamicObjectCollection requestEntry = this.queryApiDyn.getDynamicObjectCollection("requestentryentity");
        requestEntry.forEach(dyn -> {
            String paramNumber = dyn.getString("paramnumber");
            String paramType = dyn.getString("paramtype");
            boolean mulValue = dyn.getBoolean("mulvalue");
            paramMap.put(paramNumber, this.getDefaultParamValue(paramType, mulValue));
        });
        return paramMap;
    }

    private Object getDefaultParamValue(String paramType, Boolean mulValue) {
        if (StringUtils.equalsIgnoreCase((String)QueryParamType.STRING.getCode(), (String)paramType) || StringUtils.equalsIgnoreCase((String)QueryParamType.DATE.getCode(), (String)paramType) || StringUtils.equalsIgnoreCase((String)QueryParamType.DATETIME.getCode(), (String)paramType)) {
            if (mulValue.booleanValue()) {
                return new String[]{DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")};
            }
            return DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (StringUtils.equalsIgnoreCase((String)QueryParamType.BOOLEAN.getCode(), (String)paramType)) {
            if (mulValue.booleanValue()) {
                return new Boolean[]{Boolean.TRUE};
            }
            return Boolean.TRUE;
        }
        if (StringUtils.equalsIgnoreCase((String)QueryParamType.Number.getCode(), (String)paramType)) {
            if (mulValue.booleanValue()) {
                return new Integer[]{1};
            }
            return 1;
        }
        if (StringUtils.equalsIgnoreCase((String)QueryParamType.DECIMAL.getCode(), (String)paramType)) {
            if (mulValue.booleanValue()) {
                return new Double[]{1.1};
            }
            return 1.1;
        }
        if (StringUtils.equalsIgnoreCase((String)QueryParamType.INTEGER.getCode(), (String)paramType) || StringUtils.equalsIgnoreCase((String)QueryParamType.LONG.getCode(), (String)paramType)) {
            if (mulValue.booleanValue()) {
                return new String[]{"0"};
            }
            return "0";
        }
        return null;
    }

    private String getErrorMsg(KDException exception) {
        Object[] args = exception.getArgs();
        StringBuilder msgBuilder = new StringBuilder(this.filterErrorMsg);
        for (Object arg : args) {
            if (!(arg instanceof String)) continue;
            msgBuilder.append(arg);
        }
        return msgBuilder.toString();
    }

    private FilterCondition buildFilterCondition(List<QueryConditionExpress> expressList, Map<String, QueryCondition> conditionMap, Map<String, Object> paramValueMap) {
        FilterCondition condition = new FilterCondition();
        condition.setForList(false);
        for (QueryConditionExpress express : expressList) {
            QueryCondition queryCondition = conditionMap.get(express.getName());
            Object paramValue = "";
            if (!this.notNeedValueOperateTypeSet.contains(queryCondition.getOperators()) && queryCondition.getValueType().equals("1") && (paramValue = paramValueMap.get(queryCondition.getValue())) == null) continue;
            SimpleFilterRow filterRow = this.buildFilterRow(express, queryCondition, paramValue);
            condition.addFilterRow(filterRow);
        }
        return condition;
    }

    private QFilter conditionToQFilter(FilterCondition condition) {
        MainEntityType entityType = MetadataUtils.getMainEntityType((String)this.queryEntityNumber);
        return PermCommonUtil.getQFilterFromFilterCondition((MainEntityType)entityType, (FilterCondition)condition);
    }

    private SimpleFilterRow buildFilterRow(QueryConditionExpress express, QueryCondition queryCondition, Object paramValue) {
        SimpleFilterRow filterRow = new SimpleFilterRow();
        filterRow.setId(queryCondition.getOperators());
        filterRow.setLeftBracket(express.getLeftBracket());
        String logical = express.getLogical();
        if (StringUtils.isNotEmpty((String)logical)) {
            logical = logical.trim();
            logical = logical.toUpperCase(Locale.ROOT);
        }
        filterRow.setLogic(logical);
        filterRow.setRightBracket(express.getRightBracket());
        filterRow.setFieldName(queryCondition.getParam());
        filterRow.setCompareType(queryCondition.getOperators());
        filterRow.setValue(this.getFilterValue(queryCondition, paramValue));
        return filterRow;
    }

    private List<FilterValue> getFilterValue(QueryCondition queryCondition, Object paramValue) {
        ArrayList<FilterValue> filterValueList = new ArrayList<FilterValue>(10);
        if (queryCondition.getValueType().equals("1")) {
            this.paramTypeHandle(filterValueList, queryCondition, paramValue);
        } else {
            this.valueTypeHandle(filterValueList, queryCondition);
        }
        return filterValueList;
    }

    private void valueTypeHandle(List<FilterValue> filterValueList, QueryCondition queryCondition) {
        if (this.mulValueOperateTypeSet.contains(queryCondition.getOperators())) {
            String[] values;
            String conditionValue = queryCondition.getValue();
            for (String value : values = conditionValue.split(",")) {
                filterValueList.add(this.buildFilterValue(queryCondition.getValueDataType(), value));
            }
        } else {
            filterValueList.add(this.buildFilterValue(queryCondition.getValueDataType(), queryCondition.getValue()));
        }
    }

    private void paramTypeHandle(List<FilterValue> filterValueList, QueryCondition queryCondition, Object paramValue) {
        if (paramValue instanceof JSONArray) {
            JSONArray paramValues = (JSONArray)paramValue;
            for (Object value : paramValues) {
                filterValueList.add(this.buildFilterValue(queryCondition.getValueDataType(), value));
            }
        } else if (paramValue instanceof String[]) {
            String[] paramValues;
            for (String value : paramValues = (String[])paramValue) {
                filterValueList.add(this.buildFilterValue(queryCondition.getValueDataType(), value));
            }
        } else if (paramValue instanceof Boolean[]) {
            Boolean[] paramValues;
            for (Boolean value : paramValues = (Boolean[])paramValue) {
                filterValueList.add(this.buildFilterValue(queryCondition.getValueDataType(), value));
            }
        } else {
            filterValueList.add(this.buildFilterValue(queryCondition.getValueDataType(), paramValue));
        }
    }

    private FilterValue buildFilterValue(String dataType, Object value) {
        FilterValue filterValue = new FilterValue();
        if (QueryParamType.BOOLEAN.getCode().equals(dataType)) {
            String valueStr = "";
            if (value instanceof String) {
                valueStr = StringUtils.equals((String)"true", (String)((String)value)) ? "1" : "0";
            } else if (value instanceof Boolean) {
                valueStr = (Boolean)value != false ? "1" : "0";
            }
            filterValue.setValue((Object)valueStr);
        } else if (QueryParamType.DATE.getCode().equals(dataType)) {
            filterValue.setValue((value = this.getDateVaule(value)) == null ? "" : value);
        } else {
            filterValue.setValue(value == null ? "" : value);
        }
        return filterValue;
    }

    private String getDateVaule(Object value) {
        if (value == null) {
            return "";
        }
        try {
            return DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)((String)value)), (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException exception) {
            this.logger.error("getDateVaule error, errorMsg:", (Object)ThrowableUtils.toString((Throwable)exception));
            return "";
        }
    }

    private List<QueryConditionExpress> getExpress() {
        ArrayList<QueryConditionExpress> conditionExpressList = new ArrayList();
        switch (this.getExpressType()) {
            case AND: {
                conditionExpressList = this.getAndOrExpress(QueryConditionExpressType.AND.name().toLowerCase());
                break;
            }
            case OR: {
                conditionExpressList = this.getAndOrExpress(QueryConditionExpressType.OR.name().toLowerCase());
                break;
            }
            case CUSTOM: {
                conditionExpressList = this.conditionValue.getConditionExpressList();
                break;
            }
            default: {
                this.logger.error("can not find condition express. expressType={}", (Object)this.conditionValue.getConditionExpressType());
            }
        }
        return conditionExpressList;
    }

    private List<QueryConditionExpress> getAndOrExpress(String logical) {
        List conditionList = this.conditionValue.getConditionList();
        ArrayList<QueryConditionExpress> expressList = new ArrayList<QueryConditionExpress>(10);
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return expressList;
        }
        conditionList.forEach(condition -> {
            QueryConditionExpress express = new QueryConditionExpress();
            express.setName(condition.getName());
            express.setLogical(logical);
            expressList.add(express);
        });
        return expressList;
    }

    private QueryConditionExpressType getExpressType() {
        return QueryConditionExpressType.getExpressType((String)this.conditionValue.getConditionExpressType());
    }

    public Map<String, List<QueryCondition>> getConditionParamNumber() {
        List conditionList = this.conditionValue.getConditionList();
        HashMap<String, List<QueryCondition>> paramNumberMap = new HashMap<String, List<QueryCondition>>(16);
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return paramNumberMap;
        }
        conditionList.forEach(condition -> {
            if (StringUtils.equals((String)"1", (String)condition.getValueType())) {
                List queryConditionList = paramNumberMap.getOrDefault(condition.getValue(), new ArrayList());
                queryConditionList.add(condition);
                paramNumberMap.put(condition.getValue(), queryConditionList);
            }
        });
        return paramNumberMap;
    }

    public QueryCondition getConditionByIndex(int index) {
        return (QueryCondition)this.conditionValue.getConditionList().get(index);
    }
}

