/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.queryapi.bo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.common.queryapi.enums.QueryParamType;
import kd.hdtc.hrdi.common.queryapi.enums.QueryParamTypeDetail;
import kd.hdtc.hrdi.common.queryapi.model.QueryFieldModel;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryEnumField;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryFieldParam;

public class QueryFieldParamBo {
    private Map<String, QueryFieldParam> parentParamMap;
    private List<QueryFieldParam> entityParamList;
    private List<QueryFieldParam> basedataParamList;
    private final Map<String, String> formatMappingMap = ImmutableMap.builder().put((Object)"DateProp", (Object)"yyyy-MM-dd").put((Object)"DateTimeProp", (Object)"yyyy-MM-dd HH:mm:ss").put((Object)"TimeProp", (Object)"HH:mm:ss").build();
    private final Map<String, String> typeMappingMap = ImmutableMap.builder().put((Object)"String", (Object)QueryParamType.STRING.getCode()).put((Object)"Boolean", (Object)QueryParamType.BOOLEAN.getCode()).put((Object)"Date", (Object)QueryParamType.DATE.getCode()).put((Object)"DateTime", (Object)QueryParamType.DATETIME.getCode()).put((Object)"Long", (Object)QueryParamType.LONG.getCode()).put((Object)"Integer", (Object)QueryParamType.INTEGER.getCode()).put((Object)"Decimal", (Object)QueryParamType.DECIMAL.getCode()).build();
    private final Set<String> parentParamTypeSet = ImmutableSet.of((Object)"BasedataProp", (Object)"EntryProp", (Object)"MulBasedataProp");
    private final Map<String, String> detailTypeMappingMap = ImmutableMap.builder().put((Object)"BooleanProp", (Object)QueryParamTypeDetail.BOOLEAN.getCode()).put((Object)"TextProp", (Object)QueryParamTypeDetail.STRING.getCode()).put((Object)"TextAreaProp", (Object)QueryParamTypeDetail.STRING.getCode()).put((Object)"LargeTextProp", (Object)QueryParamTypeDetail.STRING.getCode()).put((Object)"MuliLangTextProp", (Object)QueryParamTypeDetail.STRING.getCode()).put((Object)"ComboProp", (Object)QueryParamTypeDetail.ENUM.getCode()).put((Object)"MulComboProp", (Object)QueryParamTypeDetail.MUL_ENUM.getCode()).put((Object)"CreateDateProp", (Object)QueryParamTypeDetail.DATE.getCode()).put((Object)"ModifyDateProp", (Object)QueryParamTypeDetail.DATE.getCode()).put((Object)"DateProp", (Object)QueryParamTypeDetail.DATE.getCode()).put((Object)"TimeProp", (Object)QueryParamTypeDetail.DATE.getCode()).put((Object)"DateTimeProp", (Object)QueryParamTypeDetail.DATE.getCode()).put((Object)"DecimalProp", (Object)QueryParamTypeDetail.NUMBER.getCode()).put((Object)"BigIntProp", (Object)QueryParamTypeDetail.NUMBER.getCode()).put((Object)"IntegerProp", (Object)QueryParamTypeDetail.NUMBER.getCode()).put((Object)"LongProp", (Object)QueryParamTypeDetail.NUMBER.getCode()).put((Object)"CreatedByIdProp", (Object)QueryParamTypeDetail.DYNAMICOBJECT.getCode()).put((Object)"ModifierIdProp", (Object)QueryParamTypeDetail.DYNAMICOBJECT.getCode()).put((Object)"BasedataProp", (Object)QueryParamTypeDetail.DYNAMICOBJECT.getCode()).put((Object)"MulBasedataProp", (Object)QueryParamTypeDetail.MUL_DYNAMICOBJECT.getCode()).build();

    public QueryFieldParamBo(Map<String, QueryFieldModel> queryFieldModelMap) {
        this.init(queryFieldModelMap);
    }

    private void init(Map<String, QueryFieldModel> queryFieldModelMap) {
        this.parentParamMap = new HashMap<String, QueryFieldParam>(16);
        this.entityParamList = new ArrayList<QueryFieldParam>(10);
        this.basedataParamList = new ArrayList<QueryFieldParam>(10);
        queryFieldModelMap.forEach((fullNumber, model) -> {
            this.buildEntityParam((QueryFieldModel)model);
            QueryFieldParam parentParam = this.getParentParam(model.getFullFieldNumber());
            this.buildParam(parentParam, (QueryFieldModel)model);
        });
        this.emptyParentFieldHandle();
    }

    private void emptyParentFieldHandle() {
        this.parentParamMap.forEach((key, fieldModel) -> {
            QueryFieldParam parentParam;
            List children;
            if (StringUtils.isEmpty((String)fieldModel.getId()) && CollectionUtils.isEmpty((Collection)fieldModel.getChildren()) && CollectionUtils.isNotEmpty((Collection)(children = (parentParam = this.getParentParam(fieldModel.getFullFieldNumber())).getChildren()))) {
                children.remove(fieldModel);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildParam(QueryFieldParam parentParam, QueryFieldModel model) {
        QueryFieldParam param;
        String fieldType;
        if (parentParam == null) {
            return;
        }
        ArrayList<QueryFieldParam> children = parentParam.getChildren();
        if (children == null) {
            children = new ArrayList<QueryFieldParam>(10);
        }
        if (this.parentParamTypeSet.contains(fieldType = model.getFieldType())) {
            if (Integer.parseInt(parentParam.getLevel()) >= 2) return;
            param = this.buildParentParam(model, parentParam, null);
            this.parentParamMap.put(model.getFullFieldNumber(), param);
        } else {
            param = this.buildChildParam(model, parentParam);
        }
        children.add(param);
        parentParam.setChildren(children);
    }

    private QueryFieldParam getParentParam(String fullFieldNumber) {
        String key = fullFieldNumber.substring(0, fullFieldNumber.lastIndexOf("."));
        return this.parentParamMap.get(key);
    }

    private void buildEntityParam(QueryFieldModel model) {
        String entityNumber = model.getEntityNumber();
        String entityName = model.getEntityName();
        QueryFieldParam fieldParam = this.parentParamMap.get(entityNumber);
        if (fieldParam == null) {
            fieldParam = this.buildParentParam(model, null, entityName);
            this.entityParamList.add(fieldParam);
            this.parentParamMap.put(entityNumber, fieldParam);
        }
    }

    private QueryFieldParam buildParentParam(QueryFieldModel model, QueryFieldParam parentParam, String text) {
        if (StringUtils.isEmpty((String)text)) {
            text = model.getFieldName();
        }
        String type = null;
        String parentLevel = "0";
        if (parentParam != null) {
            parentLevel = parentParam.getLevel();
            type = this.getTypeDetail(model.getFieldType());
        }
        QueryFieldParam fieldParam = new QueryFieldParam();
        fieldParam.setLevel(Integer.parseInt(parentLevel) + 1 + "");
        fieldParam.setText(text);
        fieldParam.setTypeDetail(type);
        fieldParam.setEntityNumber(model.getBaseEntityName());
        fieldParam.setFullFieldNumber(model.getFullFieldNumber());
        if (QueryParamTypeDetail.DYNAMICOBJECT.getCode().equals(type) || QueryParamTypeDetail.MUL_DYNAMICOBJECT.getCode().equals(type)) {
            fieldParam.setNumber(model.getQueryFieldNumber() + "." + "id");
            this.basedataParamList.add(fieldParam);
        }
        return fieldParam;
    }

    private QueryFieldParam buildChildParam(QueryFieldModel model, QueryFieldParam parentParam) {
        String parentFieldType;
        String parentLevel = parentParam.getLevel();
        String parentName = parentParam.getText();
        String fieldType = parentFieldType = parentParam.getTypeDetail();
        if (StringUtils.isEmpty((String)parentFieldType)) {
            fieldType = this.getTypeDetail(model.getFieldType());
        }
        String name = model.getFieldName();
        if (StringUtils.isNotEmpty((String)parentName)) {
            name = parentName + "." + name;
        }
        if (StringUtils.equals((String)"2", (String)parentLevel)) {
            name = model.getEntityName() + "." + name;
        }
        QueryFieldParam child = new QueryFieldParam();
        child.setLevel(Integer.parseInt(parentLevel) + 1 + "");
        child.setId(model.getQueryFieldNumber());
        child.setName(name);
        child.setNumber(model.getQueryFieldNumber());
        child.setText(model.getFieldName());
        child.setType(this.getType(model.getValueType(), fieldType));
        child.setTypeDetail(fieldType);
        child.setFullFieldNumber(model.getFullFieldNumber());
        if (QueryParamTypeDetail.ENUM.getCode().equals(child.getTypeDetail()) || QueryParamTypeDetail.MUL_ENUM.getCode().equals(child.getTypeDetail())) {
            child.setEnumList(this.getEnumList(model.getComboItemList()));
        }
        child.setDateFormat(this.getFormat(model.getFieldType()));
        child.setEntityNumber(parentParam.getEntityNumber());
        return child;
    }

    private List<QueryEnumField> getEnumList(List<JSONObject> comboItemList) {
        ArrayList<QueryEnumField> enumFieldList = new ArrayList<QueryEnumField>(10);
        if (CollectionUtils.isEmpty(comboItemList)) {
            return enumFieldList;
        }
        comboItemList.forEach(jsonObject -> {
            QueryEnumField enumField = new QueryEnumField();
            enumField.setValue(jsonObject.getString("value"));
            enumField.setName(jsonObject.get((Object)"name"));
            enumFieldList.add(enumField);
        });
        return enumFieldList;
    }

    private String getFormat(String fieldType) {
        return this.formatMappingMap.get(fieldType);
    }

    private String getType(String valueType, String typeDetail) {
        if (StringUtils.equalsIgnoreCase((String)QueryParamType.DYNAMICOBJECT.getCode(), (String)typeDetail)) {
            return QueryParamType.STRING.getCode();
        }
        String type = this.typeMappingMap.get(valueType);
        return StringUtils.isEmpty((String)type) ? QueryParamType.STRING.getCode() : type;
    }

    private String getTypeDetail(String fieldType) {
        String typeDetail = this.detailTypeMappingMap.get(fieldType);
        return StringUtils.isEmpty((String)typeDetail) ? QueryParamTypeDetail.STRING.getCode() : typeDetail;
    }

    public List<Map<String, String>> getParam() {
        return (List)JSONObject.toJSON(this.entityParamList);
    }

    public Map<String, List<Map<String, String>>> getBasedataParam() {
        if (CollectionUtils.isEmpty(this.basedataParamList)) {
            return new HashMap<String, List<Map<String, String>>>(0);
        }
        HashMap fieldParamMap = new HashMap(16);
        for (QueryFieldParam basedataParam : this.basedataParamList) {
            String key = basedataParam.getTypeDetail() + "_" + basedataParam.getEntityNumber();
            ArrayList<QueryFieldParam> queryFieldParamList = (ArrayList<QueryFieldParam>)fieldParamMap.get(key);
            if (queryFieldParamList == null) {
                queryFieldParamList = new ArrayList<QueryFieldParam>(10);
            }
            if (queryFieldParamList.size() >= 1) {
                QueryFieldParam queryFieldParam = (QueryFieldParam)queryFieldParamList.get(0);
                List children = queryFieldParam.getChildren();
                children.addAll(basedataParam.getChildren());
            } else {
                queryFieldParamList.add(basedataParam);
            }
            fieldParamMap.put(key, queryFieldParamList);
        }
        return (Map)JSONObject.toJSON(fieldParamMap);
    }
}

