/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.queryapi.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrdbs.business.application.external.entity.ICtsQueryDynSourceEntityService;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.pojo.metadata.QueryMetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.application.external.IHRQueryConfigDomainService;
import kd.hdtc.hrdi.business.application.external.entity.IOpenApiEntityService;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.queryapi.IQueryApiConfigDomainService;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryApiConfigBo;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryConditionValueBo;
import kd.hdtc.hrdi.business.domain.queryapi.entity.IQueryApiConfigEntityService;
import kd.hdtc.hrdi.common.openapi.ApiErrorCodeCustom;
import kd.hdtc.hrdi.common.openapi.OpenApiHrdiUtils;
import kd.hdtc.hrdi.common.pojo.OpenApiEntry;

public class QueryApiConfigDomainServiceImpl
implements IQueryApiConfigDomainService {
    private static final Log LOG = LogFactory.getLog(QueryApiConfigDomainServiceImpl.class);
    private final IOpenApiEntityService openApiEntityService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IOpenApiEntityService.class);
    private final ICtsQueryDynSourceEntityService ctsQueryDynSourceEntityService = (ICtsQueryDynSourceEntityService)ServiceFactory.getService(ICtsQueryDynSourceEntityService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IQueryApiConfigEntityService iQueryApiConfigEntityService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IQueryApiConfigEntityService.class);
    private final IHRDIBaseConfigDomainService configDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IBaseCommonDomainService.class);
    private final IHRQueryConfigDomainService queryConfigDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IHRQueryConfigDomainService.class);
    private static final String PRESCRIPT_TAG = "var cloudId = 'hdtc';\nvar appId = 'hrdi';\nvar serviceName = 'IDyQueryApiService';\nvar methodName = 'queryData';\nvar queryparam = {%1$s};\nvar params = ['%2$s',queryparam];\nvar result = MS.invokeBizService(cloudId, appId, serviceName, methodName, params);\n";
    String limit = ResManager.loadKDString((String)"\u5206\u9875\u67e5\u8be2\u6761\u6570", (String)"QueryApiConfigDomainServiceImpl_1", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);
    String offSet = ResManager.loadKDString((String)"\u504f\u79fb\u91cf", (String)"QueryApiConfigDomainServiceImpl_2", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);

    @Override
    public boolean cancelQueryOpenApi(DynamicObject[] queryApiConfigDyns) {
        if (queryApiConfigDyns == null || queryApiConfigDyns.length == 0) {
            return false;
        }
        this.openApiEntityService.deleteByNumberSet(this.getOpenApiNumberByMidTableConfig(queryApiConfigDyns));
        this.iQueryApiConfigEntityService.batchChangePublishStatus(queryApiConfigDyns, false);
        return true;
    }

    @Override
    public QFilter getQueryFilter(DynamicObject queryApiConfigDyn, Map<String, Object> paramValueMap) {
        QueryConditionValueBo valueBo = new QueryConditionValueBo(queryApiConfigDyn);
        return valueBo.getQueryFilter(paramValueMap);
    }

    @Override
    public boolean publishQueryOpenApi(DynamicObject[] queryApiConfigDyns) {
        if (queryApiConfigDyns == null || queryApiConfigDyns.length == 0) {
            return false;
        }
        List<DynamicObject> openApiObjectList = this.packageOpenApiDyList(queryApiConfigDyns);
        this.openApiEntityService.deleteByNumberSet(this.getOpenApiNumberByMidTableConfig(queryApiConfigDyns));
        boolean openApiSave = this.openApiEntityService.opSave(openApiObjectList);
        if (openApiSave) {
            this.iQueryApiConfigEntityService.batchChangePublishStatus(queryApiConfigDyns, true);
        }
        return openApiSave;
    }

    private Map<String, Boolean> getQueryApiConfigDeleteInfo(DynamicObject[] queryApiConfigDyns) {
        HashMap numberAndQueryApiConfigMap = Maps.newHashMapWithExpectedSize((int)queryApiConfigDyns.length);
        Stream.of(queryApiConfigDyns).forEach(dy -> numberAndQueryApiConfigMap.put(dy.getString("number"), dy));
        QFilter numberFilter = new QFilter("number", "in", numberAndQueryApiConfigMap.keySet());
        Object[] queryApiConfigFromDbs = this.iQueryApiConfigEntityService.query("name,number,queryconfigtype,queryconfignumber", new QFilter[]{numberFilter});
        HashMap numberAndQueryApiConfigDbMap = Maps.newHashMapWithExpectedSize((int)16);
        if (ArrayUtils.isNotEmpty((Object[])queryApiConfigFromDbs)) {
            Stream.of(queryApiConfigFromDbs).forEach(dyFromDb -> numberAndQueryApiConfigDbMap.put(dyFromDb.getString("number"), dyFromDb));
        }
        HashMap numberAndDeleteFlagMap = Maps.newHashMapWithExpectedSize((int)queryApiConfigDyns.length);
        numberAndQueryApiConfigMap.forEach((number, queryApiConfig) -> {
            boolean delete = false;
            if (numberAndQueryApiConfigDbMap.get(number) != null) {
                DynamicObject queryApiConfigDb = (DynamicObject)numberAndQueryApiConfigDbMap.get(number);
                String queryConfigTypeDb = queryApiConfigDb.getString("queryconfigtype");
                String queryConfigNumber = queryApiConfigDb.getString("queryconfignumber");
                if (("1".equals(queryConfigTypeDb) || "0".equals(queryConfigTypeDb)) && queryConfigNumber.startsWith("hrdi_1")) {
                    delete = true;
                }
            }
            numberAndDeleteFlagMap.put(number, delete);
        });
        return numberAndDeleteFlagMap;
    }

    @Override
    public void generateQuery(DynamicObject[] queryApiConfigDyns) {
        QueryMetadataGenParam queryMetadataGenParam = new QueryMetadataGenParam();
        queryMetadataGenParam.setCurrentBizAppNumber("hrdi");
        queryMetadataGenParam.setCurrentUnitId("4/PCGO4THIH9");
        Map<String, Boolean> numberAndDeleteFlagMap = this.getQueryApiConfigDeleteInfo(queryApiConfigDyns);
        for (DynamicObject queryApiConfigDyn : queryApiConfigDyns) {
            String queryConfigNumber = queryApiConfigDyn.getString("queryconfignumber");
            if (!StringUtils.isNotEmpty((CharSequence)queryConfigNumber) || !numberAndDeleteFlagMap.get(queryApiConfigDyn.getString("number")).booleanValue()) continue;
            this.dynamicMetadataApplicationService.deleteMetadata(queryConfigNumber, false);
        }
        for (DynamicObject queryApiConfigDyn : queryApiConfigDyns) {
            if (StringUtils.equals((CharSequence)"2", (CharSequence)queryApiConfigDyn.getString("queryconfigtype"))) continue;
            DynamicObject ctsQueryDynSource = this.buildQueryDyn(queryApiConfigDyn);
            this.dynamicMetadataApplicationService.generateQuery(queryMetadataGenParam, ctsQueryDynSource);
            queryApiConfigDyn.set("queryconfignumber", (Object)ctsQueryDynSource.getString("number"));
        }
    }

    private String getQueryNumber(DynamicObject queryApiConfigDyn) {
        long timestamp = System.currentTimeMillis();
        String number = this.generateQueryNumber(queryApiConfigDyn, timestamp);
        while (MetadataDao.checkNumber((String)number)) {
            number = this.generateQueryNumber(queryApiConfigDyn, ++timestamp);
        }
        return number;
    }

    private String generateQueryNumber(DynamicObject queryApiConfigDyn, long timestamp) {
        DynamicObject mainEntityObj = queryApiConfigDyn.getDynamicObject("mainentityobj");
        String mainEntityObjNumber = mainEntityObj.getString("number");
        String[] mainEntityObjNumbers = mainEntityObjNumber.split("_");
        String simpleObjNumber = "";
        simpleObjNumber = mainEntityObjNumbers.length > 1 ? (mainEntityObjNumbers[1].length() > 10 ? mainEntityObjNumbers[1].substring(0, 10) : mainEntityObjNumbers[1]) : (mainEntityObjNumber.length() > 10 ? mainEntityObjNumber.substring(0, 10) : mainEntityObjNumber);
        String timestampString = String.valueOf(timestamp);
        String lastFourDigits = timestampString.substring(timestampString.length() - 4);
        return "hrdi_1" + simpleObjNumber + lastFourDigits + "query";
    }

    @Override
    public List<Map<String, Object>> queryData(String apiConfigNumber, Map<String, Object> params) {
        long start = System.currentTimeMillis();
        if (StringUtils.isEmpty((CharSequence)apiConfigNumber) || CollectionUtils.isEmpty(params)) {
            return new ArrayList<Map<String, Object>>();
        }
        LOG.info("queryApiConfigNumber:{},params:{}", (Object)apiConfigNumber, params);
        DynamicObject queryApiConfig = this.iQueryApiConfigEntityService.queryQueryApiConfigByNumber(apiConfigNumber);
        if (queryApiConfig == null) {
            LOG.error("QueryApiConfig not should is not exist queryApiConfigNumber:{}", (Object)apiConfigNumber);
            return new ArrayList<Map<String, Object>>();
        }
        String limitMaxStr = this.configDomainService.queryBaseConfigValueByNumber("int.query.page.limit_max");
        String limitAndOffsetStr = this.configDomainService.queryBaseConfigValueByNumber("int.query.page.limit_offset");
        QueryApiConfigBo queryApiConfigBo = new QueryApiConfigBo(queryApiConfig, this.iBaseCommonDomainService);
        queryApiConfigBo.parsePageParam(limitAndOffsetStr, limitMaxStr, params);
        QFilter queryFilter = this.getQueryFilter(queryApiConfig, params);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryApiConfigBo.getQueryConfigNumber());
        LOG.info("queryApi prepare cost {}ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        DataSet queryDataSet = this.queryConfigDomainService.getQueryDataSet(queryEntityType, queryApiConfigBo.getSelectProperty(), new QFilter[]{queryFilter}, queryApiConfigBo.getOrderBy(), true, queryApiConfigBo.getStart(), queryApiConfigBo.getLimit(), null);
        LOG.info("queryApi queryData cost {}ms", (Object)(System.currentTimeMillis() - start));
        return queryApiConfigBo.parseQueryResult(queryDataSet);
    }

    @Override
    public void afterTransferConfPost(Set<Long> pkIdSet) {
        QFilter idFilter = new QFilter("id", "in", pkIdSet);
        DynamicObject[] queryApiDyns = this.iQueryApiConfigEntityService.loadDynamicObjectArray(new QFilter[]{idFilter});
        this.generateQuery(queryApiDyns);
        this.publishQueryOpenApi(queryApiDyns);
    }

    public DynamicObject buildQueryDyn(DynamicObject queryApiConfigDyn) {
        DynamicObject queryDyn = this.ctsQueryDynSourceEntityService.generateEmptyDynamicObject();
        String queryNumber = this.getQueryNumber(queryApiConfigDyn);
        queryDyn.set("dstype", (Object)"QueryList");
        queryDyn.set("currentappid", (Object)BizAppServiceHelp.getAppIdByAppNumber((String)"hrdi"));
        queryDyn.set("group", (Object)"4/PCGO4THIH9");
        queryDyn.set("enableimport", (Object)Boolean.FALSE);
        DynamicObject mainEntityObj = queryApiConfigDyn.getDynamicObject("mainentityobj");
        queryDyn.set("number", (Object)queryNumber);
        queryDyn.set("editentityaliasname", (Object)mainEntityObj.getString("number"));
        queryDyn.set("name", (Object)queryApiConfigDyn.getString("name"));
        queryDyn.set("mainentityname", (Object)mainEntityObj);
        queryDyn.set("mainentityalias", (Object)mainEntityObj.getString("number"));
        this.setQueryEntityEntry(queryDyn, queryApiConfigDyn);
        this.setQuerySelectFieldEntry(queryDyn, queryApiConfigDyn);
        return queryDyn;
    }

    private void setQuerySelectFieldEntry(DynamicObject queryDyn, DynamicObject queryApiConfigDyn) {
        DynamicObjectCollection queryEntryEntityCollection = queryApiConfigDyn.getDynamicObjectCollection("queryentryentity");
        DynamicObjectCollection querySelectFieldCollection = queryDyn.getDynamicObjectCollection("queryselectfieldsentry");
        queryEntryEntityCollection.forEach(queryEntry -> {
            DynamicObject entry = querySelectFieldCollection.addNew();
            entry.set("selectfieldalias", (Object)queryEntry.getString("fieldnumber"));
            entry.set("selectfielddisplayname", (Object)(queryEntry.getString("queryentityname") + "." + queryEntry.getString("fieldname")));
            entry.set("selectfieldentityname", (Object)queryEntry.getString("queryentityname"));
        });
    }

    private void setQueryEntityEntry(DynamicObject queryDyn, DynamicObject queryApiConfigDyn) {
        DynamicObjectCollection relEntryEntityCollection = queryApiConfigDyn.getDynamicObjectCollection("relentryentity");
        if (CollectionUtils.isEmpty((Collection)relEntryEntityCollection)) {
            return;
        }
        HashSet entityNumberSet = Sets.newHashSetWithExpectedSize((int)(relEntryEntityCollection.size() * 2 - 1));
        DynamicObjectCollection queryEntityCollection = queryDyn.getDynamicObjectCollection("queryentityentry");
        DynamicObjectCollection queryRelationCollection = queryDyn.getDynamicObjectCollection("queryrelationenrtry");
        DynamicObjectCollection relConditionCollection = queryDyn.getDynamicObjectCollection("queryrelaconditionentry");
        DynamicObject mainEntityObj = queryApiConfigDyn.getDynamicObject("mainentityobj");
        String mainEntityNumber = mainEntityObj.getString("number");
        relEntryEntityCollection.forEach(relEntryEntity -> {
            DynamicObject leftEntityObj = relEntryEntity.getDynamicObject("leftentityobj");
            DynamicObject rightEntityObj = relEntryEntity.getDynamicObject("rightentityobj");
            Arrays.asList(leftEntityObj, rightEntityObj).forEach(entityObj -> {
                if (entityObj != null && !entityNumberSet.contains(entityObj.getString("number"))) {
                    DynamicObject queryEntity = queryEntityCollection.addNew();
                    queryEntity.set("entityalias", (Object)entityObj.getString("number"));
                    queryEntity.set("entitynumber", (Object)entityObj.getString("number"));
                    queryEntity.set("entityname", (Object)entityObj.getString("name"));
                    entityNumberSet.add(entityObj.getString("number"));
                }
            });
            if (leftEntityObj != null && rightEntityObj != null) {
                DynamicObject queryRelation = queryRelationCollection.addNew();
                queryRelation.set("parententityalias", (Object)leftEntityObj.getString("number"));
                queryRelation.set("childentityalias", (Object)rightEntityObj.getString("number"));
                queryRelation.set("childentitynumber", (Object)rightEntityObj.getString("number"));
                queryRelation.set("combinationtype", (Object)"LeftJoin");
            }
            if (leftEntityObj != null && rightEntityObj != null) {
                DynamicObject relCondition = relConditionCollection.addNew();
                String leftEntityNumber = leftEntityObj.getString("number");
                String fieldPrefix = mainEntityNumber.equals(leftEntityNumber) ? "" : leftEntityNumber + ".";
                String rightEntityNumber = rightEntityObj.getString("number");
                relCondition.set("relaparententityprop", (Object)(fieldPrefix + relEntryEntity.getString("leftentityfield")));
                relCondition.set("relaparentdisplayname", (Object)new LocaleString(relEntryEntity.getString("leftentityfieldname")));
                relCondition.set("relachildentityprop", (Object)(rightEntityNumber + "." + relEntryEntity.getString("rightentityfield")));
                relCondition.set("relachilddisplayname", (Object)new LocaleString(relEntryEntity.getString("rightentityfieldname")));
                relCondition.set("relaconditiontype", (Object)"=");
            }
        });
    }

    private Set<String> getOpenApiNumberByMidTableConfig(DynamicObject[] queryApiConfigDyns) {
        return Arrays.stream(queryApiConfigDyns).map(queryApiConfig -> queryApiConfig.getString("number") + "/" + "query").collect(Collectors.toSet());
    }

    private List<DynamicObject> packageOpenApiDyList(DynamicObject[] queryApiConfigDyns) {
        ArrayList<DynamicObject> openApiObjectList = new ArrayList<DynamicObject>(queryApiConfigDyns.length);
        for (DynamicObject queryApiConfig : queryApiConfigDyns) {
            DynamicObject openApiObject = this.openApiEntityService.generateEmptyDynamicObject();
            this.makeOpenApiDyn(openApiObject, queryApiConfig);
            openApiObjectList.add(openApiObject);
        }
        return openApiObjectList;
    }

    private void makeOpenApiDyn(DynamicObject openApiObject, DynamicObject queryApiConfig) {
        this.setApi(openApiObject, queryApiConfig);
        this.setApiBody(openApiObject, queryApiConfig);
        this.setApiResp(openApiObject, queryApiConfig);
        openApiObject.set("errorcodeentity", (Object)this.setErrorCode());
    }

    private void setApi(DynamicObject openApiObject, DynamicObject queryApiConfig) {
        Date today = new Date();
        openApiObject.set("number", (Object)(queryApiConfig.getString("number") + "/" + "query"));
        openApiObject.set("name", (Object)queryApiConfig.getString("name"));
        openApiObject.set("httpmethod", (Object)queryApiConfig.getString("requestmethod"));
        openApiObject.set("createtime", (Object)today);
        openApiObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        openApiObject.set("appid_id", (Object)"33ZTSDV7P6VX");
        openApiObject.set("customsort", (Object)"1979783346359884800");
        openApiObject.set("urlformat", (Object)String.format(Locale.ROOT, "/v2/hrdi/%s/query", queryApiConfig.getString("number")));
        openApiObject.set("enable", (Object)"1");
        openApiObject.set("status", (Object)"C");
        openApiObject.set("apiservicetype", (Object)"3");
        openApiObject.set("isoutparawithoutstatus", (Object)"1");
        openApiObject.set("version", (Object)"2");
        String isvId = ISVServiceHelper.getISVInfo().getId();
        openApiObject.set("isvid", (Object)isvId);
        openApiObject.set("cosmicver", (Object)"4.0.004");
        openApiObject.set("stdmodifytime", (Object)today);
        openApiObject.set("discription", (Object)ResManager.loadKDString((String)"HR\u6570\u636e\u96c6\u6210\u4e2d\u5fc3\u52a8\u6001\u67e5\u8be2API\u63a5\u53e3\u670d\u52a1", (String)"QueryApiConfigDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        String tableNumber = queryApiConfig.getString("number");
        DynamicObjectCollection queryParamEntities = queryApiConfig.getDynamicObjectCollection("requestentryentity");
        ArrayList queryParamList = Lists.newArrayListWithExpectedSize((int)queryParamEntities.size());
        String[] limitAndOffset = this.getLimitAndOffSet();
        queryParamList.add(limitAndOffset[0] + ":" + limitAndOffset[0]);
        queryParamList.add(limitAndOffset[1] + ":" + limitAndOffset[1]);
        queryParamEntities.forEach(queryParam -> {
            String paramNumber = queryParam.getString("paramnumber");
            queryParamList.add(paramNumber + ":" + paramNumber);
        });
        String queryParamBody = String.join((CharSequence)",", queryParamList);
        openApiObject.set("prescript_tag", (Object)String.format(Locale.ROOT, PRESCRIPT_TAG, queryParamBody, tableNumber));
    }

    private void setApiBody(DynamicObject openApiObject, DynamicObject queryApiConfig) {
        DynamicObjectCollection treeEntryEntities = queryApiConfig.getDynamicObjectCollection("requestentryentity");
        DynamicObjectCollection bodyEntryEntity = new DynamicObjectCollection();
        String[] limitAndOffset = this.getLimitAndOffSet();
        Stream.of(limitAndOffset).forEach(param -> {
            DynamicObject paramBodyDyn = this.openApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
            paramBodyDyn.set("paramname", param);
            paramBodyDyn.set("paramtype", (Object)Integer.class.getSimpleName());
            paramBodyDyn.set("is_req_mul_value", (Object)"0");
            paramBodyDyn.set("body_level", (Object)"1");
            if (param.equals(limitAndOffset[0])) {
                paramBodyDyn.set("bodyparamdes", (Object)new LocaleString(this.limit));
                paramBodyDyn.set("example", (Object)"1000");
            } else {
                paramBodyDyn.set("bodyparamdes", (Object)new LocaleString(this.offSet));
                paramBodyDyn.set("example", (Object)"0");
            }
            paramBodyDyn.set("must", (Object)"0");
            bodyEntryEntity.add((Object)paramBodyDyn);
        });
        treeEntryEntities.forEach(requestParam -> {
            DynamicObject bodyDyn = this.openApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
            bodyDyn.set("paramname", (Object)requestParam.getString("paramnumber"));
            bodyDyn.set("paramtype", (Object)requestParam.getString("paramtype"));
            bodyDyn.set("is_req_mul_value", (Object)(requestParam.getBoolean("mulvalue") ? "1" : "0"));
            bodyDyn.set("body_level", (Object)"1");
            String paramDescription = requestParam.getString("paramdescription");
            if (StringUtils.isEmpty((CharSequence)paramDescription)) {
                paramDescription = requestParam.getString("paramname");
            }
            bodyDyn.set("bodyparamdes", (Object)paramDescription);
            bodyDyn.set("must", (Object)(requestParam.getBoolean("must") ? "1" : "0"));
            bodyDyn.set("example", OpenApiHrdiUtils.getDefaultValueByValueType((String)requestParam.getString("paramtype")));
            bodyEntryEntity.add((Object)bodyDyn);
        });
        openApiObject.set("bodyentryentity", (Object)bodyEntryEntity);
    }

    private String[] getLimitAndOffSet() {
        String limitAndOffsetStr = this.configDomainService.queryBaseConfigValueByNumber("int.query.page.limit_offset");
        return limitAndOffsetStr.split(",");
    }

    private void setApiResp(DynamicObject openApiObject, DynamicObject queryApiConfig) {
        DynamicObjectCollection dynCollection = new DynamicObjectCollection();
        ArrayList<OpenApiEntry> respList = new ArrayList<OpenApiEntry>();
        respList.add(new OpenApiEntry("result", "Struct", "1", "1", "result", "1", "result"));
        long dataId = ID.genLongId();
        respList.forEach(row -> {
            DynamicObject resp = this.openApiEntityService.generateEmptyEntryDynamicObject("respentryentity");
            resp.set("respparamname", (Object)row.getParamName());
            resp.set("respparamtype", (Object)row.getParamType());
            resp.set("is_resp_mul_value", (Object)row.getMulValue());
            resp.set("resp_level", (Object)row.getLevel());
            resp.set("respdes", (Object)row.getParamDes());
            resp.set("respexample", (Object)row.getExample());
            resp.set("id", (Object)dataId);
            dynCollection.add((Object)resp);
        });
        DynamicObjectCollection queryFieldEntry = queryApiConfig.getDynamicObjectCollection("queryentryentity");
        queryFieldEntry.forEach(queryField -> {
            DynamicObject resp = this.openApiEntityService.generateEmptyEntryDynamicObject("respentryentity");
            String paramType = queryField.getString("fieldvaluetype");
            resp.set("respparamname", (Object)queryField.getString("fieldalias"));
            resp.set("respparamtype", (Object)paramType);
            resp.set("is_resp_mul_value", (Object)"0");
            resp.set("resp_level", (Object)"2");
            resp.set("respdes", (Object)queryField.getString("fielddescription"));
            resp.set("respexample", OpenApiHrdiUtils.getDefaultValueByValueType((String)paramType));
            resp.set("pid", (Object)dataId);
            dynCollection.add((Object)resp);
        });
        openApiObject.set("respentryentity", (Object)dynCollection);
    }

    private DynamicObjectCollection setErrorCode() {
        DynamicObjectCollection dynCollection = new DynamicObjectCollection();
        for (ApiErrorCodeCustom item : ApiErrorCodeCustom.values()) {
            DynamicObject errorCodeDyn = this.openApiEntityService.generateEmptyEntryDynamicObject("errorcodeentity");
            errorCodeDyn.set("errorcode", (Object)item.getCode());
            errorCodeDyn.set("errorcodedesc", item.getErrorMsg().get());
            dynCollection.add((Object)errorCodeDyn);
        }
        return dynCollection;
    }
}

