/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.queryapi.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.lang.Lang;
import kd.hdtc.hrdi.business.domain.queryapi.enums.ConditionOperatorEnum;
import kd.hdtc.hrdi.business.domain.queryapi.enums.ParamTypeEnum;
import kd.hdtc.hrdi.business.domain.queryapi.utils.TypeOperatorsUtil;

public class HRFilterOptUtil {
    private static final Map<String, Map<String, List<Map<String, String>>>> OPT_MAP = Maps.newConcurrentMap();

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMapNoCache() {
        List<Map<String, String>> objectOptList = TypeOperatorsUtil.getObjectComparisonOperators();
        HashMap comparisonOperatorsMap = Maps.newHashMapWithExpectedSize((int)16);
        comparisonOperatorsMap.put(ParamTypeEnum.BOOLEAN.getValue(), TypeOperatorsUtil.getBooleanComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.DATE.getValue(), TypeOperatorsUtil.getDateComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.STRING.getValue(), TypeOperatorsUtil.getStringComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.NUMBER.getValue(), TypeOperatorsUtil.getNumberComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.DYNAMICOBJECT.getValue(), objectOptList);
        comparisonOperatorsMap.put(ParamTypeEnum.MUL_DYNAMICOBJECT.getValue(), HRFilterOptUtil.getMulObjectComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.BASEDATA.getValue(), objectOptList);
        comparisonOperatorsMap.put(ParamTypeEnum.ENUM.getValue(), TypeOperatorsUtil.getEnumComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.MUL_ENUM.getValue(), HRFilterOptUtil.getMulEnumComparisonOperators());
        return comparisonOperatorsMap;
    }

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMap() {
        Map<String, List<Map<String, String>>> comparisonOperatorsMap = OPT_MAP.get(Lang.get().getLangTag());
        if (null != comparisonOperatorsMap) {
            return comparisonOperatorsMap;
        }
        comparisonOperatorsMap = HRFilterOptUtil.getComparisonOperatorsMapNoCache();
        OPT_MAP.put(Lang.get().getLangTag(), comparisonOperatorsMap);
        return comparisonOperatorsMap;
    }

    public static List<Map<String, String>> getMulObjectComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(ConditionOperatorEnum.IN.getOperatorMap());
        paramList.add(ConditionOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(ConditionOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(ConditionOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getMulEnumComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(ConditionOperatorEnum.IN.getOperatorMap());
        paramList.add(ConditionOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(ConditionOperatorEnum.COMBOBOX_IS_NULL.getOperatorMap());
        paramList.add(ConditionOperatorEnum.COMBOBOX_IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    static {
        OPT_MAP.put(Lang.get().getLangTag(), HRFilterOptUtil.getComparisonOperatorsMapNoCache());
    }
}

