/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.task.datamapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.entity.IHricMidtableTplEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.datamapping.IDataMappingRecordDomainService;
import kd.hdtc.hrdi.business.domain.datamapping.bo.HRICDataMappingBo;
import kd.hdtc.hrdi.business.domain.datamapping.param.DataMappingRecordParam;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;

public class DataMappingTask
extends AbstractTask {
    private static Log LOG = LogFactory.getLog(DataMappingTask.class);
    private IDataMappingRecordDomainService dataMappingRecordDomainService = ServiceFactory.getService(IDataMappingRecordDomainService.class);
    private IHricMidtableTplEntityService midTableTplEntityService = ServiceFactory.getService(IHricMidtableTplEntityService.class);
    private IIntSourceDomainService intSourceDomainService = ServiceFactory.getService(IIntSourceDomainService.class);
    private IHRDIBaseConfigDomainService baseConfigDomainService = ServiceFactory.getService(IHRDIBaseConfigDomainService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("handle task of DataMappingTask has start time: {}", (Object)System.currentTimeMillis());
        Object batchNumber = map.get("batchnumber");
        if (batchNumber == null) {
            LOG.error("handle task of DataMappingTask has error: this batchNumber is null");
            this.doFinish();
            return;
        }
        List<DataMappingRecordParam> dataMappingRecordParams = this.getDataMappingRecordParams(map.get("intSourceIds"));
        if (CollectionUtils.isEmpty(dataMappingRecordParams)) {
            LOG.error("handle task of DataMappingTask has finish, the reason is the dataMappingRecordParams is empty");
            this.doFinish();
            return;
        }
        this.dataMappingRecordDomainService.initDataMappingRecord(String.valueOf(batchNumber), dataMappingRecordParams);
        Object[] dynamicObjects = this.dataMappingRecordDomainService.queryDataMappingRecord(String.valueOf(batchNumber));
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            LOG.error("handle task of DataMappingTask has finish, the reason is the dynamicObjects is empty");
            this.doFinish();
            return;
        }
        String pageSize = this.baseConfigDomainService.queryBaseConfigValueByNumber("init.data.mapping.max.count");
        LOG.info("the queryBaseConfigValue pageSize is : {}", (Object)pageSize);
        int totalCount = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getInt("totalcount")).reduce(Integer::sum).orElse(0);
        int handleCount = 0;
        for (Object dataMappingRecord : dynamicObjects) {
            int temCount;
            String entityObj = dataMappingRecord.getString("intsource.entityobj.id");
            if (StringUtils.isEmpty((String)entityObj)) continue;
            HRICDataMappingBo dataMappingBo = new HRICDataMappingBo((DynamicObject)dataMappingRecord);
            int dbCount = dataMappingRecord.getInt("totalcount");
            int count = 0;
            String midTableNumber = dataMappingRecord.getString("midtablenumber");
            do {
                DynamicObject[] midTableDataList;
                if ((temCount = (midTableDataList = this.midTableTplEntityService.getMidTableDataList(midTableNumber, dataMappingBo.getMidTableCovert().queryFields(), Long.parseLong(dataMappingRecord.getString("startoffset")), Long.parseLong(dataMappingRecord.getString("endoffset")), Integer.parseInt(pageSize))).length) == 0) {
                    dataMappingBo.saveDataMappingFinish((DynamicObject)dataMappingRecord);
                    continue;
                }
                LOG.info("handle task of DataMappingTask to saveDataMapping start: {}", (Object)System.currentTimeMillis());
                dataMappingBo.saveDataMapping(Arrays.asList(midTableDataList));
                count += temCount;
                this.feedbackProgress(this.getProgressValue(totalCount, handleCount += temCount));
            } while (dbCount >= count && temCount > 0);
        }
        this.doFinish();
        LOG.info("handle task of DataMappingTask has ent time: {}", (Object)System.currentTimeMillis());
    }

    private List<DataMappingRecordParam> getDataMappingRecordParams(Object intSourceIds) {
        if (intSourceIds == null) {
            LOG.error("handle task of DataMappingTask has error, the reason is intSourceIds is empty");
            return null;
        }
        Map<Long, DynamicObject> intSourceMap = this.intSourceDomainService.queryByIds((List)intSourceIds);
        if (CollectionUtils.isEmpty(intSourceMap)) {
            LOG.error("handle task of DataMappingTask has error, the reason is intSourceMap is empty");
            return null;
        }
        ArrayList dataMappingRecordParams = Lists.newArrayListWithExpectedSize((int)intSourceMap.size());
        intSourceMap.forEach((intSourceId, intSourceDynamic) -> {
            DynamicObjectCollection initEntityObject;
            DataMappingRecordParam dataMappingRecordParam = new DataMappingRecordParam();
            dataMappingRecordParam.setIntResource((DynamicObject)intSourceDynamic);
            String entityObjectId = intSourceDynamic.getString("entityobj.number");
            dataMappingRecordParam.setEntityObject(entityObjectId);
            dataMappingRecordParam.setAppNumber(EntityMetadataCache.getDataEntityType((String)entityObjectId).getBizAppNumber());
            DynamicObject midTableConfig = intSourceDynamic.getDynamicObject("midtableconfig");
            if (midTableConfig != null && CollectionUtils.isNotEmpty((Collection)(initEntityObject = midTableConfig.getDynamicObjectCollection("initentityobject")))) {
                HashSet initEntityObjects = Sets.newHashSetWithExpectedSize((int)initEntityObject.size());
                for (DynamicObject dynamicObject : initEntityObject) {
                    initEntityObjects.add(dynamicObject.getString("fbasedataid_id"));
                }
                dataMappingRecordParam.setInitEntityObject(initEntityObjects);
                Map<String, Set<String>> initMidTableNumber = this.midTableTplEntityService.entityRefMidTableNumber(initEntityObjects);
                dataMappingRecordParam.setInitMidTableNumber(initMidTableNumber);
                dataMappingRecordParams.add(dataMappingRecordParam);
            }
        });
        return dataMappingRecordParams;
    }

    private void doFinish() {
        this.feedbackProgress(99);
    }

    private int getProgressValue(int totalCount, int count) {
        BigDecimal countBig = new BigDecimal(count);
        BigDecimal totalBig = new BigDecimal(totalCount);
        if (totalBig.compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        if (count == 0) {
            return count;
        }
        BigDecimal result = countBig.divide(totalBig, 2, 4).multiply(new BigDecimal(100));
        if (result.compareTo(new BigDecimal(100)) == 0 && totalBig.subtract(countBig).compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        return result.intValue();
    }
}

