/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.task.intlog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IIntLogEntityService;
import kd.hdtc.hrdi.common.enums.OperateStatusEnum;

public class IntLogTask
extends AbstractTask {
    private static Log LOG = LogFactory.getLog(IntLogTask.class);
    private static final String DEFAULT_PROPERTIES = "id, parent, intsource, batchnumber, startnumber, endnumber, selectnumber, operatestatus";
    private final IIntLogDomainService intLogDomainService = ServiceFactory.getService(IIntLogDomainService.class);
    private final IIntLogEntityService intLogEntityService = ServiceFactory.getService(IIntLogEntityService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("the IntLogTask start time: {}", (Object)System.currentTimeMillis());
        Object intLogIds = map.get("intLogIds");
        if (intLogIds == null) {
            LOG.error("the IntLogTask has error: this intLogIds is null");
            this.doFinish();
            return;
        }
        List ids = (List)intLogIds;
        try {
            DynamicObject[] intLogList = this.intLogDomainService.query(DEFAULT_PROPERTIES, ids.toArray());
            HashSet hasHandleIntLogIds = Sets.newHashSetWithExpectedSize((int)intLogList.length);
            ArrayList childIntLogs = Lists.newArrayListWithExpectedSize((int)intLogList.length);
            HashMap parentChildMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet parentIds = Sets.newHashSetWithExpectedSize((int)16);
            Arrays.stream(intLogList).forEach(intLog -> {
                DynamicObject parent = intLog.getDynamicObject("parent");
                if (parent == null) {
                    parentIds.add(intLog.getLong("id"));
                } else {
                    long parentId = parent.getLong("id");
                    List childList = parentChildMap.computeIfAbsent(parentId, key -> new ArrayList());
                    childList.add(intLog);
                    hasHandleIntLogIds.add(intLog.getLong("id"));
                    intLog.set("operatestatus", (Object)OperateStatusEnum.PROCCESSING.getCode());
                    childIntLogs.add(intLog);
                }
            });
            Object[] dynamicObjects = this.intLogDomainService.queryListByParentIdList(new ArrayList<Long>(parentIds));
            if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
                Stream.of(dynamicObjects).forEach(intLog -> {
                    if (!hasHandleIntLogIds.contains(intLog.getLong("id"))) {
                        List childList = parentChildMap.computeIfAbsent(intLog.getLong("parent.id"), key -> new ArrayList());
                        childList.add(intLog);
                        intLog.set("operatestatus", (Object)OperateStatusEnum.PROCCESSING.getCode());
                        childIntLogs.add(intLog);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)childIntLogs)) {
                this.intLogEntityService.save(childIntLogs.toArray(new DynamicObject[0]));
            }
            if (CollectionUtils.isNotEmpty((Map)parentChildMap)) {
                int totalCount = childIntLogs.size();
                AtomicInteger handleCount = new AtomicInteger();
                parentChildMap.forEach((parentId, childList) -> {
                    for (DynamicObject intLog : childList) {
                        this.intLogDomainService.handleIntLogRetry(intLog);
                        handleCount.getAndIncrement();
                    }
                    this.feedbackProgress(this.getProgressValue(totalCount, handleCount.get()));
                });
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        this.doFinish();
    }

    private void doFinish() {
        this.feedbackProgress(99);
    }

    private int getProgressValue(int totalCount, int count) {
        BigDecimal countBig = new BigDecimal(count);
        BigDecimal totalBig = new BigDecimal(totalCount);
        if (totalBig.compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        if (count == 0) {
            return count;
        }
        BigDecimal result = countBig.divide(totalBig, 2, 4).multiply(new BigDecimal(100));
        if (result.compareTo(new BigDecimal(100)) == 0 && totalBig.subtract(countBig).compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        return result.intValue();
    }
}

