/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.task.intlog;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBizSyncDomainService;
import kd.hdtc.hrdi.common.enums.SynTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class IntMidTableTask
extends AbstractTask {
    private static Log LOG = LogFactory.getLog(IntMidTableTask.class);
    private static final String DEFAULT_FIELD = "id, hrdibatchnumber";
    private final IBizSyncDomainService bizSyncDomainService = ServiceFactory.getService(IBizSyncDomainService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("the IntMidTableTask start time: {}", (Object)System.currentTimeMillis());
        Object intLogIds = map.get("intMidIds");
        Object midTable = map.get("midTableNumber");
        if (intLogIds == null || midTable == null) {
            LOG.error("the IntMidTableTask params has error,intLogIds is {}, midTable is {}", intLogIds, midTable);
            this.doFinish();
            return;
        }
        List ids = (List)intLogIds;
        String midTableNumber = (String)midTable;
        try {
            HRBaseServiceHelper midTableServiceHelper = new HRBaseServiceHelper(midTableNumber);
            Object[] midTableData = midTableServiceHelper.query(DEFAULT_FIELD, new QFilter[]{new QFilter("id", "in", (Object)ids)});
            if (ArrayUtils.isNotEmpty((Object[])midTableData)) {
                Map<String, List<DynamicObject>> batchNumberDyListMap = Arrays.stream(midTableData).collect(Collectors.groupingBy(dy -> dy.getString("hrdibatchnumber")));
                int totalCount = batchNumberDyListMap.size();
                AtomicInteger handleCount = new AtomicInteger();
                batchNumberDyListMap.forEach((batchNumber, dyList) -> {
                    List<Long> intMiddleIdList = dyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                    this.bizSyncDomainService.bizSync(midTableNumber, (String)batchNumber, intMiddleIdList, null, SynTypeEnum.MIDDLE_MANUAL_RETRY.getCode());
                    handleCount.getAndIncrement();
                    this.feedbackProgress(this.getProgressValue(totalCount, handleCount.get()));
                });
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        this.doFinish();
    }

    private void doFinish() {
        this.feedbackProgress(99);
    }

    private int getProgressValue(int totalCount, int count) {
        BigDecimal countBig = new BigDecimal(count);
        BigDecimal totalBig = new BigDecimal(totalCount);
        if (totalBig.compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        if (count == 0) {
            return count;
        }
        BigDecimal result = countBig.divide(totalBig, 2, 4).multiply(new BigDecimal(100));
        if (result.compareTo(new BigDecimal(100)) == 0 && totalBig.subtract(countBig).compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        return result.intValue();
    }
}

