/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.task.msgrecordlog;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IMsgRecordLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;

public class MsgRecordLogTask
extends AbstractTask {
    private static Log LOG = LogFactory.getLog(MsgRecordLogTask.class);
    private static final String DEFAULT_PROPERTIES = "id,intsource,sourcesys,operatestatus,errorinfo,errorinfo_tag,entitycategory,msgnumber,msgcontent,msgcontent_tag,msgtype";
    private final IMsgRecordLogEntityService msgRecordLogEntityService = ServiceFactory.getService(IMsgRecordLogEntityService.class);
    private final IMsgRecordLogDomainService msgRecordLogDomainService = ServiceFactory.getService(IMsgRecordLogDomainService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("the MsgRecordLogTask start time: {}", (Object)System.currentTimeMillis());
        Object msgRecordLogIds = map.get("msgRecordLogIds");
        if (msgRecordLogIds == null) {
            LOG.error("the MsgRecordLogTask params has error,msgRecordLogIds is {}", msgRecordLogIds);
            this.doFinish();
            return;
        }
        List ids = (List)msgRecordLogIds;
        try {
            Object[] msgRecordLogs = this.msgRecordLogEntityService.query(DEFAULT_PROPERTIES, ids.toArray(new Object[0]));
            if (ArrayUtils.isNotEmpty((Object[])msgRecordLogs)) {
                int totalCount = msgRecordLogs.length;
                AtomicInteger handleCount = new AtomicInteger();
                Stream.of(msgRecordLogs).forEach(msgRecordLog -> {
                    this.msgRecordLogDomainService.handleMsgRecordLogRetry((DynamicObject)msgRecordLog);
                    handleCount.getAndIncrement();
                    this.feedbackProgress(this.getProgressValue(totalCount, handleCount.get()));
                });
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        this.doFinish();
    }

    private void doFinish() {
        this.feedbackProgress(99);
    }

    private int getProgressValue(int totalCount, int count) {
        BigDecimal countBig = new BigDecimal(count);
        BigDecimal totalBig = new BigDecimal(totalCount);
        if (totalBig.compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        if (count == 0) {
            return count;
        }
        BigDecimal result = countBig.divide(totalBig, 2, 4).multiply(new BigDecimal(100));
        if (result.compareTo(new BigDecimal(100)) == 0 && totalBig.subtract(countBig).compareTo(new BigDecimal(0)) == 0) {
            return 99;
        }
        return result.intValue();
    }
}

