/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.warn;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnWriteOut;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.IIntWarnLogDomainService;
import kd.hdtc.hrdi.common.enums.WarnStatusEnum;

public class IntLogWarnWriteOut
implements IEarlyWarnWriteOut {
    private static final Log LOGGER = LogFactory.getLog(IntLogWarnWriteOut.class);
    private final IIntWarnLogDomainService iIntWarnLogDomainService = ServiceFactory.getService(IIntWarnLogDomainService.class);
    private final IIntLogDomainService iIntLogDomainService = ServiceFactory.getService(IIntLogDomainService.class);

    public void writeOut(DynamicObjectCollection dynamicObjectCollection, EarlyWarnContext earlyWarnContext) {
        DynamicObjectCollection warnDataList = earlyWarnContext.getWarnDataList();
        if (CollectionUtils.isEmpty((Collection)warnDataList)) {
            LOGGER.warn("warnDataList is empty");
        } else {
            Set<String> intNumberSet = dynamicObjectCollection.stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
            DynamicObject intWarnLog = this.iIntWarnLogDomainService.generateIntWarnLog(intNumberSet, String.valueOf(ID.genLongId()));
            earlyWarnContext.getCustomDataMap().put("intWarnLogId", intWarnLog.getLong("id"));
            this.iIntWarnLogDomainService.saveIntWarnLog(intWarnLog);
            this.iIntLogDomainService.updateIntLogWarnStatus(intNumberSet, WarnStatusEnum.WARNED);
        }
    }
}

