/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.adaptor.form;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.common.adaptor.enums.IntSceneEnum;
import kd.hdtc.hrdi.common.adaptor.utils.EntityFieldToComboItemUtil;
import kd.hdtc.hrdi.formplugin.web.common.form.AbstractBaseDataEditPlugin;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;

public class IntSceneRuleEditPlugin
extends AbstractBaseDataEditPlugin {
    private final Set<String> DEFAULT_SCENE = ImmutableSet.of((Object)IntSceneEnum.NEW.getSceneType(), (Object)IntSceneEnum.ENABLE.getSceneType(), (Object)IntSceneEnum.DISABLE.getSceneType(), (Object)IntSceneEnum.CHANGE.getSceneType(), (Object)IntSceneEnum.DELETE.getSceneType());
    private final Set<String> DEFAULT_WRITE_TYPE = ImmutableSet.of((Object)"1", (Object)"2");
    private final Map<String, String> NORMAL_OP = ImmutableMap.of((Object)IntSceneEnum.NEW.getSceneType(), (Object)"save", (Object)IntSceneEnum.ENABLE.getSceneType(), (Object)"enable", (Object)IntSceneEnum.DISABLE.getSceneType(), (Object)"disable", (Object)IntSceneEnum.CHANGE.getSceneType(), (Object)"save", (Object)IntSceneEnum.DELETE.getSceneType(), (Object)"delete");
    private final Map<String, String> LINE_HIS_OP = ImmutableMap.of((Object)IntSceneEnum.NEW.getSceneType(), (Object)"save", (Object)IntSceneEnum.ENABLE.getSceneType(), (Object)"enable", (Object)IntSceneEnum.DISABLE.getSceneType(), (Object)"his_disable", (Object)IntSceneEnum.CHANGE.getSceneType(), (Object)"confirmchange", (Object)IntSceneEnum.DELETE.getSceneType(), (Object)"delete");
    private final Map<String, String> NON_LINE_HIS_OP = ImmutableMap.of((Object)IntSceneEnum.NEW.getSceneType(), (Object)"save", (Object)IntSceneEnum.ENABLE.getSceneType(), (Object)"enable", (Object)IntSceneEnum.DISABLE.getSceneType(), (Object)"his_disable", (Object)IntSceneEnum.CHANGE.getSceneType(), (Object)"auditconfirmchange", (Object)IntSceneEnum.DELETE.getSceneType(), (Object)"delete");

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit entityObjEdit = (BasedataEdit)this.getControl("entityobj");
        entityObjEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        String entityId = this.getModel().getDataEntity().getString("entityobj.id");
        this.initReferenceFieldItems(entityId);
        this.initWriteType();
        this.initSceneType();
        this.initSceneRuleEntry();
    }

    private void initSceneRuleEntry() {
        String writeType = this.getModel().getDataEntity().getString("writetype");
        if ("0".equals(writeType)) {
            return;
        }
        DynamicObjectCollection ruleEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("ruleentry");
        if (ruleEntry.size() == 0) {
            this.DEFAULT_SCENE.forEach(scene -> {
                DynamicObject entryDyn = ruleEntry.addNew();
                entryDyn.set("scenetype", scene);
            });
        }
        this.getModel().beginInit();
        this.getModel().setValue("ruleentry", (Object)ruleEntry);
        this.getModel().endInit();
        this.getView().updateView("ruleentry");
    }

    private void initSceneType() {
        String writeType = this.getModel().getDataEntity().getString("writetype");
        if (!"0".equals(writeType)) {
            ComboEdit sceneTypeCombo = (ComboEdit)this.getControl("scenetype");
            List sceneTypeList = ((ComboProp)sceneTypeCombo.getProperty()).getComboItems();
            sceneTypeCombo.setComboItems(this.getComboItems(sceneTypeList, this.DEFAULT_SCENE));
        }
    }

    private void initWriteType() {
        String writeType = this.getModel().getDataEntity().getString("writetype");
        if (!"0".equals(writeType)) {
            ComboEdit writeTypeCombo = (ComboEdit)this.getControl("writetype");
            List writeTypeList = ((ComboProp)writeTypeCombo.getProperty()).getComboItems();
            writeTypeCombo.setComboItems(this.getComboItems(writeTypeList, this.DEFAULT_WRITE_TYPE));
        }
    }

    private List<ComboItem> getComboItems(List<ValueMapItem> valueMapItemList, Set<String> excloudValueSet) {
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        valueMapItemList.forEach(dy -> {
            if (excloudValueSet.contains(dy.getValue())) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(dy.getName());
                comboItem.setValue(dy.getValue());
                itemList.add(comboItem);
            }
        });
        return itemList;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "entityobj": {
                this.setReferenceFieldItems(args);
                this.setIntSceneRule();
                break;
            }
            case "writetype": {
                this.setIntSceneRule();
                break;
            }
        }
    }

    private void setIntSceneRule() {
        String writeType = this.getModel().getDataEntity().getString("writetype");
        if (!"1".equals(writeType)) {
            return;
        }
        String entityNumber = this.getModel().getDataEntity().getString("entityobj.id");
        Map<String, String> opMap = this.getCommonOp(entityNumber);
        DynamicObjectCollection ruleEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("ruleentry");
        for (DynamicObject entryDyn : ruleEntry) {
            String op = entryDyn.getString("operate");
            String sceneType = entryDyn.getString("scenetype");
            if (!StringUtils.isEmpty((String)op) && !this.LINE_HIS_OP.get(sceneType).equals(op) && !this.NORMAL_OP.get(sceneType).equals(op)) continue;
            entryDyn.set("operate", (Object)opMap.get(sceneType));
        }
        this.getView().updateView("ruleentry");
    }

    private Map<String, String> getCommonOp(String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return this.NORMAL_OP.keySet().stream().collect(Collectors.toMap(op -> op, op -> ""));
        }
        String entityTpl = HisModelController.getInstance().entityInhRelation(entityNumber);
        if (EnumEntityTpl.COMMON_TPL.getNumber().equals(entityTpl)) {
            return this.NORMAL_OP;
        }
        if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityTpl)) {
            return this.LINE_HIS_OP;
        }
        if (EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityTpl)) {
            return this.NON_LINE_HIS_OP;
        }
        return this.NORMAL_OP;
    }

    private void setReferenceFieldItems(PropertyChangedArgs args) {
        DynamicObject bizObj = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (bizObj == null) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("referencefield");
            comboEdit.setComboItems(null);
            return;
        }
        String entityId = bizObj.getString("id");
        this.initReferenceFieldItems(entityId);
        this.getModel().setValue("referencefield", null);
    }

    private void initReferenceFieldItems(String entityId) {
        if (StringUtils.isEmpty((String)entityId)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("referencefield");
        List comboItems = EntityFieldToComboItemUtil.getEntityItems((String)entityId, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)comboItems)) {
            return;
        }
        comboEdit.setComboItems(comboItems);
    }
}

