/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.adaptor.list;

import com.google.common.collect.ImmutableList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseList;

public class CommonPermListPlugin
extends HDTCDataBaseList {
    private static final List<String> NEED_CHECK_PERM_OPERATE_LIST = ImmutableList.of((Object)"new", (Object)"modify", (Object)"delete", (Object)"disable", (Object)"enable");

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        String operateKey = ((FormOperate)beforeDoOperationEventArgs.getSource()).getOperateKey();
        if (NEED_CHECK_PERM_OPERATE_LIST.contains(operateKey) && !this.checkPerm(beforeDoOperationEventArgs)) {
            beforeDoOperationEventArgs.setCancel(true);
        }
    }

    private boolean checkPerm(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        long userId = RequestContext.get().getCurrUserId();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
        if (!adminUser) {
            String entityName = this.getView().getFormShowParameter().getFormName();
            String operateName = ((FormOperate)beforeDoOperationEventArgs.getSource()).getOperateName().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\u3002", (String)"CommonPermListPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), entityName, operateName));
            return false;
        }
        return true;
    }
}

