/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.apilink.form;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.network.CheckBean;
import kd.hdtc.hrdbs.common.util.network.CheckNetWorkUtil;
import kd.hdtc.hrdbs.common.util.network.CheckResult;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.apilink.IAPILinkConfigDomainService;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;

public class CheckNetworkFormPlugin
extends HDTCDataBaseEdit {
    private final IAPILinkConfigDomainService domainService = (IAPILinkConfigDomainService)ServiceFactory.getService(IAPILinkConfigDomainService.class);
    private final String PING_COST = ResManager.loadKDString((String)"ping\u8017\u65f6\uff1a%sms\u3002", (String)"CheckNetWorkThread_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String TELNET_SUCCESS = ResManager.loadKDString((String)"Telnet\u6210\u529f\uff0c\u8017\u65f6\uff1a%sms\u3002", (String)"CheckNetWorkThread_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String TELENT_FAIL = ResManager.loadKDString((String)"Telnet\u8fde\u63a5\u5931\u8d25\uff0c\u8017\u65f6\uff1a%sms\u3002", (String)"CheckNetWorkThread_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String FAIL_TIP = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"CheckNetWorkThread_3", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String IP_ERROR = ResManager.loadKDString((String)"ip\u6216\u57df\u540d\u4e3a\u7a7a", (String)"CheckNetWorkThread_4", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String PORT_ERROR = ResManager.loadKDString((String)"\u7f51\u7edc\u7aef\u53e3\u4e0d\u5408\u6cd5", (String)"CheckNetWorkThread_5", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final IHRDIBaseConfigDomainService baseConfigDomainService = (IHRDIBaseConfigDomainService)ServiceFactory.getService(IHRDIBaseConfigDomainService.class);

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        Long apilink = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject apiLinkDyn = this.domainService.queryById(apilink);
        this.getModel().setValue("server_ip", (Object)apiLinkDyn.getString("server_ip"));
        this.getModel().setValue("server_port", (Object)apiLinkDyn.getString("server_port"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("check_ping".equals(operateKey) || "check_telnet".equals(operateKey)) {
            this.handleCommand(args);
        }
    }

    private void handleCommand(AfterDoOperationEventArgs args) {
        String ip = (String)this.getModel().getValue("server_ip");
        int port = Integer.parseInt((String)this.getModel().getValue("server_port"));
        String operateKey = args.getOperateKey();
        this.paramCheck(ip, port, operateKey);
        this.networkCheck(ip, port, operateKey);
    }

    public void networkCheck(String ip, int port, String operateKey) {
        String resultMsg = null;
        if ("check_ping".equals(operateKey)) {
            CheckResult result = CheckNetWorkUtil.ping((CheckBean)new CheckBean(ip, 5000));
            resultMsg = this.getResultMsg(result, this.PING_COST, this.PING_COST);
        } else if ("check_telnet".equals(operateKey)) {
            CheckResult result = CheckNetWorkUtil.telnet((CheckBean)new CheckBean(ip, port, 5000));
            resultMsg = this.getResultMsg(result, this.TELNET_SUCCESS, this.TELENT_FAIL);
        }
        this.getView().getModel().setValue("check_result", resultMsg);
    }

    private String getResultMsg(CheckResult result, String successTip, String failTip) {
        String resultMsg;
        if (result.isSuccess()) {
            String successMsg = result.getMsg();
            if (StringUtils.isEmpty((String)successMsg)) {
                successMsg = "";
            }
            resultMsg = String.format(Locale.ROOT, successTip, result.getTimespan()) + "\r\n" + successMsg;
        } else {
            String errorMsg = result.getMsg();
            if (!this.isShowExceptionInfo() && result.getException() != null) {
                errorMsg = result.getException().fillInStackTrace().getClass().getSimpleName();
            }
            resultMsg = String.format(Locale.ROOT, failTip, result.getTimespan()) + "\r\n" + String.format(Locale.ROOT, this.FAIL_TIP, errorMsg);
        }
        return resultMsg;
    }

    private boolean isShowExceptionInfo() {
        String showException = this.baseConfigDomainService.queryBaseConfigValueByNumber("is.show.exception.info");
        return StringUtils.equals((String)"1", (String)showException);
    }

    private void paramCheck(String ip, int port, String operateKey) {
        if ("check_ping".equals(operateKey)) {
            if (StringUtils.isEmpty((String)ip)) {
                throw new HDTCBizException(this.IP_ERROR);
            }
        } else if ("check_telnet".equals(operateKey)) {
            if (StringUtils.isEmpty((String)ip)) {
                throw new HDTCBizException(this.IP_ERROR);
            }
            if (port <= 0) {
                throw new HDTCBizException(this.PORT_ERROR);
            }
        }
    }
}

